/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.identity;

import com.google.common.collect.Lists;
import java.util.List;
import org.gnunet.identity.IdentityCallback;
import org.gnunet.identity.IdentityContinuation;
import org.gnunet.identity.IdentityListCallback;
import org.gnunet.identity.messages.CreateRequestMessage;
import org.gnunet.identity.messages.DeleteMessage;
import org.gnunet.identity.messages.GetDefaultMessage;
import org.gnunet.identity.messages.RenameMessage;
import org.gnunet.identity.messages.ResultCodeMessage;
import org.gnunet.identity.messages.SetDefaultMessage;
import org.gnunet.identity.messages.StartMessage;
import org.gnunet.identity.messages.UpdateListMessage;
import org.gnunet.mq.Envelope;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.SequentialRequestContainer;
import org.gnunet.util.Cancelable;
import org.gnunet.util.CancellationToken;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.crypto.EcdsaPrivateKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    private static final Logger logger = LoggerFactory.getLogger(Identity.class);
    private Configuration configuration;
    private SequentialRequestContainer<IdentityRequest> requests;
    private Client client;
    private IdentityListCallback identityListCallback;
    private List<Ego> knownEgos = Lists.newLinkedList();
    private static Ego anonymousEgo;

    public static Cancelable lookup(Configuration configuration, final String egoName, final IdentityCallback identityCallback) {
        final Identity myIdentity = new Identity();
        final CancellationToken cancellationToken = new CancellationToken();
        myIdentity.connect(configuration, new IdentityListCallback(){
            boolean done = false;

            @Override
            public void onEgoAdd(Ego ego) {
                if (this.done) {
                    throw new AssertionError();
                }
                if (ego.name.equals(egoName)) {
                    this.done = true;
                    cancellationToken.cancel();
                    identityCallback.onEgo(ego);
                }
            }

            @Override
            public void onEgoDelete(Ego ego) {
                if (this.done) {
                    throw new AssertionError();
                }
                logger.error("unsolicited ego delete on lookup");
                this.done = true;
                cancellationToken.cancel();
                identityCallback.onError("identity service misbehaved");
            }

            @Override
            public void onEgoRename(String oldName, Ego ego) {
                if (this.done) {
                    throw new AssertionError();
                }
                logger.error("unsolicited ego rename on lookup");
                this.done = true;
                cancellationToken.cancel();
                identityCallback.onError("identity service misbehaved");
            }

            @Override
            public void onListEnd() {
                if (this.done) {
                    throw new AssertionError();
                }
                this.done = true;
                cancellationToken.cancel();
                identityCallback.onError("identity not found");
            }
        });
        cancellationToken.add(new Cancelable(){

            @Override
            public void cancel() {
                myIdentity.disconnect();
            }
        });
        return cancellationToken;
    }

    public static Ego getAnonymousEgo() {
        if (anonymousEgo == null) {
            anonymousEgo = new Ego(null, EcdsaPrivateKey.getAnonymous());
        }
        return anonymousEgo;
    }

    public void connect(Configuration configuration, IdentityListCallback identityListCallback) {
        this.configuration = configuration;
        this.client = new Client("identity", configuration);
        this.client.installReceiver(new IdentityReceiver());
        this.requests = new SequentialRequestContainer(this.client);
        this.identityListCallback = identityListCallback;
        StartMessage m = new StartMessage();
        this.client.send(m);
    }

    public Cancelable get(String serviceName, IdentityCallback identityCallback) {
        return this.requests.addRequest(new GetDefaultRequest(serviceName, identityCallback));
    }

    public Cancelable set(String serviceName, Ego ego) {
        return this.requests.addRequest(new SetDefaultRequest(serviceName, ego));
    }

    public void disconnect() {
        this.client.disconnect();
        this.client = null;
    }

    public Cancelable create(String name, IdentityContinuation cont) {
        EcdsaPrivateKey privateKey = EcdsaPrivateKey.createRandom();
        return this.requests.addRequest(new CreateRequest(name, privateKey, cont));
    }

    public Cancelable rename(String oldName, String newName) {
        return this.requests.addRequest(new RenameRequest(newName, oldName));
    }

    public Cancelable delete(String name) {
        return this.requests.addRequest(new DeleteRequest(name));
    }

    private Ego getEgoForKey(EcdsaPrivateKey privateKey) {
        for (Ego ex : this.knownEgos) {
            if (!ex.privateKey.equals(privateKey)) continue;
            return ex;
        }
        return null;
    }

    public class IdentityReceiver
    extends RunaboutMessageReceiver {
        @Override
        public void handleError() {
            logger.warn("identity service disconnected");
            Identity.this.client.reconnect();
        }

        public void visit(ResultCodeMessage m) {
            RequestIdentifier rId = Identity.this.requests.getRequestIdentifier();
            IdentityRequest r = (IdentityRequest)rId.getRequest();
            if (null == r) {
                logger.warn("unsolicited result code message");
                return;
            }
            if (m.errorMessage != null) {
                r.onError(m.errorMessage);
            } else {
                r.onResult();
            }
            rId.retire();
        }

        public void visit(SetDefaultMessage m) {
            RequestIdentifier rId = Identity.this.requests.getRequestIdentifier();
            IdentityRequest r = (IdentityRequest)rId.getRequest();
            if (!(r instanceof GetDefaultRequest)) {
                logger.error("unexpected 'default ego' response");
                return;
            }
            GetDefaultRequest gdr = (GetDefaultRequest)r;
            Ego ego = Identity.this.getEgoForKey(m.privateKey);
            if (null != ego) {
                gdr.identityCallback.onEgo(ego);
            }
            rId.retire();
        }

        public void visit(UpdateListMessage m) {
            if (m.endOfList != 0) {
                if (null != Identity.this.identityListCallback) {
                    Identity.this.identityListCallback.onListEnd();
                }
                return;
            }
            if (m.nameLength == 0) {
                Ego e = Identity.this.getEgoForKey(m.privateKey);
                if (null != e) {
                    Identity.this.knownEgos.remove(e);
                }
                if (null != Identity.this.identityListCallback) {
                    Identity.this.identityListCallback.onEgoDelete(e);
                }
            } else {
                Ego existingEgo = Identity.this.getEgoForKey(m.privateKey);
                if (existingEgo == null) {
                    Ego ego = new Ego(m.egoName, m.privateKey);
                    Identity.this.knownEgos.add(ego);
                    if (null != Identity.this.identityListCallback) {
                        Identity.this.identityListCallback.onEgoAdd(ego);
                    }
                } else {
                    String oldName = existingEgo.name;
                    existingEgo.name = m.egoName;
                    if (null != Identity.this.identityListCallback) {
                        Identity.this.identityListCallback.onEgoRename(oldName, existingEgo);
                    }
                }
            }
        }
    }

    public class CreateRequest
    extends IdentityRequest {
        final EcdsaPrivateKey privateKey;
        IdentityContinuation cont;
        String name;

        CreateRequest(String name, EcdsaPrivateKey privateKey, IdentityContinuation cont) {
            this.cont = cont;
            this.privateKey = privateKey;
            this.name = name;
        }

        @Override
        public Envelope assembleRequest() {
            CreateRequestMessage m = new CreateRequestMessage();
            m.name = this.name;
            m.nameLength = this.name.length() + 1;
            m.privateKey = this.privateKey;
            return new Envelope(m);
        }

        @Override
        public void onError(String errorMessage) {
            this.cont.onError(errorMessage);
        }

        @Override
        public void onResult() {
            this.cont.onDone();
        }
    }

    public class DeleteRequest
    extends IdentityRequest {
        IdentityContinuation cont;
        String name;

        DeleteRequest(String name) {
            this.name = name;
        }

        @Override
        public Envelope assembleRequest() {
            DeleteMessage m = new DeleteMessage();
            m.name = this.name;
            m.nameLength = this.name.length() + 1;
            return new Envelope(m);
        }

        @Override
        public void onError(String errorMessage) {
            this.cont.onError(errorMessage);
        }

        @Override
        public void onResult() {
            this.cont.onDone();
        }
    }

    public class RenameRequest
    extends IdentityRequest {
        IdentityContinuation cont;
        String oldName;
        String newName;

        RenameRequest(String newName, String oldName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public Envelope assembleRequest() {
            RenameMessage m = new RenameMessage();
            m.newName = this.newName;
            m.newNameLength = this.newName.length() + 1;
            m.oldName = this.oldName;
            m.oldNameLength = this.oldName.length() + 1;
            return new Envelope(m);
        }

        @Override
        public void onError(String errorMessage) {
            this.cont.onError(errorMessage);
        }

        @Override
        public void onResult() {
            this.cont.onDone();
        }
    }

    public class SetDefaultRequest
    extends IdentityRequest {
        IdentityContinuation cont;
        String serviceName;
        Ego ego;

        SetDefaultRequest(String serviceName, Ego ego) {
            this.serviceName = serviceName;
            this.ego = ego;
        }

        @Override
        public Envelope assembleRequest() {
            SetDefaultMessage m = new SetDefaultMessage();
            m.nameLength = this.serviceName.length() + 1;
            m.serviceName = this.serviceName;
            m.privateKey = this.ego.privateKey;
            return new Envelope(m);
        }

        @Override
        public void onError(String errorMessage) {
            this.cont.onError(errorMessage);
        }

        @Override
        public void onResult() {
            this.cont.onDone();
        }
    }

    public class GetDefaultRequest
    extends IdentityRequest {
        IdentityCallback identityCallback;
        String serviceName;

        GetDefaultRequest(String serviceName, IdentityCallback identityCallback) {
            this.identityCallback = identityCallback;
            this.serviceName = serviceName;
        }

        @Override
        public Envelope assembleRequest() {
            GetDefaultMessage m = new GetDefaultMessage();
            m.nameLength = this.serviceName.length() + 1;
            m.serviceName = this.serviceName;
            return new Envelope(m);
        }

        @Override
        public void onError(String errorMessage) {
            this.identityCallback.onError(errorMessage);
        }
    }

    public abstract class IdentityRequest
    extends Request {
        public void onError(String errorMessage) {
            throw new AssertionError((Object)("unexpected error message: " + errorMessage));
        }

        public void onResult() {
            throw new AssertionError((Object)"unexpected result");
        }
    }

    public static class Ego {
        private String name;
        private EcdsaPrivateKey privateKey;

        public Ego(String egoName, EcdsaPrivateKey privateKey) {
            this.name = egoName;
            this.privateKey = privateKey;
        }

        public EcdsaPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public EcdsaPublicKey getPublicKey() {
            return this.privateKey.getPublicKey();
        }

        public String getName() {
            return this.name;
        }
    }
}

