/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRSOFTLINKSOURCE_H_
#define _VRSOFTLINKSOURCE_H_

extern "C" {
#include <unistd.h>
#include <fcntl.h>
#include <netinet/in.h>
}

#include <VrSource.h>
#include <VrIPpacket.h>

class VrSoftLinkSource : public VrSource<VrIPpacket> {
protected:
  int devfd;
public: 
  virtual void work(int n);
  VrSoftLinkSource(double sampling_freq);
  virtual ~VrSoftLinkSource();
};

void
VrSoftLinkSource::work(int n)
{  

  static int packetcount=0;
  static int stallFlag = 0;
  int count = 0;
  char header[4];


  while (n>0) {

    //    cout << "Waiting for Packet" << endl;    
    count=read(devfd,header,4);

    if (count == 4) {  // Received packet header
      stallFlag = 0;
      //      cout << "Received 4 bytes of Packet Header "<< endl;
      // Get the rest of the packet
      int length = (int)(ntohs(*((u_short *)header +1)));
      VrIPpacket* packet = new VrIPpacket(length);

      if (length != 0) {
	count = packet->devRead(devfd,packet->ptr()+4,length-4);
      
	if (count == length-4) {
	  outputWrite(*packet);
	  n--;
	  cout << "Sending IP packet " << ++packetcount << " ID: " <<
	    packet->getId() << endl;
	}
      }

    }
    else { /* no packet available.  SoftLinkSource should not wait, because
	      the end of the last packet may be trapped in the pipe.
	      Create and send a null packet */
      if (stallFlag == 0) {
	stallFlag = 1;
	cout << "No packet.  Sending NULL packet " << endl;
	VrIPpacket* packet = new VrIPpacket(0);
	outputWrite(*packet);
	n=0; /*** should only be asking for one packet at a time **/
      }
    }
  }
  return;
}

VrSoftLinkSource::~VrSoftLinkSource()
{
  if (devfd >= 0) 
    close(devfd);
}

VrSoftLinkSource::VrSoftLinkSource(double sampling_freq)
{
  fprintf(stderr,"Opening %s for read(SoftlinkSource)\n", SLDEV);
  if((devfd=open(SLDEV,O_RDONLY | O_NONBLOCK ))==-1) {
    fprintf(stderr,"Error encountered opening device (SoftlinkSource).\n");
    exit(1);
  } else
    fprintf(stderr,
	    "Device opened successfully, beginning read (SoftlinkSource)\n");

  setSamplingFrequency (sampling_freq);
}

#endif



