/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRAMP_H_
#define _VRAMP_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class VrAmp : public VrSigProc {
protected:
  float g;
public: 
  virtual const char *name() { return "VrAmp"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  void setGain(float gn) {g = gn;}
  VrAmp(float gn = 1.0) :VrSigProc(1,sizeof(iType),sizeof(oType)),g(gn) { }
};

template<class iType,class oType> int
VrAmp<iType,oType>::work(VrSampleRange output, void *o[],
		VrSampleRange inputs[], void *i[])
{
  iType *i0 = ((iType **)i)[0];
  oType *o0 = ((oType **)o)[0];
  int size = output.size;
  while (size-- > 0) {
    //*o[0]++ = (oType)(*i[0]++ * g);
    o0[size] = (oType)(i0[size] * g);
    } 
  return output.size;
}
#endif
