#include "Tuner.h"

void
Tuner::setChannel(int channel)
{
  if (channel < min || channel > max)
    return;

  if (chan != channel)
    {
      chan = channel;
      emit channelChanged(chan);
    }
}

void
Tuner::nextChannel()
{ 
  if (chan < max)
    setChannel(chan + 1); 
  else if (wrap)
    setChannel(min);
  else
    return;
}

void
Tuner::prevChannel()
{ 
  if (chan > min)
    setChannel(chan - 1); 
  else if (wrap)
    setChannel(max);
  else
    return;
}
