/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#include <VrSigSource.h>
#include <VrFakeGuppiSource.h>
#include <VrNullSink.h>
#include <VrRealFIRfilter.h>
#include <VrComplexFIRfilter.h>
#include <VrQuadratureDemod.h>
#include <VrMultiTask.h>

/* Multiple AMPS channel receive chain */
/* Runs over 1-4 processors and number of chains 1-16 and compares the
   number of samples per second */

const float inputRate = 33000000.0;
const float inputFreq = 10700000.0;

const int CFIRdecimate = 825;
const int cTaps = 400;

const float chanFreq[] = {10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500, 
			  10370400, 10355400, 10340400, 10960500};
const float chanGain[] = {2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0,
			  2.0, 2.0, 2.0, 2.0};
const int chanTaps[] = {cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps,
			cTaps, cTaps, cTaps, cTaps};

const float FMdemodGain = 1100.0;

const int RFIRdecimate = 5;
const int ifTaps = 20;
const float ifGain = 1.0;

const float quadRate = inputRate / CFIRdecimate;
const float audioRate = quadRate / RFIRdecimate;

const float seconds = 10.0;

int main(int argc, char **argv) {

  // Create Modules
  //  VrSigSource<char>* source = new VrSigSource<char>(inputRate, VR_SIN_WAVE,10700001,100);
  VrFakeGuppiSource<char>* source = new VrFakeGuppiSource<char>(inputRate);

  int numChannels=1;
  if (argc > 2)
    numChannels = atoi(argv[2]);

  VrComplexFIRfilter<char>* channel_filter = 
    new VrComplexFIRfilter<char>(numChannels,CFIRdecimate,chanTaps, chanFreq,chanGain);

  VrQuadratureDemod<float>* demod[numChannels];
  VrRealFIRfilter<float,short>* if_filter[numChannels];
  VrNullSink<short>* sink[numChannels];

  VrMultiTask *multi;

#ifdef THREADS
  int threads = 1;
  if (argc > 1)
    threads = atoi(argv[1]);

  //  for(int threads=1;threads<=4;threads++) {
    cerr<<threads<<" threads."<<endl;
    cerr<<numChannels<<" channels."<<endl;
    multi=new VrMultiTask(threads);
    
  int i;
  for (i = 0; i < numChannels; i++)
    {

      demod[i] = new  VrQuadratureDemod<float>(FMdemodGain);
      if_filter[i] = new VrRealFIRfilter<float,short>(RFIRdecimate,4000.0,ifTaps,ifGain);
      sink[i] = new VrNullSink<short>();

      multi->add(sink[i]);
      // Connect Modules

      CONNECT(sink[i], if_filter[i], audioRate, 16);
      CONNECT(if_filter[i], demod[i], audioRate, 32);
      CONNECTN(demod[i], channel_filter, i, quadRate, 64);
    }

  CONNECT(channel_filter, source, inputRate, 8);

  // Start System
  multi->start();
  while(multi->elapsedTime() < seconds) 
    multi->process();
  multi->stop();
    
  cerr<<"time source: "<<(source->getWP()/source->getSamplingFrequency())<<endl;
  for(i=0;i<numChannels;i++) {
    cerr<<"time sink "<<i<<": "<<(sink[i]->getWP()/sink[i]->getSamplingFrequency())<<endl;
    cerr<<"WP sink: "<<(sink[i]->getWP())<<endl<<endl;

  }

  delete multi;
    //  }
#else
  cerr<<"Compile w/ THREADS to run this performance test."<<endl;
#endif

#if 0
#ifdef PERFMON
  multi->print_stats();

  VrPerfGraph *g=multi->getGraph();
  g->setTitle("Multi channel AMPS audio receive");
  g->outputGraph(seconds);
#endif
#endif
}
