#!/usr/bin/env python

from gnuradio import gr, eng_notation
from gnuradio import usrp
from gnuradio import audio
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import math

from gnuradio.wxgui import stdgui, fftsink
import wx


def build_pipeline (self, filename, lo_freq):
    max_deviation = 5000 * 5
    
    src = gr.file_source (gr.sizeof_float, filename, True)

    interp_taps =  gr.firdes.low_pass (self.sw_interp,     # gain
                                       self.fs,            # sampling rate
                                       4000,
                                       16000,
                                       gr.firdes.WIN_HANN)
    print "len = ", len (interp_taps)

    interp = gr.interp_fir_filter_fff (self.sw_interp, interp_taps)

    k = 2 * math.pi * max_deviation / self.fs
    fmmod = gr.frequency_modulator_fc (k)

    lo = gr.sig_source_c (self.fs, gr.GR_SIN_WAVE, lo_freq, 1.0, 0)
    mixer = gr.multiply_cc ()
    
    self.connect (src, interp)
    self.connect (interp, fmmod)
    self.connect (fmmod, (mixer, 0))
    self.connect (lo, (mixer, 1))

    return mixer


class fm_tx_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        parser = OptionParser (option_class=eng_option)
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=29.32e6,
                           help="set Tx cordic frequency to FREQ", metavar="FREQ")
        (options, args) = parser.parse_args ()

        print "cordic_freq = %s" % (eng_notation.num_to_str (options.cordic_freq))

        # ----------------------------------------------------------------

        self.audio_rate = 32000
        self.sw_interp = 2 * 5
        self.usrp_interp = 2000 / 5
        self.fs = self.audio_rate * self.sw_interp

        pl0 = build_pipeline (self, "/home/eb/demo/test-audio-0.dat", 0*50e3)
        pl1 = build_pipeline (self, "/home/eb/demo/test-audio-1.dat", 1*50e3)
        pl2 = build_pipeline (self, "/home/eb/demo/test-audio-2.dat", -1*50e3)
        pl3 = build_pipeline (self, "/home/eb/demo/test-audio-3.dat", -2*50e3)

        sum = gr.add_cc ()
        self.connect (pl0, (sum, 0))
        self.connect (pl1, (sum, 1))
        self.connect (pl2, (sum, 2))
        self.connect (pl3, (sum, 3))

        gain = gr.multiply_const_cc (2000)
        u = usrp.sink_c (0, self.usrp_interp)
        u.set_tx_freq (0, options.cordic_freq)

        self.connect (sum, gain)
        self.connect (gain, u)

        if 0:
            post_interp, fft_win1 = fftsink.make_fft_sink_f (self, panel, "Post Interp", 512, self.fs)
            self.connect (interp, post_interp)
            vbox.Add (fft_win1, 1, wx.EXPAND)

        if 1:
            post_mod, fft_win2 = fftsink.make_fft_sink_c (self, panel, "Post Modulation", 512, self.fs)
            self.connect (sum, post_mod)
            vbox.Add (fft_win2, 1, wx.EXPAND)
            

def main ():
    app = stdgui.stdapp (fm_tx_graph, "FM Tx")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
