/*
 This file is part of GNU Taler
 (C) 2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import process from "node:process";
import readline from "node:readline";
import path from "node:path";
import os from "node:os";
import fs from "node:fs";

export function processExit(status: number): never {
  process.exit(status);
}

export function processArgv(): string[] {
  return [...process.argv];
}

export function readlinePrompt(prompt: string): Promise<string> {
  const stdinReadline = readline.createInterface({
    input: process.stdin,
    output: process.stdout,
  });
  return new Promise<string>((resolve, reject) => {
    stdinReadline.question(prompt, (res) => {
      resolve(res);
      stdinReadline.close();
    });
  });
}

export function pathBasename(p: string): string {
  return path.basename(p);
}

export function pathHomedir(): string {
  return os.homedir();
}

export function setUnhandledRejectionHandler(h: (e: any) => void): void {
  process.on("unhandledRejection", (e) => {
    h(e);
  });
}

export function getenv(name: string): string | undefined {
  return process.env[name];
}

export function readFile(fileName: string): string {
  return fs.readFileSync(fileName, "utf-8");
}
