;;; DO NOT MODIFY THIS FILE
(if (featurep 'mail-lib-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "mail-lib/_pkg.el")

(package-provide 'mail-lib :version 1.35 :type 'regular)

;;;***

;;;### (autoloads (browse-url-kfm browse-url-generic browse-url-mail browse-url-mmm browse-url-lynx-emacs browse-url-lynx-xterm browse-url-w3-gnudoit browse-url-w3 browse-url-iximosaic browse-url-cci browse-url-grail browse-url-mosaic browse-url-netscape browse-url-at-mouse browse-url-at-point browse-url browse-url-of-region browse-url-of-dired-file browse-url-of-buffer browse-url-of-file) "browse-url" "mail-lib/browse-url.el")

(defcustom browse-url-browser-function (if (eq system-type 'windows-nt) 'browse-url-default-windows-browser 'browse-url-netscape) "*Function to display the current buffer in a WWW browser.\nThis is used by the `browse-url-at-point', `browse-url-at-mouse', and\n`browse-url-of-file' commands.\n\nIf the value is not a function it should be a list of pairs\n(REGEXP . FUNCTION).  In this case the function called will be the one\nassociated with the first REGEXP which matches the current URL.  The\nfunction is passed the URL and any other args of `browse-url'.  The last\nregexp should probably be \".\" to specify a default browser." :type '(choice (function-item :tag "Emacs W3" :value browse-url-w3) (function-item :tag "W3 in another Emacs via `gnudoit'" :value browse-url-w3-gnudoit) (function-item :tag "Netscape" :value browse-url-netscape) (function-item :tag "Mosaic" :value browse-url-mosaic) (function-item :tag "Mosaic using CCI" :value browse-url-cci) (function-item :tag "IXI Mosaic" :value browse-url-iximosaic) (function-item :tag "Lynx in an xterm window" :value browse-url-lynx-xterm) (function-item :tag "Lynx in an Emacs window" :value browse-url-lynx-emacs) (function-item :tag "Grail" :value browse-url-grail) (function-item :tag "MMM" :value browse-url-mmm) (function-item :tag "kfm" :value browse-url-kfm) (function-item :tag "Specified by `Browse Url Generic Program'" :value browse-url-generic) (function-item :tag "Default Windows browser" :value browse-url-default-windows-browser) (function :tag "Your own function")) :version "20.4" :group 'browse-url)

(defcustom browse-url-new-window-p nil "*If non-nil, always open a new browser window with appropriate browsers.\nPassing an interactive argument to \\[browse-url], or specific browser\ncommands reverses the effect of this variable.  Requires Netscape version\n1.1N or later or XMosaic version 2.5 or later if using those browsers." :type 'boolean :group 'browse-url)

(defcustom browse-url-netscape-display nil "*The X display for running Netscape, if not same as Emacs'." :type '(choice string (const :tag "Default" nil)) :group 'browse-url)

(defcustom browse-url-save-file nil "*If non-nil, save the buffer before displaying its file.\nUsed by the `browse-url-of-file' command." :type 'boolean :group 'browse-url)

(defcustom browse-url-generic-program nil "*The name of the browser program used by `browse-url-generic'." :type '(choice string (const :tag "None" nil)) :group 'browse-url)

(autoload 'browse-url-of-file "browse-url" "\
Ask a WWW browser to display FILE.
Display the current buffer's file if FILE is nil or if called
interactively.  Turn the filename into a URL with function
`browse-url-file-url'.  Pass the URL to a browser using the
`browse-url' function then run `browse-url-of-file-hook'." t nil)

(autoload 'browse-url-of-buffer "browse-url" "\
Ask a WWW browser to display BUFFER.
Display the current buffer if BUFFER is nil.  Display only the
currently visible part of BUFFER (from a temporary file) if buffer is
narrowed." t nil)

(autoload 'browse-url-of-dired-file "browse-url" "\
In Dired, ask a WWW browser to display the file named on this line." t nil)

(autoload 'browse-url-of-region "browse-url" "\
Ask a WWW browser to display the current region." t nil)

(autoload 'browse-url "browse-url" "\
Ask a WWW browser to load URL.
Prompts for a URL, defaulting to the URL at or before point.  Variable
`browse-url-browser-function' says which browser to use." t nil)

(autoload 'browse-url-at-point "browse-url" "\
Ask a WWW browser to load the URL at or before point.
Doesn't let you edit the URL like `browse-url'.  Variable
`browse-url-browser-function' says which browser to use." t nil)

(autoload 'browse-url-at-mouse "browse-url" "\
Ask a WWW browser to load a URL clicked with the mouse.
The URL is the one around or before the position of the mouse click
but point is not changed.  Doesn't let you edit the URL like
`browse-url'.  Variable `browse-url-browser-function' says which browser
to use." t nil)

(autoload 'browse-url-netscape "browse-url" "\
Ask the Netscape WWW browser to load URL.

Default to the URL around or before point.  The strings in variable
`browse-url-netscape-arguments' are also passed to Netscape.

When called interactively, if variable `browse-url-new-window-p' is
non-nil, load the document in a new Netscape window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(autoload 'browse-url-mosaic "browse-url" "\
Ask the XMosaic WWW browser to load URL.

Default to the URL around or before point.  The strings in variable
`browse-url-mosaic-arguments' are also passed to Mosaic and the
program is invoked according to the variable
`browse-url-mosaic-program'.

When called interactively, if variable `browse-url-new-window-p' is
non-nil, load the document in a new Mosaic window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(defvar browse-url-grail (concat (or (getenv "GRAILDIR") "~/.grail") "/user/rcgrail.py") "\
Location of Grail remote control client script `rcgrail.py'.
Typically found in $GRAILDIR/rcgrail.py, or ~/.grail/user/rcgrail.py.")

(autoload 'browse-url-grail "browse-url" "\
Ask the Grail WWW browser to load URL.
Default to the URL around or before point.  Runs the program in the
variable `browse-url-grail'." t nil)

(autoload 'browse-url-cci "browse-url" "\
Ask the XMosaic WWW browser to load URL.
Default to the URL around or before point.

This function only works for XMosaic version 2.5 or later.  You must
select `CCI' from XMosaic's File menu, set the CCI Port Address to the
value of variable `browse-url-CCI-port', and enable `Accept requests'.

When called interactively, if variable `browse-url-new-window-p' is
non-nil, load the document in a new browser window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(autoload 'browse-url-iximosaic "browse-url" "\
Ask the IXIMosaic WWW browser to load URL.
Default to the URL around or before point." t nil)

(autoload 'browse-url-w3 "browse-url" "\
Ask the w3 WWW browser to load URL.
Default to the URL around or before point.

When called interactively, if variable `browse-url-new-window-p' is
non-nil, load the document in a new window.  A non-nil interactive
prefix argument reverses the effect of `browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(autoload 'browse-url-w3-gnudoit "browse-url" "\
Ask another Emacs running gnuserv to load the URL using the W3 browser.
The `browse-url-gnudoit-program' program is used with options given by
`browse-url-gnudoit-args'.  Default to the URL around or before point." t nil)

(autoload 'browse-url-lynx-xterm "browse-url" "\
Ask the Lynx WWW browser to load URL.
Default to the URL around or before point.  A new Lynx process is run
in an Xterm window using the Xterm program named by `browse-url-xterm-program'
with possible additional arguments `browse-url-xterm-args'." t nil)

(autoload 'browse-url-lynx-emacs "browse-url" "\
Ask the Lynx WWW browser to load URL.
Default to the URL around or before point.  With a prefix argument, run
a new Lynx process in a new buffer.

When called interactively, if variable `browse-url-new-window-p' is
non-nil, load the document in a new lynx in a new term window,
otherwise use any existing one.  A non-nil interactive prefix argument
reverses the effect of `browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(autoload 'browse-url-mmm "browse-url" "\
Ask the MMM WWW browser to load URL.
Default to the URL around or before point." t nil)

(autoload 'browse-url-mail "browse-url" "\
Open a new mail message buffer within Emacs.
Default to using the mailto: URL around or before point as the
recipient's address.  Supplying a non-nil interactive prefix argument
will cause the mail to be composed in another window rather than the
current one.

When called interactively, if variable `browse-url-new-window-p' is
non-nil use `compose-mail-other-window', otherwise `compose-mail'.  A
non-nil interactive prefix argument reverses the effect of
`browse-url-new-window-p'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-p'." t nil)

(autoload 'browse-url-generic "browse-url" "\
Ask the WWW browser defined by `browse-url-generic-program' to load URL.
Default to the URL around or before point.  A fresh copy of the
browser is started up in a new process with possible additional arguments
`browse-url-generic-args'.  This is appropriate for browsers which
don't offer a form of remote control." t nil)

(autoload 'browse-url-kfm "browse-url" "\
Ask the kfm WWW browser to load URL.
Default to the URL around or before point." t nil)

;;;***

;;;### (autoloads (highlight-headers-follow-url highlight-headers-follow-url-mosaic highlight-headers-follow-url-kfm highlight-headers-follow-url-netscape highlight-headers) "highlight-headers" "mail-lib/highlight-headers.el")

(autoload 'highlight-headers "highlight-headers" "\
Highlight message headers between start and end.
Faces used:
  message-headers			the part before the colon
  message-header-contents		the part after the colon
  message-highlighted-header-contents	contents of \"special\" headers
  message-cited-text			quoted text from other messages
  message-url				URLs (WWW uniform resource locators)

Variables used:

  highlight-headers-regexp			what makes a \"special\" header
  highlight-headers-citation-regexp		matches lines of quoted text
  highlight-headers-citation-header-regexp	matches headers for quoted text

If HACK-SIG is true,then we search backward from END for something that
looks like the beginning of a signature block, and don't consider that a
part of the message (this is because signatures are often incorrectly
interpreted as cited text.)" nil nil)

(autoload 'highlight-headers-follow-url-netscape "highlight-headers" nil nil nil)

(autoload 'highlight-headers-follow-url-kfm "highlight-headers" nil nil nil)

(autoload 'highlight-headers-follow-url-mosaic "highlight-headers" nil nil nil)

(autoload 'highlight-headers-follow-url "highlight-headers" nil t nil)

;;;***

;;;### (autoloads (define-mail-alias build-mail-aliases mail-aliases-setup) "mail-abbrevs" "mail-lib/mail-abbrevs.el")

(defcustom mail-abbrev-mailrc-file nil "Name of file with mail aliases.   If nil, ~/.mailrc is used." :type '(choice (const :tag "Default" nil) file) :group 'mail-abbrevs)

(defvar mail-aliases nil "\
Word-abbrev table of mail address aliases.
If this is nil, it means the aliases have not yet been initialized and
should be read from the .mailrc file.  (This is distinct from there being
no aliases, which is represented by this being a table with no entries.)")

(autoload 'mail-aliases-setup "mail-abbrevs" nil nil nil)

(autoload 'build-mail-aliases "mail-abbrevs" "\
Read mail aliases from .mailrc and set mail-aliases." nil nil)

(autoload 'define-mail-alias "mail-abbrevs" "\
Define NAME as a mail-alias that translates to DEFINITION.
If DEFINITION contains multiple addresses, separate them with commas." t nil)

;;;***

;;;### (autoloads (what-domain mail-extract-address-components) "mail-extr" "mail-lib/mail-extr.el")

(autoload 'mail-extract-address-components "mail-extr" "\
Given an RFC-822 ADDRESS, extract full name and canonical address.
Returns a list of the form (FULL-NAME CANONICAL-ADDRESS).
If no name can be extracted, FULL-NAME will be nil.
ADDRESS may be a string or a buffer.  If it is a buffer, the visible 
 (narrowed) portion of the buffer will be interpreted as the address.
 (This feature exists so that the clever caller might be able to avoid
 consing a string.)
If ADDRESS contains more than one RFC-822 address, only the first is
 returned.  Some day this function may be extended to extract multiple
 addresses, or perhaps return the position at which parsing stopped." nil nil)

(autoload 'what-domain "mail-extr" "\
Prompts for a mail domain, and prints the country it corresponds to
in the minibuffer." t nil)

;;;***

;;;### (autoloads (mail-fetch-field mail-file-babyl-p) "mail-utils" "mail-lib/mail-utils.el")

(defcustom mail-use-rfc822 nil "*If non-nil, use a full, hairy RFC822 parser on mail addresses.\nOtherwise, (the default) use a smaller, somewhat faster, and\noften correct parser." :type 'boolean :group 'mail)

(autoload 'mail-file-babyl-p "mail-utils" nil nil nil)

(autoload 'mail-fetch-field "mail-utils" "\
Return the value of the header field whose type is FIELD-NAME.
The buffer is expected to be narrowed to just the header of the message.
If second arg LAST is non-nil, use the last field of type FIELD-NAME.
If third arg ALL is non-nil, concatenate all such fields with commas between.
If 4th arg LIST is non-nil, return a list of all such fields." nil nil)

;;;***

;;;### (autoloads (pop3-movemail pop3-nnmail-movemail) "pop3" "mail-lib/pop3.el")

(autoload 'pop3-nnmail-movemail "pop3" "\
Function to move mail from INBOX on a pop3 server to file CRASHBOX." nil nil)

(autoload 'pop3-movemail "pop3" "\
Transfer contents of a maildrop to the specified CRASHBOX." nil nil)

;;;***

;;;### (autoloads (reporter-submit-bug-report) "reporter" "mail-lib/reporter.el")

(autoload 'reporter-submit-bug-report "reporter" "\
Begin submitting a bug report via email.

ADDRESS is the email address for the package's maintainer.  PKGNAME is
the name of the package (if you want to include version numbers,
you must put them into PKGNAME before calling this function).
Optional PRE-HOOKS and POST-HOOKS are passed to `reporter-dump-state'.
Optional SALUTATION is inserted at the top of the mail buffer,
and point is left after the salutation.

VARLIST is the list of variables to dump (see `reporter-dump-state'
for details).  The optional argument PRE-HOOKS and POST-HOOKS are
passed to `reporter-dump-state'.  Optional argument SALUTATION is text
to be inserted at the top of the mail buffer; in that case, point is
left after that text.

This function prompts for a summary if `reporter-prompt-for-summary-p'
is non-nil.

This function does not send a message; it uses the given information
to initialize a a messagem, which the user can then edit and finally send
\(or decline to send).  The variable `mail-user-agent' controls which
mail-sending package is used for editing and sending the message." nil nil)

;;;***

;;;### (autoloads nil "rmail-mini" "mail-lib/rmail-mini.el")

(defcustom rmail-dont-reply-to-names nil "*A regexp specifying names to prune of reply to messages.\nA value of nil means exclude your own name only." :type '(choice regexp (const :tag "Your Name" nil)) :group 'rmail-reply)

(defvar rmail-default-dont-reply-to-names "info-" "\
A regular expression specifying part of the value of the default value of
the variable `rmail-dont-reply-to-names', for when the user does not set
`rmail-dont-reply-to-names' explicitly.  (The other part of the default
value is the user's name.)
It is useful to set this variable in the site customization file.")

;;;***

;;;### (autoloads (rmail-file-p) "rmailout" "mail-lib/rmailout.el")

(autoload 'rmail-file-p "rmailout" nil nil nil)

;;;***

;;;### (autoloads (mail-other-frame mail-other-window mail mail-mode user-mail-address) "sendmail" "mail-lib/sendmail.el")

(defvar mail-from-style 'angles "\
*Specifies how \"From:\" fields look.

If `nil', they contain just the return address like:
	king@grassland.com
If `parens', they look like:
	king@grassland.com (Elvis Parsley)
If `angles', they look like:
	Elvis Parsley <king@grassland.com>")

(defvar mail-self-blind nil "\
Non-nil means insert BCC to self in messages to be sent.
This is done when the message is initialized,
so you can remove or alter the BCC field to override the default.")

(defvar mail-interactive nil "\
Non-nil means when sending a message wait for and display errors.
nil means let mailer mail back a message to report errors.")

(defvar mail-dir nil "\
*Default directory for saving messages.")

(defvar rmail-ignored-headers (purecopy (concat "^\\(" (mapconcat 'identity '("Sender:" "References:" "Return-Path:" "Received:" "[^: 	\n]*Message-ID:" "Errors-To:" "Path:" "Expires:" "Xref:" "Lines:" "Approved:" "Distribution:" "Content-Length:" "Mime-Version:" "Content-Type:" "Content-Transfer-Encoding:" "X400-Received:" "X400-Originator:" "X400-Mts-Identifier:" "X400-Content-Type:" "Content-Identifier:" "Status:" "Summary-Line:" "X-Attribution:" "Via:" "Sent-Via:" "Mail-From:" "Origin:" "Comments:" "Originator:" "NF-ID:" "NF-From:" "Posting-Version:" "Posted:" "Posted-Date:" "Date-Received:" "Relay-Version:" "Article-I\\.D\\.:" "NNTP-Version:" "NNTP-Posting-Host:" "X-Mailer:" "X-Newsreader:" "News-Software:" "X-Received:" "X-References:" "X-Envelope-To:" "X-VMS-" "Remailed-" "X-Plantation:" "X-Windows:" "X-Pgp-") "\\|") "\\)")) "\
*Gubbish header fields one would rather not see.")

(defvar mail-yank-ignored-headers (purecopy (concat rmail-ignored-headers "\\|" "^\\(" (mapconcat 'identity '("Resent-To:" "Resent-By:" "Resent-CC:" "To:" "Subject:" "In-Reply-To:") "\\|") "\\)")) "\
Delete these headers from old message when it's inserted in a reply.")

(defvar send-mail-function (if (eq system-type 'windows-nt) 'smtpmail-send-it 'sendmail-send-it) "\
Function to call to send the current buffer as mail.
The headers should be delimited by a line whose contents
match the variable `mail-header-separator'.")

(defvar mail-header-separator (purecopy "--text follows this line--") "\
*Line used to separate headers from text in messages being composed.")

(defvar mail-archive-file-name nil "\
*Name of file to write all outgoing messages in, or nil for none.
This can be an inbox file or an Rmail file.")

(defvar mail-default-reply-to nil "\
*Address to insert as default Reply-to field of outgoing messages.
If nil, it will be initialized from the REPLYTO environment variable
when you first send mail.")

(defvar mail-alias-file nil "\
*If non-nil, the name of a file to use instead of `/usr/lib/aliases'.
This file defines aliases to be expanded by the mailer; this is a different
feature from that of defining aliases in `.mailrc' to be expanded in Emacs.
This variable has no effect unless your system uses sendmail as its mailer.")

(defvar mail-yank-prefix "> " "\
*Prefix insert on lines of yanked message being replied to.
nil means use indentation.")

(defvar mail-signature nil "\
*Text inserted at end of mail buffer when a message is initialized.
If t, it means to insert the contents of the file `mail-signature-file'.")

(autoload 'user-mail-address "sendmail" "\
Query the user for his mail address, unless it is already known." t nil)

(autoload 'mail-mode "sendmail" "\
Major mode for editing mail to be sent.
Like Text Mode but with these additional commands:
C-c C-s  mail-send (send the message)    C-c C-c  mail-send-and-exit
C-c C-f  move to a header field (and create it if there isn't):
	 C-c C-f C-t  move to To:	C-c C-f C-s  move to Subj:
	 C-c C-f C-b  move to BCC:	C-c C-f C-c  move to CC:
	 C-c C-f C-f  move to FCC:	C-c C-f C-r  move to Reply-To:
C-c C-t  mail-text (move to beginning of message text).
C-c C-w  mail-signature (insert `mail-signature-file' file).
C-c C-y  mail-yank-original (insert current message, in Rmail).
C-c C-q  mail-fill-yanked-message (fill what was yanked).
C-c C-v  mail-sent-via (add a sent-via field for each To or CC)." t nil)

(autoload 'mail "sendmail" "\
Edit a message to be sent.  Prefix arg means resume editing (don't erase).
When this function returns, the buffer `*mail*' is selected.
The value is t if the message was newly initialized; otherwise, nil.

Optionally, the signature file `mail-signature-file' can be inserted at the
end; see the variable `mail-signature'.

\\<mail-mode-map>
While editing message, type \\[mail-send-and-exit] to send the message and exit.

Various special commands starting with C-c are available in sendmail mode
to move to message header fields:
\\{mail-mode-map}

The variable `mail-signature' controls whether the signature file
`mail-signature-file' is inserted immediately.

If `mail-signature' is nil, use \\[mail-signature] to insert the
signature in `mail-signature-file'.

If `mail-self-blind' is non-nil, a BCC to yourself is inserted
when the message is initialized.

If `mail-default-reply-to' is non-nil, it should be an address (a string);
a Reply-to: field with that address is inserted.

If `mail-archive-file-name' is non-nil, an FCC field with that file name
is inserted.

The normal hook `mail-setup-hook' is run after the message is
initialized.  It can add more default fields to the message.

When calling from a program, the first argument if non-nil says
not to erase the existing contents of the `*mail*' buffer.

The second through fifth arguments,
 TO, SUBJECT, IN-REPLY-TO and CC, specify if non-nil
 the initial contents of those header fields.
 These arguments should not have final newlines.
The sixth argument REPLYBUFFER is a buffer whose contents
 should be yanked if the user types C-c C-y.
The seventh argument ACTIONS is a list of actions to take
 if/when the message is sent.  Each action looks like (FUNCTION . ARGS);
 when the message is sent, we apply FUNCTION to ARGS.
 This is how Rmail arranges to mark messages `answered'." t nil)

(autoload 'mail-other-window "sendmail" "\
Like `mail' command, but display mail buffer in another window." t nil)

(autoload 'mail-other-frame "sendmail" "\
Like `mail' command, but display mail buffer in another frame." t nil)
(add-hook 'same-window-buffer-names "*mail*")

;;;***

;;;### (autoloads (smtpmail-send-it) "smtpmail" "mail-lib/smtpmail.el")

(autoload 'smtpmail-send-it "smtpmail" nil nil nil)

;;;***

(provide 'mail-lib-autoloads)
