;;; xwem-keytt.el --- Keypress translation table.

;; Copyright (C) 2003 by Free Software Foundation, Inc.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: Fri Dec 12 19:33:35 MSK 2003
;; Keywords: xwem, xlib
;; X-CVS: $Id: xwem-keytt.el,v 1.1 2004/03/22 18:14:51 lg Exp $

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; 

;;; Code:

;; Translation table
(defcustom xwem-key-tt-alist nil
  "*Keypresses translation table.
Alist in where keys is source keypress and value is destination keypress.
Each keypresses is in form returned from `kbd'."
  :type 'alist
  :group 'xwem-keyboard)



;; Functions
(define-xwem-command xwem-key-tt-command ()
  "Command to perform keypress translation."
  (xwem-interactive)

  (let* ((prk xwem-this-command-keys)
	 (tte (assoc prk xwem-key-tt-alist)))
    (if tte
	(X-Dpy-send-excursion (xwem-dpy)
	  (xwem-key-send-ekeys (cdr tte)))

      (xwem-message 'warn "Can't find tt entry for: %S" prk))))

(defun xwem-key-tt-init ()
  "Initialize translation table.
Translation table is alist with elements in form:
  (issued-key . send-key)

i.e. tt substitutes pressed key ISSUED-KEY with SEND-KEY actually it
will looks like you press SEND-KEY."
  (mapcar (lambda (el)
	    (xwem-define-key (car el) 'xwem-key-tt-command))
	  xwem-key-tt-alist))




(provide 'xwem-keytt)

;;; xwem-keytt.el ends here
