;;; ucs-latin-a.el --- UCS table of Latin Extended-A

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Latin Extended-A

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; LATIN CAPITAL LETTER A WITH MACRON
(ucs-set-char #x0100 ?$(D*'(B) ; J90-D-2A27
(ucs-set-char #x0100 ?-D) ; ISO-8859-4-C0-A

;; LATIN SMALL LETTER A WITH MACRON
(ucs-set-char #x0101 ?$(D+'(B) ; J90-D-2B27
(ucs-set-char #x0101 ?$(A(!(B) ; GB0-A-2821
(ucs-set-char #x0101 ?-D) ; ISO-8859-4-E0-A

;; LATIN CAPITAL LETTER A WITH BREVE
(ucs-set-char #x0102 ?$(D*%(B) ; J90-D-2A25
(ucs-set-char #x0102 ?-2) ; VISCII-1.1-C5-A
(ucs-set-char #x0102 ?-B) ; ISO-8859-2-C3-A

;; LATIN SMALL LETTER A WITH BREVE
(ucs-set-char #x0103 ?$(D+%(B) ; J90-D-2B25
(ucs-set-char #x0103 ?-1) ; VISCII-1.1-E5-A
(ucs-set-char #x0103 ?-B) ; ISO-8859-2-E3-A

;; LATIN CAPITAL LETTER A WITH OGONEK
(ucs-set-char #x0104 ?$(D*((B) ; J90-D-2A28
(ucs-set-char #x0104 ?-D) ; ISO-8859-4-A1-A
(ucs-set-char #x0104 ?-B) ; ISO-8859-2-A1-A

;; LATIN SMALL LETTER A WITH OGONEK
(ucs-set-char #x0105 ?$(D+((B) ; J90-D-2B28
(ucs-set-char #x0105 ?-D) ; ISO-8859-4-B1-A
(ucs-set-char #x0105 ?-B) ; ISO-8859-2-B1-A

;; LATIN CAPITAL LETTER C WITH ACUTE
(ucs-set-char #x0106 ?$(D*+(B) ; J90-D-2A2B
(ucs-set-char #x0106 ?-B) ; ISO-8859-2-C6-A

;; LATIN SMALL LETTER C WITH ACUTE
(ucs-set-char #x0107 ?$(D++(B) ; J90-D-2B2B
(ucs-set-char #x0107 ?-B) ; ISO-8859-2-E6-A

;; LATIN CAPITAL LETTER C WITH CIRCUMFLEX
(ucs-set-char #x0108 ?$(D*,(B) ; J90-D-2A2C
(ucs-set-char #x0108 ?-C) ; ISO-8859-3-C6-A

;; LATIN SMALL LETTER C WITH CIRCUMFLEX
(ucs-set-char #x0109 ?$(D+,(B) ; J90-D-2B2C
(ucs-set-char #x0109 ?-C) ; ISO-8859-3-E6-A

;; LATIN CAPITAL LETTER C WITH DOT ABOVE
(ucs-set-char #x010A ?$(D*/(B) ; J90-D-2A2F
(ucs-set-char #x010A ?-C) ; ISO-8859-3-C5-A

;; LATIN SMALL LETTER C WITH DOT ABOVE
(ucs-set-char #x010B ?$(D+/(B) ; J90-D-2B2F
(ucs-set-char #x010B ?-C) ; ISO-8859-3-E5-A

;; LATIN CAPITAL LETTER C WITH CARON
(ucs-set-char #x010C ?$(D*-(B) ; J90-D-2A2D
(ucs-set-char #x010C ?-D) ; ISO-8859-4-C8-A
(ucs-set-char #x010C ?-B) ; ISO-8859-2-C8-A

;; LATIN SMALL LETTER C WITH CARON
(ucs-set-char #x010D ?$(D+-(B) ; J90-D-2B2D
(ucs-set-char #x010D ?-D) ; ISO-8859-4-E8-A
(ucs-set-char #x010D ?-B) ; ISO-8859-2-E8-A

;; LATIN CAPITAL LETTER D WITH CARON
(ucs-set-char #x010E ?$(D*0(B) ; J90-D-2A30
(ucs-set-char #x010E ?-B) ; ISO-8859-2-CF-A

;; LATIN SMALL LETTER D WITH CARON
(ucs-set-char #x010F ?$(D+0(B) ; J90-D-2B30
(ucs-set-char #x010F ?-B) ; ISO-8859-2-EF-A

;; LATIN CAPITAL LETTER D WITH STROKE
(ucs-set-char #x0110 ?$(D)"(B) ; J90-D-2922
(ucs-set-char #x0110 ?-2) ; VISCII-1.1-D0-A
(ucs-set-char #x0110 ?-D) ; ISO-8859-4-D0-A
(ucs-set-char #x0110 ?-B) ; ISO-8859-2-D0-A

;; LATIN SMALL LETTER D WITH STROKE
(ucs-set-char #x0111 ?$(C)"(B) ; KS0-C-2922
(ucs-set-char #x0111 ?$(D)B(B) ; J90-D-2942
(ucs-set-char #x0111 ?-1) ; VISCII-1.1-F0-A
(ucs-set-char #x0111 ?-D) ; ISO-8859-4-F0-A
(ucs-set-char #x0111 ?-B) ; ISO-8859-2-F0-A

;; LATIN CAPITAL LETTER E WITH MACRON
(ucs-set-char #x0112 ?$(D*7(B) ; J90-D-2A37
(ucs-set-char #x0112 ?-D) ; ISO-8859-4-AA-A

;; LATIN SMALL LETTER E WITH MACRON
(ucs-set-char #x0113 ?$(D+7(B) ; J90-D-2B37
(ucs-set-char #x0113 ?$(A(%(B) ; GB0-A-2825
(ucs-set-char #x0113 ?-D) ; ISO-8859-4-BA-A

;; LATIN CAPITAL LETTER E WITH BREVE

;; LATIN SMALL LETTER E WITH BREVE

;; LATIN CAPITAL LETTER E WITH DOT ABOVE
(ucs-set-char #x0116 ?$(D*6(B) ; J90-D-2A36
(ucs-set-char #x0116 ?-D) ; ISO-8859-4-CC-A

;; LATIN SMALL LETTER E WITH DOT ABOVE
(ucs-set-char #x0117 ?$(D+6(B) ; J90-D-2B36
(ucs-set-char #x0117 ?-D) ; ISO-8859-4-EC-A

;; LATIN CAPITAL LETTER E WITH OGONEK
(ucs-set-char #x0118 ?$(D*8(B) ; J90-D-2A38
(ucs-set-char #x0118 ?-D) ; ISO-8859-4-CA-A
(ucs-set-char #x0118 ?-B) ; ISO-8859-2-CA-A

;; LATIN SMALL LETTER E WITH OGONEK
(ucs-set-char #x0119 ?$(D+8(B) ; J90-D-2B38
(ucs-set-char #x0119 ?-D) ; ISO-8859-4-EA-A
(ucs-set-char #x0119 ?-B) ; ISO-8859-2-EA-A

;; LATIN CAPITAL LETTER E WITH CARON
(ucs-set-char #x011A ?$(D*5(B) ; J90-D-2A35
(ucs-set-char #x011A ?-B) ; ISO-8859-2-CC-A

;; LATIN SMALL LETTER E WITH CARON
(ucs-set-char #x011B ?$(D+5(B) ; J90-D-2B35
(ucs-set-char #x011B ?$(A('(B) ; GB0-A-2827
(ucs-set-char #x011B ?-B) ; ISO-8859-2-EC-A

;; LATIN CAPITAL LETTER G WITH CIRCUMFLEX
(ucs-set-char #x011C ?$(D*:(B) ; J90-D-2A3A
(ucs-set-char #x011C ?-C) ; ISO-8859-3-D8-A

;; LATIN SMALL LETTER G WITH CIRCUMFLEX
(ucs-set-char #x011D ?$(D+:(B) ; J90-D-2B3A
(ucs-set-char #x011D ?-C) ; ISO-8859-3-F8-A

;; LATIN CAPITAL LETTER G WITH BREVE
(ucs-set-char #x011E ?$(D*;(B) ; J90-D-2A3B
(ucs-set-char #x011E ?-M) ; ISO-8859-9-D0-A
(ucs-set-char #x011E ?-C) ; ISO-8859-3-AB-A

;; LATIN SMALL LETTER G WITH BREVE
(ucs-set-char #x011F ?$(D+;(B) ; J90-D-2B3B
(ucs-set-char #x011F ?-M) ; ISO-8859-9-F0-A
(ucs-set-char #x011F ?-C) ; ISO-8859-3-BB-A

;; LATIN CAPITAL LETTER G WITH DOT ABOVE
(ucs-set-char #x0120 ?$(D*=(B) ; J90-D-2A3D
(ucs-set-char #x0120 ?-C) ; ISO-8859-3-D5-A

;; LATIN SMALL LETTER G WITH DOT ABOVE
(ucs-set-char #x0121 ?$(D+=(B) ; J90-D-2B3D
(ucs-set-char #x0121 ?-C) ; ISO-8859-3-F5-A

;; LATIN CAPITAL LETTER G WITH CEDILLA
(ucs-set-char #x0122 ?$(D*<(B) ; J90-D-2A3C
(ucs-set-char #x0122 ?-D) ; ISO-8859-4-AB-A

;; LATIN SMALL LETTER G WITH CEDILLA
(ucs-set-char #x0123 ?-D) ; ISO-8859-4-BB-A

;; LATIN CAPITAL LETTER H WITH CIRCUMFLEX
(ucs-set-char #x0124 ?$(D*>(B) ; J90-D-2A3E
(ucs-set-char #x0124 ?-C) ; ISO-8859-3-A6-A

;; LATIN SMALL LETTER H WITH CIRCUMFLEX
(ucs-set-char #x0125 ?$(D+>(B) ; J90-D-2B3E
(ucs-set-char #x0125 ?-C) ; ISO-8859-3-B6-A

;; LATIN CAPITAL LETTER H WITH STROKE
(ucs-set-char #x0126 ?$(C($(B) ; KS0-C-2824
(ucs-set-char #x0126 ?$(D)$(B) ; J90-D-2924
(ucs-set-char #x0126 ?-C) ; ISO-8859-3-A1-A

;; LATIN SMALL LETTER H WITH STROKE
(ucs-set-char #x0127 ?$(C)$(B) ; KS0-C-2924
(ucs-set-char #x0127 ?$(D)D(B) ; J90-D-2944
(ucs-set-char #x0127 ?-C) ; ISO-8859-3-B1-A

;; LATIN CAPITAL LETTER I WITH TILDE
(ucs-set-char #x0128 ?$(D*G(B) ; J90-D-2A47
(ucs-set-char #x0128 ?-2) ; VISCII-1.1-CE-A
(ucs-set-char #x0128 ?-D) ; ISO-8859-4-A5-A

;; LATIN SMALL LETTER I WITH TILDE
(ucs-set-char #x0129 ?$(D+G(B) ; J90-D-2B47
(ucs-set-char #x0129 ?-1) ; VISCII-1.1-EE-A
(ucs-set-char #x0129 ?-D) ; ISO-8859-4-B5-A

;; LATIN CAPITAL LETTER I WITH MACRON
(ucs-set-char #x012A ?$(D*E(B) ; J90-D-2A45
(ucs-set-char #x012A ?-D) ; ISO-8859-4-CF-A

;; LATIN SMALL LETTER I WITH MACRON
(ucs-set-char #x012B ?$(D+E(B) ; J90-D-2B45
(ucs-set-char #x012B ?$(A()(B) ; GB0-A-2829
(ucs-set-char #x012B ?-D) ; ISO-8859-4-EF-A

;; LATIN CAPITAL LETTER I WITH BREVE

;; LATIN SMALL LETTER I WITH BREVE

;; LATIN CAPITAL LETTER I WITH OGONEK
(ucs-set-char #x012E ?$(D*F(B) ; J90-D-2A46
(ucs-set-char #x012E ?-D) ; ISO-8859-4-C7-A

;; LATIN SMALL LETTER I WITH OGONEK
(ucs-set-char #x012F ?$(D+F(B) ; J90-D-2B46
(ucs-set-char #x012F ?-D) ; ISO-8859-4-E7-A

;; LATIN CAPITAL LETTER I WITH DOT ABOVE
(ucs-set-char #x0130 ?$(D*D(B) ; J90-D-2A44
(ucs-set-char #x0130 ?-M) ; ISO-8859-9-DD-A
(ucs-set-char #x0130 ?-C) ; ISO-8859-3-A9-A

;; LATIN SMALL LETTER DOTLESS I
(ucs-set-char #x0131 ?$(C)%(B) ; KS0-C-2925
(ucs-set-char #x0131 ?$(D)E(B) ; J90-D-2945
(ucs-set-char #x0131 ?-M) ; ISO-8859-9-FD-A
(ucs-set-char #x0131 ?-C) ; ISO-8859-3-B9-A

;; LATIN CAPITAL LIGATURE IJ
(ucs-set-char #x0132 ?$(C(&(B) ; KS0-C-2826
(ucs-set-char #x0132 ?$(D)&(B) ; J90-D-2926

;; LATIN SMALL LIGATURE IJ
(ucs-set-char #x0133 ?$(C)&(B) ; KS0-C-2926
(ucs-set-char #x0133 ?$(D)F(B) ; J90-D-2946

;; LATIN CAPITAL LETTER J WITH CIRCUMFLEX
(ucs-set-char #x0134 ?$(D*H(B) ; J90-D-2A48
(ucs-set-char #x0134 ?-C) ; ISO-8859-3-AC-A

;; LATIN SMALL LETTER J WITH CIRCUMFLEX
(ucs-set-char #x0135 ?$(D+H(B) ; J90-D-2B48
(ucs-set-char #x0135 ?-C) ; ISO-8859-3-BC-A

;; LATIN CAPITAL LETTER K WITH CEDILLA
(ucs-set-char #x0136 ?$(D*I(B) ; J90-D-2A49
(ucs-set-char #x0136 ?-D) ; ISO-8859-4-D3-A

;; LATIN SMALL LETTER K WITH CEDILLA
(ucs-set-char #x0137 ?$(D+I(B) ; J90-D-2B49
(ucs-set-char #x0137 ?-D) ; ISO-8859-4-F3-A

;; LATIN SMALL LETTER KRA
(ucs-set-char #x0138 ?$(C)'(B) ; KS0-C-2927
(ucs-set-char #x0138 ?$(D)G(B) ; J90-D-2947
(ucs-set-char #x0138 ?-D) ; ISO-8859-4-A2-A

;; LATIN CAPITAL LETTER L WITH ACUTE
(ucs-set-char #x0139 ?$(D*J(B) ; J90-D-2A4A
(ucs-set-char #x0139 ?-B) ; ISO-8859-2-C5-A

;; LATIN SMALL LETTER L WITH ACUTE
(ucs-set-char #x013A ?$(D+J(B) ; J90-D-2B4A
(ucs-set-char #x013A ?-B) ; ISO-8859-2-E5-A

;; LATIN CAPITAL LETTER L WITH CEDILLA
(ucs-set-char #x013B ?$(D*L(B) ; J90-D-2A4C
(ucs-set-char #x013B ?-D) ; ISO-8859-4-A6-A

;; LATIN SMALL LETTER L WITH CEDILLA
(ucs-set-char #x013C ?$(D+L(B) ; J90-D-2B4C
(ucs-set-char #x013C ?-D) ; ISO-8859-4-B6-A

;; LATIN CAPITAL LETTER L WITH CARON
(ucs-set-char #x013D ?$(D*K(B) ; J90-D-2A4B
(ucs-set-char #x013D ?-B) ; ISO-8859-2-A5-A

;; LATIN SMALL LETTER L WITH CARON
(ucs-set-char #x013E ?$(D+K(B) ; J90-D-2B4B
(ucs-set-char #x013E ?-B) ; ISO-8859-2-B5-A

;; LATIN CAPITAL LETTER L WITH MIDDLE DOT
(ucs-set-char #x013F ?$(C(((B) ; KS0-C-2828
(ucs-set-char #x013F ?$(D))(B) ; J90-D-2929

;; LATIN SMALL LETTER L WITH MIDDLE DOT
(ucs-set-char #x0140 ?$(C)((B) ; KS0-C-2928
(ucs-set-char #x0140 ?$(D)I(B) ; J90-D-2949

;; LATIN CAPITAL LETTER L WITH STROKE
(ucs-set-char #x0141 ?$(C()(B) ; KS0-C-2829
(ucs-set-char #x0141 ?$(D)((B) ; J90-D-2928
(ucs-set-char #x0141 ?-B) ; ISO-8859-2-A3-A

;; LATIN SMALL LETTER L WITH STROKE
(ucs-set-char #x0142 ?$(C))(B) ; KS0-C-2929
(ucs-set-char #x0142 ?$(D)H(B) ; J90-D-2948
(ucs-set-char #x0142 ?-B) ; ISO-8859-2-B3-A

;; LATIN CAPITAL LETTER N WITH ACUTE
(ucs-set-char #x0143 ?$(D*M(B) ; J90-D-2A4D
(ucs-set-char #x0143 ?-B) ; ISO-8859-2-D1-A

;; LATIN SMALL LETTER N WITH ACUTE
(ucs-set-char #x0144 ?$(D+M(B) ; J90-D-2B4D
(ucs-set-char #x0144 ?-B) ; ISO-8859-2-F1-A

;; LATIN CAPITAL LETTER N WITH CEDILLA
(ucs-set-char #x0145 ?$(D*O(B) ; J90-D-2A4F
(ucs-set-char #x0145 ?-D) ; ISO-8859-4-D1-A

;; LATIN SMALL LETTER N WITH CEDILLA
(ucs-set-char #x0146 ?$(D+O(B) ; J90-D-2B4F
(ucs-set-char #x0146 ?-D) ; ISO-8859-4-F1-A

;; LATIN CAPITAL LETTER N WITH CARON
(ucs-set-char #x0147 ?$(D*N(B) ; J90-D-2A4E
(ucs-set-char #x0147 ?-B) ; ISO-8859-2-D2-A

;; LATIN SMALL LETTER N WITH CARON
(ucs-set-char #x0148 ?$(D+N(B) ; J90-D-2B4E
(ucs-set-char #x0148 ?-B) ; ISO-8859-2-F2-A

;; LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
(ucs-set-char #x0149 ?$(C)0(B) ; KS0-C-2930
(ucs-set-char #x0149 ?$(D)J(B) ; J90-D-294A

;; LATIN CAPITAL LETTER ENG
(ucs-set-char #x014A ?$(C(/(B) ; KS0-C-282F
(ucs-set-char #x014A ?$(D)+(B) ; J90-D-292B
(ucs-set-char #x014A ?-D) ; ISO-8859-4-BD-A

;; LATIN SMALL LETTER ENG
(ucs-set-char #x014B ?$(C)/(B) ; KS0-C-292F
(ucs-set-char #x014B ?$(D)K(B) ; J90-D-294B
(ucs-set-char #x014B ?-D) ; ISO-8859-4-BF-A

;; LATIN CAPITAL LETTER O WITH MACRON
(ucs-set-char #x014C ?$(D*W(B) ; J90-D-2A57
(ucs-set-char #x014C ?-D) ; ISO-8859-4-D2-A

;; LATIN SMALL LETTER O WITH MACRON
(ucs-set-char #x014D ?$(D+W(B) ; J90-D-2B57
(ucs-set-char #x014D ?$(A(-(B) ; GB0-A-282D
(ucs-set-char #x014D ?$(D+W(B) ; J90-D-2B57
(ucs-set-char #x014D ?-D) ; ISO-8859-4-F2-A

;; LATIN CAPITAL LETTER O WITH BREVE

;; LATIN SMALL LETTER O WITH BREVE

;; LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
(ucs-set-char #x0150 ?$(D*V(B) ; J90-D-2A56
(ucs-set-char #x0150 ?-B) ; ISO-8859-2-D5-A

;; LATIN SMALL LETTER O WITH DOUBLE ACUTE
(ucs-set-char #x0151 ?$(D+V(B) ; J90-D-2B56
(ucs-set-char #x0151 ?-B) ; ISO-8859-2-F5-A

;; LATIN CAPITAL LIGATURE OE
(ucs-set-char #x0152 ?$(C(+(B) ; KS0-C-282B
(ucs-set-char #x0152 ?$(D)-(B) ; J90-D-292D

;; LATIN SMALL LIGATURE OE
(ucs-set-char #x0153 ?$(C)+(B) ; KS0-C-292B
(ucs-set-char #x0153 ?$(D)M(B) ; J90-D-294D

;; LATIN CAPITAL LETTER R WITH ACUTE
(ucs-set-char #x0154 ?$(D*Y(B) ; J90-D-2A59
(ucs-set-char #x0154 ?-B) ; ISO-8859-2-C0-A

;; LATIN SMALL LETTER R WITH ACUTE
(ucs-set-char #x0155 ?$(D+Y(B) ; J90-D-2B59
(ucs-set-char #x0155 ?-B) ; ISO-8859-2-E0-A

;; LATIN CAPITAL LETTER R WITH CEDILLA
(ucs-set-char #x0156 ?$(D*[(B) ; J90-D-2A5B
(ucs-set-char #x0156 ?-D) ; ISO-8859-4-A3-A

;; LATIN SMALL LETTER R WITH CEDILLA
(ucs-set-char #x0157 ?$(D+[(B) ; J90-D-2B5B
(ucs-set-char #x0157 ?-D) ; ISO-8859-4-B3-A

;; LATIN CAPITAL LETTER R WITH CARON
(ucs-set-char #x0158 ?$(D*Z(B) ; J90-D-2A5A
(ucs-set-char #x0158 ?-B) ; ISO-8859-2-D8-A

;; LATIN SMALL LETTER R WITH CARON
(ucs-set-char #x0159 ?$(D+Z(B) ; J90-D-2B5A
(ucs-set-char #x0159 ?-B) ; ISO-8859-2-F8-A

;; LATIN CAPITAL LETTER S WITH ACUTE
(ucs-set-char #x015A ?$(D*\(B) ; J90-D-2A5C
(ucs-set-char #x015A ?-B) ; ISO-8859-2-A6-A

;; LATIN SMALL LETTER S WITH ACUTE
(ucs-set-char #x015B ?$(D+\(B) ; J90-D-2B5C
(ucs-set-char #x015B ?-B) ; ISO-8859-2-B6-A

;; LATIN CAPITAL LETTER S WITH CIRCUMFLEX
(ucs-set-char #x015C ?$(D*](B) ; J90-D-2A5D
(ucs-set-char #x015C ?-C) ; ISO-8859-3-DE-A

;; LATIN SMALL LETTER S WITH CIRCUMFLEX
(ucs-set-char #x015D ?$(D+](B) ; J90-D-2B5D
(ucs-set-char #x015D ?-C) ; ISO-8859-3-FE-A

;; LATIN CAPITAL LETTER S WITH CEDILLA
(ucs-set-char #x015E ?$(D*_(B) ; J90-D-2A5F
(ucs-set-char #x015E ?-M) ; ISO-8859-9-DE-A
(ucs-set-char #x015E ?-C) ; ISO-8859-3-AA-A
(ucs-set-char #x015E ?-B) ; ISO-8859-2-AA-A

;; LATIN SMALL LETTER S WITH CEDILLA
(ucs-set-char #x015F ?$(D+_(B) ; J90-D-2B5F
(ucs-set-char #x015F ?-M) ; ISO-8859-9-FE-A
(ucs-set-char #x015F ?-C) ; ISO-8859-3-BA-A
(ucs-set-char #x015F ?-B) ; ISO-8859-2-BA-A

;; LATIN CAPITAL LETTER S WITH CARON
(ucs-set-char #x0160 ?$(D*^(B) ; J90-D-2A5E
(ucs-set-char #x0160 ?-D) ; ISO-8859-4-A9-A
(ucs-set-char #x0160 ?-B) ; ISO-8859-2-A9-A

;; LATIN SMALL LETTER S WITH CARON
(ucs-set-char #x0161 ?$(D+^(B) ; J90-D-2B5E
(ucs-set-char #x0161 ?-D) ; ISO-8859-4-B9-A
(ucs-set-char #x0161 ?-B) ; ISO-8859-2-B9-A

;; LATIN CAPITAL LETTER T WITH CEDILLA
(ucs-set-char #x0162 ?$(D*a(B) ; J90-D-2A61
(ucs-set-char #x0162 ?-B) ; ISO-8859-2-DE-A

;; LATIN SMALL LETTER T WITH CEDILLA
(ucs-set-char #x0163 ?$(D+a(B) ; J90-D-2B61
(ucs-set-char #x0163 ?-B) ; ISO-8859-2-FE-A

;; LATIN CAPITAL LETTER T WITH CARON
(ucs-set-char #x0164 ?$(D*`(B) ; J90-D-2A60
(ucs-set-char #x0164 ?-B) ; ISO-8859-2-AB-A

;; LATIN SMALL LETTER T WITH CARON
(ucs-set-char #x0165 ?$(D+`(B) ; J90-D-2B60
(ucs-set-char #x0165 ?-B) ; ISO-8859-2-BB-A

;; LATIN CAPITAL LETTER T WITH STROKE
(ucs-set-char #x0166 ?$(C(.(B) ; KS0-C-282E
(ucs-set-char #x0166 ?$(D)/(B) ; J90-D-292F
(ucs-set-char #x0166 ?-D) ; ISO-8859-4-AC-A

;; LATIN SMALL LETTER T WITH STROKE
(ucs-set-char #x0167 ?$(C).(B) ; KS0-C-292E
(ucs-set-char #x0167 ?$(D)O(B) ; J90-D-294F
(ucs-set-char #x0167 ?-D) ; ISO-8859-4-BC-A

;; LATIN CAPITAL LETTER U WITH TILDE
(ucs-set-char #x0168 ?$(D*l(B) ; J90-D-2A6C
(ucs-set-char #x0168 ?-2) ; VISCII-1.1-9D-A
(ucs-set-char #x0168 ?-D) ; ISO-8859-4-DD-A

;; LATIN SMALL LETTER U WITH TILDE
(ucs-set-char #x0169 ?$(D+l(B) ; J90-D-2B6C
(ucs-set-char #x0169 ?-1) ; VISCII-1.1-FB-A
(ucs-set-char #x0169 ?-D) ; ISO-8859-4-FD-A

;; LATIN CAPITAL LETTER U WITH MACRON
(ucs-set-char #x016A ?$(D*i(B) ; J90-D-2A69
(ucs-set-char #x016A ?-D) ; ISO-8859-4-DE-A

;; LATIN SMALL LETTER U WITH MACRON
(ucs-set-char #x016B ?$(D+i(B) ; J90-D-2B69
(ucs-set-char #x016B ?$(A(1(B) ; GB0-A-2831
(ucs-set-char #x016B ?-D) ; ISO-8859-4-FE-A

;; LATIN CAPITAL LETTER U WITH BREVE
(ucs-set-char #x016C ?$(D*f(B) ; J90-D-2A66
(ucs-set-char #x016C ?-C) ; ISO-8859-3-DD-A

;; LATIN SMALL LETTER U WITH BREVE
(ucs-set-char #x016D ?$(D+f(B) ; J90-D-2B66
(ucs-set-char #x016D ?-C) ; ISO-8859-3-FD-A

;; LATIN CAPITAL LETTER U WITH RING ABOVE
(ucs-set-char #x016E ?$(D*k(B) ; J90-D-2A6B
(ucs-set-char #x016E ?-B) ; ISO-8859-2-D9-A

;; LATIN SMALL LETTER U WITH RING ABOVE
(ucs-set-char #x016F ?$(D+k(B) ; J90-D-2B6B
(ucs-set-char #x016F ?-B) ; ISO-8859-2-F9-A

;; LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
(ucs-set-char #x0170 ?$(D*h(B) ; J90-D-2A68
(ucs-set-char #x0170 ?-B) ; ISO-8859-2-DB-A

;; LATIN SMALL LETTER U WITH DOUBLE ACUTE
(ucs-set-char #x0171 ?$(D+h(B) ; J90-D-2B68
(ucs-set-char #x0171 ?-B) ; ISO-8859-2-FB-A

;; LATIN CAPITAL LETTER U WITH OGONEK
(ucs-set-char #x0172 ?$(D*j(B) ; J90-D-2A6A
(ucs-set-char #x0172 ?-D) ; ISO-8859-4-D9-A

;; LATIN SMALL LETTER U WITH OGONEK
(ucs-set-char #x0173 ?$(D+j(B) ; J90-D-2B6A
(ucs-set-char #x0173 ?-D) ; ISO-8859-4-F9-A

;; LATIN CAPITAL LETTER W WITH CIRCUMFLEX
(ucs-set-char #x0174 ?$(D*q(B) ; J90-D-2A71

;; LATIN SMALL LETTER W WITH CIRCUMFLEX
(ucs-set-char #x0175 ?$(D+q(B) ; J90-D-2B71

;; LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
(ucs-set-char #x0176 ?$(D*t(B) ; J90-D-2A74

;; LATIN SMALL LETTER Y WITH CIRCUMFLEX
(ucs-set-char #x0177 ?$(D+t(B) ; J90-D-2B74

;; LATIN CAPITAL LETTER Y WITH DIAERESIS
(ucs-set-char #x0178 ?$(D*s(B) ; J90-D-2A73

;; LATIN CAPITAL LETTER Z WITH ACUTE
(ucs-set-char #x0179 ?$(D*u(B) ; J90-D-2A75
(ucs-set-char #x0179 ?-B) ; ISO-8859-2-AC-A

;; LATIN SMALL LETTER Z WITH ACUTE
(ucs-set-char #x017A ?$(D+u(B) ; J90-D-2B75
(ucs-set-char #x017A ?-B) ; ISO-8859-2-BC-A

;; LATIN CAPITAL LETTER Z WITH DOT ABOVE
(ucs-set-char #x017B ?$(D*w(B) ; J90-D-2A77
(ucs-set-char #x017B ?-C) ; ISO-8859-3-AF-A
(ucs-set-char #x017B ?-B) ; ISO-8859-2-AF-A

;; LATIN SMALL LETTER Z WITH DOT ABOVE
(ucs-set-char #x017C ?$(D+w(B) ; J90-D-2B77
(ucs-set-char #x017C ?-C) ; ISO-8859-3-BF-A
(ucs-set-char #x017C ?-B) ; ISO-8859-2-BF-A

;; LATIN CAPITAL LETTER Z WITH CARON
(ucs-set-char #x017D ?$(D*v(B) ; J90-D-2A76
(ucs-set-char #x017D ?-D) ; ISO-8859-4-AE-A
(ucs-set-char #x017D ?-B) ; ISO-8859-2-AE-A

;; LATIN SMALL LETTER Z WITH CARON
(ucs-set-char #x017E ?$(D+v(B) ; J90-D-2B76
(ucs-set-char #x017E ?-D) ; ISO-8859-4-BE-A
(ucs-set-char #x017E ?-B) ; ISO-8859-2-BE-A

;; LATIN SMALL LETTER LONG S

;;; ucs-latin-a.el ends here
