/* Various initialization function prototypes.
   Copyright (C) 1995 Board of Trustees, University of Illinois

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _XEMACS_SYMSINIT_H_
#define _XEMACS_SYMSINIT_H_

/* Earliest environment initializations (dump-time and run-time). */

extern void init_data_very_early (void);
extern void init_floatfns_very_early (void);
extern void init_free_hook (void);
extern void init_intl_very_early (void);
extern void init_ralloc (void);
extern void init_signals_very_early (void);

/* Initialize the Lisp engine (dump-time only). */

extern void init_alloc_once (void);
extern void init_buffer_once (void);
extern void init_casetab_once (void);
extern void init_data_once (void);
extern void init_debug_once (void);
extern void init_device_once (void);
extern void init_device_stream_once (void);
extern void init_device_tty_once (void);
extern void init_device_x_once (void);
extern void init_elhash_once (void);
extern void init_eval_once (void);
extern void init_fns_once (void);
extern void init_frame_tty_once (void);
extern void init_frame_x_once (void);
extern void init_glyphs_once (void);
extern void init_insdel_once (void);
extern void init_minibuf_once (void);
extern void init_mule_category_once (void);
extern void init_mule_charset_once (void);
extern void init_objects_once (void);
extern void init_objects_tty_once (void);
extern void init_objects_x_once (void);
extern void init_redisplay_tty_once (void);
extern void init_redisplay_x_once (void);
extern void init_scrollbar_once (void);
extern void init_specifier_once (void);
extern void init_symbols_once (void);
extern void init_syntax_once (void);
extern void init_toolbar_once (void);
extern void init_toolbar_x_once (void);

/* Reset the Lisp engine (run-time only). */

extern void reinit_alloc (void);
extern void reinit_debug (void);
extern void reinit_eval (void);
extern void reinit_mule_category (void);

/* Declare the built-in primitives and variables (dump-time only). */

extern void syms_of_abbrev (void);
extern void syms_of_alloc (void);
extern void syms_of_buffer (void);
extern void syms_of_bytecode (void);
extern void syms_of_callint (void);
extern void syms_of_callproc (void);
extern void syms_of_casefiddle (void);
extern void syms_of_casetab (void);
extern void syms_of_cmds (void);
extern void syms_of_data (void);
extern void syms_of_debug (void);
extern void syms_of_device (void);
extern void syms_of_device_stream (void);
extern void syms_of_device_tty (void);
extern void syms_of_device_x (void);
extern void syms_of_dired (void);
extern void syms_of_doc (void);
extern void syms_of_editfns (void);
extern void syms_of_elhash (void);
extern void syms_of_emacs (void);
extern void syms_of_energize (void);
extern void syms_of_epoch (void);
extern void syms_of_eval (void);
extern void syms_of_events (void);
extern void syms_of_event_stream (void);
extern void syms_of_event_tty (void);
extern void syms_of_event_Xt (void);
extern void syms_of_extents (void);
extern void syms_of_faces (void);
extern void syms_of_fileio (void);
extern void syms_of_filelock (void);
extern void syms_of_floatfns (void);
extern void syms_of_fns (void);
extern void syms_of_font_lock (void);
extern void syms_of_frame_x (void);
extern void syms_of_frame (void);
extern void syms_of_free_hook (void);
extern void syms_of_glyphs (void);
extern void syms_of_glyphs_x (void);
extern void syms_of_hpplay (void);
extern void syms_of_indent (void);
extern void syms_of_intl (void);
extern void syms_of_keyboard (void);
extern void syms_of_keymap (void);
extern void syms_of_lread (void);
extern void syms_of_lstream (void);
extern void syms_of_macros (void);
extern void syms_of_marker (void);
extern void syms_of_md5 (void);
extern void syms_of_menubar_x (void);
extern void syms_of_menubar (void);
extern void syms_of_minibuf (void);
extern void syms_of_mocklisp (void);
extern void syms_of_mule (void);
extern void syms_of_mule_canna (void);
extern void syms_of_mule_category (void);
extern void syms_of_mule_ccl (void);
extern void syms_of_mule_charset (void);
extern void syms_of_mule_coding (void);
extern void syms_of_mule_wnn4 (void);
extern void syms_of_objects_tty (void);
extern void syms_of_objects_x (void);
extern void syms_of_objects (void);
extern void syms_of_opaque (void);
extern void syms_of_print (void);
extern void syms_of_process (void);
extern void syms_of_ralloc (void);
extern void syms_of_redisplay (void);
extern void syms_of_scrollbar (void);
extern void syms_of_search (void);
extern void syms_of_signal (void);
extern void syms_of_sound (void);
extern void syms_of_specifier (void);
extern void syms_of_sunpro (void);
extern void syms_of_symbols (void);
extern void syms_of_syntax (void);
extern void syms_of_toolbar (void);
extern void syms_of_tooltalk (void);
extern void syms_of_undo (void);
extern void syms_of_vmsfns (void);
extern void syms_of_vmsproc (void);
extern void syms_of_window (void);
extern void syms_of_xselect (void);

extern void keys_of_keymap (void);

/* Late initialization -- stuff pertaining only to interactive usage,
   I/O, or Lisp reading. (Dump-time and run-time.) */

extern void init_buffer (void);
extern void init_callproc (void);
extern void init_device_stream (void);
extern void init_device_tty (void);
extern void init_dosfns (void);
extern void init_editfns (void);
extern void init_environment (void);
extern void init_event_Xt_late (void);
extern void init_event_stream (void);
extern void init_event_tty_late (void);
extern void init_faces (void);
extern void init_filelock (void);
extern void init_keyboard (void);
extern void init_lread (void);
extern void init_macros (void);
/* Not named init_process in order to avoid conflict with NS 3.3 */
extern void init_xemacs_process (void);
extern void init_redisplay (void);
extern void init_sunpro (void);
extern void init_vms_input (void);
extern void init_vmsfns (void);
extern void init_vmsproc (void);

#endif /* _XEMACS_SYMSINIT_H_ */
