/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Mark Allender (allender@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
*/

/*
 *  This file contains many of the motif dialog information boxes
 *  that might get popped up from time to time, including the elision
 *  control box and the display table data.
*/
#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/SeparatoG.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include "elision.h"
#include "extern.h"

/*
 *  We will need some global definitions for this.
*/

Widget ElisionDialog;			/* the main dialog box */
Widget ElisionPolicyBox;		/* the radio box itself */
Widget ElisionPolicyChoices[6];		/* the elision policy selections */
Boolean ElisionDialogManaged = False;

/*
 *  ManageDialog manages the top level dialog box passed to it.
*/
void
ManageDialog(widget, client_data, call_data)
     Widget widget;
     caddr_t client_data, call_data;
{
  if (ElisionDialogManaged == False) {
    XtManageChild(ElisionDialog);
    ElisionDialogManaged = True;
  }
}

/*
 *  UnmanageDialog unmanages the top level dialog box passed to it.
*/
void
UnmanageDialog(widget, client_data, call_data)
     Widget widget;
     caddr_t client_data, call_data;
{
  if (ElisionDialogManaged == True) {
    XtUnmanageChild(ElisionDialog);
    ElisionDialogManaged = False;
  }
}

/*
 *  CreateBulletinDialog creates a bulletin-board dialog box for whatever
 *  parent we pass it.
*/
Widget
CreateBulletinDialog(parent, name)
     Widget parent;
     char *name;
{
  Widget bulletin;
  Arg args[10];
  int n;

  n = 0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNnoResize, True); n++;
  bulletin = XmCreateBulletinBoardDialog(parent, name, args, n);

  return bulletin;
}

/*
 *  CreateToggle will create a toggle button for whatever purpose it was
 *  called for.
*/
Widget
CreateToggle(parent, name, message, state, type, callback_func)
     Widget parent;
     char *name, *message;
     Boolean state;
     int type;
     void (*callback_func)();
{
  Widget toggle_button;
  Arg args[10];
  int n;
  XmString motif_string;

  motif_string = CtoXmString(message);

/*
 *  Set up the appropriate things for the toggle buttons to function
 *  properly.
*/
  n = 0;
  XtSetArg(args[n], XmNlabelString, motif_string); n++;
  XtSetArg(args[n], XmNindicatorType, type); n++;
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNset, state); n++;
  toggle_button = XmCreateToggleButton(parent, name, args, n);
  XtManageChild(toggle_button);
/*
 *  Add a callback onto these buttons, so that when they are hit, then
 *  we can change the information in the graph as need be
*/
  XtAddCallback(toggle_button, XmNvalueChangedCallback, callback_func, NULL);
  XmStringFree(motif_string);
  return toggle_button;
}

/*
 *  This routine creates the elision dialog box that is used to display all
 *  of the elision stuff, i.e. what the policy is, etc.
*/
Widget
CreateElisionDialog(parent, name, callback_func)
     Widget parent;
     char *name;
     void (*callback_func)();
{
  Widget main_rc, elision_policy_rc, frame, sep, ok, cancel, help;
  Arg args[10];
  int n;

  n = 0;
  ElisionDialog = CreateBulletinDialog(parent, name);
  CreateTitle("Elision Policies", ElisionDialog);

/*
 *  Create a seperator between this and the push buttons.
*/
  n = 0;
  sep = XmCreateSeparatorGadget(ElisionDialog, "elisionsep", args, n);
  XtManageChild(sep);
/*
 *  Create the push buttons for the bottom row.
*/
  ok = CreatePushButton("OK", ElisionDialog, UnmanageDialog, NULL);
  n = 0;
  XtSetArg(args[n], XmNshowAsDefault, 1); n++;
  XtSetValues(ok, args, n);

/*
 * set up the button as default action
*/
  n = 0;
  XtSetArg(args[n], XmNdefaultButton, ok); n++;
  XtSetValues(ElisionDialog, args, n);
/*
 *  create cancel button
*/
  cancel = CreatePushButton("Cancel", ElisionDialog, UnmanageDialog, NULL);
  help = CreatePushButton("Help", ElisionDialog, UnmanageDialog, NULL);

/*
 *  Set up the main row/column widget into which other frames and row/
 *  column widgets will be placed.
*/
  n = 0;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  main_rc = XmCreateRowColumn(ElisionDialog, "mainrow", args, n);
  XtManageChild(main_rc);
/*
 *  get a frame for the polcies
*/
  n = 0;
  XtSetArg(args[n], XmNshadowThickness, 4); n++;
  frame = XmCreateFrame(main_rc, "frame", args, n);
  XtManageChild(frame);
/*
 *  create a row column widget to hold the toggles for elision policy
*/
  n = 0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
  ElisionPolicyBox = XmCreateRowColumn(frame, "policies", args, n);
  XtManageChild(ElisionPolicyBox);

  ElisionPolicyChoices[0] = CreateToggle(ElisionPolicyBox,
					 "removeall", "Remove All",
					 True, XmN_OF_MANY,
					 callback_func);
  ElisionPolicyChoices[1] = CreateToggle(ElisionPolicyBox,
					 "inboundedges", "Inbound edges",
					 False, XmN_OF_MANY,
					 callback_func);
  ElisionPolicyChoices[2] = CreateToggle(ElisionPolicyBox,
					 "inboundandnode",
					 "Inbound edges and nodes",
					 False, XmN_OF_MANY,
					 callback_func);
  ElisionPolicyChoices[3] = CreateToggle(ElisionPolicyBox,
					 "outboundedge", "Outbound edges",
					 False, XmN_OF_MANY,
					 callback_func);
  ElisionPolicyChoices[4] = CreateToggle(ElisionPolicyBox,
					 "outboundandnode",
					 "Outbound edges and nodes",
					 False, XmN_OF_MANY,
					 callback_func);
  ElisionPolicyChoices[5] = CreateToggle(ElisionPolicyBox,
					 "supernode", "SuperNode",
					 False, XmN_OF_MANY,
					 callback_func);
}
				
