/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:  Thomas Fruchterman
 *		 John Jozwiak
 *		 Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

#include <stdio.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "config.h"
#include "graph.h"
#include "extern.h"

#define logo_width  cb_width
#define logo_height cb_height
#define logo_bits   cb_bits
#define MIN_W       100
#define MIN_H       100
#define DEF_W       300
#define DEF_H       200
#define MAPPINGBUFLEN 128

void
FreeGCs(graph)
     Graph *graph;
{
  XFreeGC(XtDisplay(graph->parent), graph->xor_gc);
  XFreeGC(XtDisplay(graph->parent), graph->graph_gc);
  XFreeGC(XtDisplay(graph->parent), graph->text_gc);
  XFreeGC(XtDisplay(graph->parent), graph->rubber_band_gc);
}  

void
SetXGraph(graph_name)
  char *graph_name;
{
  XSizeHints size_hints;
  XColor c;
  Arg args[10];  
  int tmp, n;
  Colormap Cmap;
  Widget main_w, menu_bar;
  Display *viewing_dpy, *virtual_dpy;
  Window viewing_win, virtual_win;
  Dimension wd, ht;
  unsigned long background, foreground;

  static XtResource resources[] = 
  {
    { 
      XtNfont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
      XtOffset (Graph_ptr, font), XtRString, "6x10"
    }
  };

/*
 *  Now, create the parent window with XtCreatePopupShell.  We will add a
 *  callback onto that window that will allow the graph's to be destroyed.
 *  This will give us the advantage that when we are destroying shells, that
 *  we can merely destroy the window which contains the graph, and the graph
 *  will automagically die!!
*/
  graph->parent = XtCreatePopupShell(graph_name, topLevelShellWidgetClass,
				     toplevel_widget, NULL, 0);
/*
 *  I'm going to keep the XtNdestroyCallback as the callback list
 *  here, so that I can get rid of dependencies of the motif includes
 *  here..
*/
  XtAddCallback(graph->parent, XtNdestroyCallback, DestroyGraph,
		(caddr_t)graph);
/*
 *  Now, set the pixmap data for the window
*/
  SetPixmap(graph->parent);
/*
 *  Now, create the menu bar, and the two drawing areas (viewing and virtual)
*/
  main_w = CreateMainWindow(graph->parent, DEF_W, DEF_H);
  menu_bar = CreateMenuBar(main_w);
  graph->viewing_area.widget = CreateViewingArea(main_w, menu_bar);
  graph->virtual_area.widget = CreateVirtualArea(main_w,
						 graph->viewing_area.widget,
						 menu_bar);
  XtManageChild(main_w);
  XtRealizeWidget(graph->parent);
  XtManageChild(graph->parent);
  viewing_dpy = XtDisplay(graph->viewing_area.widget);
  viewing_win = XtWindow(graph->viewing_area.widget);
  virtual_dpy = XtDisplay(graph->virtual_area.widget);
  virtual_win = XtWindow(graph->virtual_area.widget);

  XtGetApplicationResources (graph->viewing_area.widget, graph, resources,
			      XtNumber(resources), NULL, 0);
/*
 *  Now, get the browser resources for callbacks and colortables.
*/
  GetResources(graph->parent);

  graph->xor_gc  = XCreateGC(viewing_dpy, viewing_win, 0, 0);
  graph->graph_gc  = XCreateGC(viewing_dpy, viewing_win, 0, 0);
  graph->text_gc = XCreateGC(viewing_dpy, viewing_win, 0, 0);
  graph->rubber_band_gc = XCreateGC(virtual_dpy, virtual_win, 0, 0);

  XSetFont(viewing_dpy, graph->xor_gc, graph->font->fid);
  XSetFont(viewing_dpy, graph->graph_gc, graph->font->fid);
  XSetFont(viewing_dpy, graph->text_gc, graph->font->fid);


  /*
   * Need to find out information about the graph that is out there.
   * We want to know the background color and the sizes of the viewing
   * area.
   */
  XtSetArg(args[0], XtNbackground, &background);
  XtSetArg(args[1],XmNwidth,&wd);
  XtSetArg(args[2],XmNheight,&ht);
  XtGetValues (graph->viewing_area.widget, args, 3);
  XSetBackground(viewing_dpy, graph->xor_gc, background);
  XSetBackground(viewing_dpy, graph->graph_gc, background);
  XSetBackground(viewing_dpy, graph->text_gc, background);
  graph->viewing_area.width = wd;
  graph->viewing_area.height = ht;

  XSetFunction(viewing_dpy, graph->xor_gc, GXxor);
  
  /*
   * Should we be forcing the foreground color of the virtual area to
   * be the same as the viewing area?  The reason to ask is that the
   * foreground color of the viewing area is the default color of the
   * node when it is drawn (if there are no colors specified).  This color
   * is also used in the virtual area.
   */
  XtSetArg(args[0], XtNbackground, &background);
  XtSetArg(args[1], XtNforeground, &foreground);
  XtSetArg(args[2],XmNwidth,&wd);
  XtSetArg(args[3],XmNheight,&ht);
  XtGetValues(graph->virtual_area.widget, args, 4);
  XSetBackground(virtual_dpy, graph->rubber_band_gc, background);
  XSetForeground(virtual_dpy, graph->rubber_band_gc, foreground);
  XSetFunction(virtual_dpy, graph->rubber_band_gc, GXcopy);
  graph->virtual_area.width = wd;
  graph->virtual_area.height = ht;

  size_hints.flags      = PMinSize;
  size_hints.x          = 0;
  size_hints.y          = 0;
  size_hints.width      = graph->viewing_area.width;
  size_hints.height     = graph->viewing_area.height;
  size_hints.min_width  = MIN_W;
  size_hints.min_height = MIN_H;
  XSetStandardProperties(viewing_dpy, viewing_win,
			 "Browser", "Browser", NULL, 0, 0, &size_hints);
  XMapWindow(viewing_dpy, viewing_win);

  XSelectInput(viewing_dpy, viewing_win, ExposureMask | ButtonPressMask |
	       KeyPressMask | KeyReleaseMask |
	       StructureNotifyMask);

  XSelectInput(virtual_dpy, virtual_win, ExposureMask | ButtonPressMask |
	       KeyPressMask | KeyReleaseMask |
	       StructureNotifyMask);

  /* When button 2 goes (the middle mouse button) we want to make sure
   * that the mouse cannot be moved outside of the window.
   */
  XGrabButton (viewing_dpy, Button2, AnyModifier, viewing_win, FALSE,
	       ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
	       GrabModeAsync, GrabModeAsync,
	       viewing_win,
	       None);
  XGrabButton (virtual_dpy, Button1, AnyModifier, virtual_win, FALSE,
	       ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
	       GrabModeAsync, GrabModeAsync,
	       virtual_win,
	       None);
  XGrabButton (virtual_dpy, Button2, AnyModifier, virtual_win, FALSE,
	       ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
	       GrabModeAsync, GrabModeAsync,
	       virtual_win,
	       None);

  XClearWindow(viewing_dpy,viewing_win);
  XClearWindow(virtual_dpy,virtual_win);
  XFlush(viewing_dpy);
  XFlush(virtual_dpy);
/*  Cmap = DefaultColormap(viewing_dpy, DefaultScreen(viewing_dpy)); */
}

