/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* Message bus structures */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/commands/RCS/struct.h,v $ */

/* $Revision: 2.1.1.1 $
 * $Date: 91/11/15 13:37:53 $
 * $State: Exp $
 * $Author: carroll $
 */

/* ------------------------------------------------------------------------- */

typedef enum { CLIENT_DEAD, CLIENT_ALIVE, } t_client_state;

struct Client
{
  int fd;				/* file descriptor */
  t_client_state state;			/* current state */
  struct mb_chunk input;		/* current waiting input */
  struct mb_chunk output;		/* stuff waiting to go out */
  struct mb_parse_state parse;		/* current parser state */
  struct mb_object *domains;		/* domains and tags to accept */
  unsigned long poll_index;		/* keep p_fd index */
  struct sockaddr_in saddr;		/* client net address */
  struct mb_object *id;			/* identifier */
  char loop;				/* loop messages back to client? */
};
