/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	strtol.c: Implements the strtol() function for systems without it. */
/* For those bogus systems that don't have strtol(), which is truly a
 * wonderful function.
 */

#include <stdio.h>
#include <ctype.h>

long
strtol(str, pptr, base)
	char *str;		/* string to convert */
	char **pptr;		/* pointer to next character */
	int base;		/* base to convert with */
{
  long result = 0;
  char sign = 0;			/* sign character found? */
  char digit = 0;			/* found any digits yet? */
  char c;

  if (NULL != pptr) *pptr = str;	/* default to start */
  if (NULL == str) return result;	/* nothing to parse, leave */

  while (isspace(*str)) ++str;		/* skip over leading space */

  /* check for leading sign */
  if ('-' == *str) { sign = 1; str += 1; }
  else if ('+' == *str) { sign = 0; str += 1; }

  /* check for base indicators */
  if ('0' == *str)
    {
      if ((base <= 0 || 16 == base) && ('x' == *(str+1) || 'X' == *(str+1)))
	{
	  base = 16;
	  str += 2;			/* skip over x */
	}
      else if ((base <= 0 || 2 == base) && ('b' == *(str+1) || 'B' == *(str+1)))
	{
	  base = 2;
	  str += 2;
	}
      else if (base <= 0)
	{
	  base = 8;
	  str += 1;
	}
    }
  else if (base <= 0) base = 10;
    
  for ( c = *str ; c ; c = *++str )
    {
      int n;

      if (isdigit(c)) n = c - '0';
      else if (islower(c)) n = c + 10 - 'a';
      else if (isupper(c)) n = c + 10 - 'A';
      else break;			/* very bad, leave loop */

      if (n >= base) break;
      result = result * base + n;
    }

  if (NULL != pptr) *pptr = str;
  return sign ? -result : result;
}
