/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	array.c: The array widget (RowColumn in Motif Lingo) */
/* widget server array driver code */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node106.text,v $ */

static char rcsid[] = "array.c $Revision: 1.2 $ $Date: 92/05/28 09:22:09 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>
/* ------------------------------------------------------------------------ */
extern void
  ArrayRemove(), ArrayUpdate(), ArrayReply(),
  ArrayChildDestroyed(), ArrayRealized(),
  ArrayEditable(), ArrayTransmit();

extern t_generic_widget ArrayHandle();

struct widget_class_struct ArrayClassRecord =
{
  WS_ARRAY, "array",
  ArrayHandle, ArrayRemove, NULL, ArrayUpdate, ArrayReply,
  ArrayRealized, ArrayTransmit, ArrayEditable,
} ;
/* ------------------------------------------------------------------------ */
/* a array is really just a row column widget, with a possible title.
 * The title widget is managed only if it has been set.
 */
typedef struct array_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  t_generic_widget items;
  Widget w_scrolled;			/* enclosing scrolled widget */
  Widget w_array;			/* the row column widget */
  Widget w_form;			/* enclosing form widget for title */
  Widget w_title;			/* and the title */
  char *embed;				/* embed subwidget transmit data? */

  char *header;			/* Header address to send box to */
  char *tag;			/* Tag for sending the box */
  short wrap;			/* Wrap the bus message in parens ? */
  short transmit;		/* Separately transmit the box? */
  short editable;		/* Save the current editable state */
  t_sexp args;			/* Arguments that we want sent */

} * t_array_widget;

/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct ArrayKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
  { ":orientation", NULL, KEYWORD_SEXP },
  { ":columns", (void *)-1, KEYWORD_INT },
  { ":values", NULL, KEYWORD_SEXP },
  { ":embed", NULL, KEYWORD_RAW },
  { ":width", (void *)-1, KEYWORD_INT },
  { ":height", (void *)-1, KEYWORD_INT },
  { ":header", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_RAW },
  { ":wrap", (void *)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":editable", (void *)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":args", NULL, KEYWORD_GET_SEXP },
  { ":transmit", (void *)KEYWORD_NONE, KEYWORD_FLAG },
};

t_generic_widget
ArrayHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_keyword_flag f_edit, f_transmit;
  t_array_widget array;
  t_generic_widget current;
  t_sexp item;
  t_sexp s_orient;
  t_keyword_flag f_stretch;
  char * title;
  int columns;
  int n, count, width, height;
  
  Arg argl[10];

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;

  array = NEW_STRUCT(array_widget_struct);
  array->type = WS_ARRAY;
  array->class = &ArrayClassRecord;
  array->parent = parent;
  array->top = parent->top;
  array->id = Getnth(sexp, 1);
  array->w_scrolled = NULL;
  array->items = NULL;
  array->values = NULL;

  /* sexp should be (array "id" <items> &key ...) */
  MBparse_keywords(MBnthcdr(sexp,3), ArrayKeywords,
		ARRAY_SIZE(ArrayKeywords));
  title = (char *)ArrayKeywords[0].result;
  s_orient = (t_sexp)ArrayKeywords[1].result;
  columns = (int)ArrayKeywords[2].result;
  array->values = ContextString((t_sexp)ArrayKeywords[3].result);
  array->embed = (char *)ArrayKeywords[4].result;
  width = (int)ArrayKeywords[5].result;
  height = (int)ArrayKeywords[6].result;
  array->header = (char *)ArrayKeywords[7].result;
  array->tag = (char *)ArrayKeywords[8].result;
  array->wrap = (t_keyword_flag)ArrayKeywords[9].result == KEYWORD_TRUE;
  f_edit = (t_keyword_flag)ArrayKeywords[10].result;
  array->args = (t_sexp)ArrayKeywords[11].result;
  f_transmit = (t_keyword_flag)ArrayKeywords[12].result;

  if (width >= 0 || height >= 0)
  {
    /* If the user is specifying a specific width or height then we
     * need scroll bars.
     */
    n = 0;
    if (width > 0)
	XtSetArg(argl[n], XmNwidth, width), ++n;
    if (height > 0)
	XtSetArg(argl[n], XmNheight, height), ++n;
    XtSetArg(argl[n], XmNvisualPolicy, XmCONSTANT), ++n;
    XtSetArg(argl[n], XmNscrollingPolicy, XmAUTOMATIC), ++n;
    XtSetArg(argl[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED), ++n;
    array->w_scrolled = XmCreateScrolledWindow(parent->widget, "scroll",
					     argl, n);
  }    
  /* form */
  XtSetArg(argl[0], XmNuserData, array);
  XtSetArg(argl[1], XmNresizable, True);
  array->w_form = XtCreateWidget("form", xmFormWidgetClass,
				 NULL == array->w_scrolled ? parent->widget
				 : array->w_scrolled, argl, 2);

  /* title */
  array->w_title = CreateTitle(NULL == title ? "" : title, array->w_form);
  XtSetArg(argl[0], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(argl[1], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(argl[2], XmNalignment, XmALIGNMENT_CENTER);
  XtSetArg(argl[3], XmNtopAttachment, XmATTACH_FORM);
  XtSetValues(array->w_title, argl, 4);

  /* Now the row column widget itself */
  n = 0;

  if (columns > 0) XtSetArg(argl[n], XmNnumColumns, columns), ++n;

  /* check the orientation, should be one of :horizontal, :vertical,
   * :pack, or :row */
  if (!MBcompare_Cstring(s_orient, ":horizontal"))
    {
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
  else if (!MBcompare_Cstring(s_orient, ":vertical"))
    {
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
  else if (!MBcompare_Cstring(s_orient, ":pack"))
      XtSetArg(argl[n], XmNpacking, XmPACK_TIGHT), ++n;
  else if (!MBcompare_Cstring(s_orient, ":row"))
    {
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_TIGHT), ++n;
    }

  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  if (NULL == title)
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  else
    {
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
      XtSetArg(argl[n], XmNtopWidget, array->w_title), ++n;
    }

  if (n > ARRAY_SIZE(argl)) fatal_error("Too many array arguments");
  array->w_array = XtCreateWidget("array", xmRowColumnWidgetClass,
				  array->w_form, argl, n);
  /* handle the sub items. They should all be children of the RC
   * widget
   */
  array->widget = array->w_array;

  count = 0;
  for ( item = MBnth(sexp,2) ; MB_CONSP(item) ; item = MB_CDR(item) )
    {
      current = HandleBusItem(array, MB_CAR(item));
      if (NULL != current)
	{
	  current->next = array->items;
	  array->items = current;
	  count += 1;
	}
    }

  /* If a column count of 0 was specified, and there are multiple items,
   * go for a "square" layout.
   */
  if (columns == 0 && count > 1)
    {
      n = 0;
      XtSetArg(argl[n], XmNnumColumns, CalcColumns(count)), ++n;
      XtSetValues(array->w_array, argl, n);
    }

  ManageWidgetList(array->items);

  if (NULL != title) XtManageChild(array->w_title);
  XtManageChild(array->w_array);

  if (KEYWORD_TRUE == f_edit)
  {
    /* If the keyword is true, tell our kids.  If not, nothing to do since
     * everybody defaults to non-editable when created.
     */
    array->class->editable(array, TRUE);
  }
  
  /* Set the transmit value.  If it was not specified it will default
   * to false.
   */
  array->transmit = KEYWORD_TRUE == f_transmit;

  if (array->w_scrolled)
  {
    XtManageChild(array->w_form);
    XtSetArg(argl[0], XmNworkWindow, array->w_form);
    XtSetValues(array->w_scrolled, argl, 1);
    array->widget = array->w_scrolled;
  }
  else
      array->widget = array->w_form;

  return (t_generic_widget) array;
}

/* ------------------------------------------------------------------------ */
void
ArrayRemove(self) t_array_widget self;
{
  MBfree(self->id);
  XtFree(self->values);
  XtFree(self->embed);
  RemoveWidgetList(self->items);

  FREE(self->header);
  FREE(self->tag);
  MBfree(self->args);
  
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the array */
static struct keyword_entry_struct ArrayUpdateKeys[] =
{
  { ":add", NULL, KEYWORD_SEXP },
  { ":delete", NULL, KEYWORD_SEXP },
  { ":editable", KEYWORD_NONE, KEYWORD_FLAG },
  { ":transmit", KEYWORD_NONE, KEYWORD_FLAG },
  { ":columns", (void *)-1, KEYWORD_INT },
  { ":orientation", NULL, KEYWORD_SEXP },
};

void
ArrayUpdate(self,sexp)
     t_array_widget self;
     t_sexp sexp;
{
  Widget temp;
  t_generic_widget current;
  t_sexp add_items, delete_items;
  t_sexp item, s_orient;
  t_generic_widget prev, check_item;
  t_keyword_flag f_edit, f_transmit;
  int columns, count, n;
  Arg argl[10];
  
  if (!MBequal(MBnth(sexp,1), self->id))
    {
      UpdateWidgetList(self->items, sexp);
    }
  else
  {
    MBparse_keywords(MBnthcdr(sexp,2), ArrayUpdateKeys,
		     ARRAY_SIZE(ArrayUpdateKeys));
    add_items = (t_sexp) ArrayUpdateKeys[0].result;
    delete_items = (t_sexp) ArrayUpdateKeys[1].result;
    f_edit = (t_keyword_flag) ArrayUpdateKeys[2].result;
    f_transmit = (t_keyword_flag) ArrayUpdateKeys[3].result;
    columns = (int) ArrayUpdateKeys[4].result;
    s_orient = (t_sexp) ArrayUpdateKeys[5].result;
      
    if (NULL != add_items)
    {
      temp = self->widget;
      self->widget = self->w_array;
	
      for ( item = add_items ; MB_CONSP(item) ; item = MB_CDR(item) )
      {
	current = HandleBusItem(self, MB_CAR(item));
	if (NULL != current)
	{
	  current->next = self->items;
	  self->items = current;
	  XtRealizeWidget(current->widget);
	  current->class->realized(current); /* do final adjustments */
	  /* Set the initial editable state */
	  current->class->editable(current, self->editable);
	}
      }
      ManageWidgetList(self->items);
      self->widget = temp;
    }
    if (NULL != delete_items)
    {
      for ( item = delete_items ; MB_CONSP(item) ; item = MB_CDR(item) )
      {	    
	for (prev = NULL, check_item = self->items;
	     NULL != check_item;
	     prev = check_item, check_item = check_item->next)
	{
	  if (MBequal(check_item->id, MB_CAR(item)))
	  {
	    if (prev)
		prev->next = check_item->next;
	    else
		self->items = check_item->next;
	    XtUnmanageChild(check_item->widget);
	    XtDestroyWidget(check_item->widget);
	    check_item->class->remove(check_item);
	    break;
	  }
	}
      }
    }
    if (KEYWORD_NONE != f_transmit)
	self->transmit = KEYWORD_TRUE == f_transmit;
    /* Make sure all of our children are set to the correct editable state. */
    if (KEYWORD_NONE != f_edit)
	self->class->editable(self, KEYWORD_TRUE == f_edit);

    n = 0;
    /* check the orientation, should be one of :horizontal, :vertical,
     * :pack, or :row */
    if (!MBcompare_Cstring(s_orient, ":horizontal"))
    {
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
    else if (!MBcompare_Cstring(s_orient, ":vertical"))
    {
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
    else if (!MBcompare_Cstring(s_orient, ":pack"))
	XtSetArg(argl[n], XmNpacking, XmPACK_TIGHT), ++n;
    else if (!MBcompare_Cstring(s_orient, ":row"))
    {
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_TIGHT), ++n;
    }
    if (columns >= 0)
    {
      if (columns == 0)
	  columns = CalcColumns(CountWidgetList(self->items));
      XtSetArg(argl[n], XmNnumColumns, columns), ++n;
    }
    if (n > 0)
	XtSetValues(self->w_array, argl, n);
  }
}
/* ------------------------------------------------------------------------ */
void
ArrayReply(self, reply)
     t_array_widget self;
     t_mbus_reply reply;
{
  if (NULL == reply->header) reply->header = strdup(self->header);
  if (NULL == reply->tag) reply->tag = strdup(self->tag);
  if (NULL == reply->args) reply->args = ContextString(self->args);
  self->parent->class->reply(self->parent, reply);
}
/*----------------------------------------------------------------------*/
/* Hook for sending the array data and all of it's children		*/
void
ArrayTransmitHook(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_array_widget self;
{
  if (NULL != self->values) MBput_Cstring(message, self->values);
  TransmitWidgetList(message, orig_reply, self->items);
}

/* ------------------------------------------------------------------------ */
/* Transmit data to the MBus */
void
ArrayTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_array_widget self;
{
  t_mbus_reply reply;
  char *str;
  if (self->transmit)
  {
    /* We want to send the message in a separate tranmission */
    reply = NewReply();
    if (orig_reply->status == TAG_PROVIDED)
    {
      /* If the tag was provided in the original reply, we want to
       * use it here, too.
       */
      reply->tag = strdup(orig_reply->tag);
    }
    else if (orig_reply->status == TAG_AND_ARGS_PROVIDED)
    {
      reply->tag = strdup(orig_reply->tag);
      reply->args = strdup(orig_reply->args);
    }
    reply->transmit = self->transmit;
    reply->status = orig_reply->status;
    reply->wrap = self->wrap;
    reply->hook = ArrayTransmitHook;
    reply->hook_data = (caddr_t) self;
    
    ArrayReply(self, reply);
    SendReply(reply);
    FreeReply(reply);
  }
  else
  {
    if (self->wrap) MBput_Cstring(message, " (");
    if (self->tag) MBput_Cstring(message, self->tag);
    if (NULL == self->args)
    {
      str = ContextString(self->args);
      MBput_Cstring(message, " ");
      MBput_Cstring(message, str);
      FREE(str);
    }    
    if (NULL != self->embed)
    {
      MBput_Cstring(message, " ");
      MBput_Cstring(message, self->embed);
      MBput_Cstring(message, " (");
    }

    MBput_Cstring(message, " ");
    MBput_Cstring(message, self->values);
    TransmitWidgetList(message, orig_reply, self->items);

    if (NULL != self->embed) MBput_Cstring(message, " )");
    if (self->wrap) MBput_Cstring(message, " )");
  }
  
}
/* ------------------------------------------------------------------------ */
void
ArrayEditable(self,flag)
     t_array_widget self;
     int flag;
{
  self->editable = flag;
  EditableWidgetList(self->items, flag);
}
/* ------------------------------------------------------------------------ */
/* Called by a child when it decides to destroy itself for whatever reason.
 * We should update our internal data to remove references to the child.
 * Assume that all of the childs internal and widgets stuff is taken care
 * of by the child.
 */
void
ArrayChildDestroyed(self, child)
     t_array_widget self;
     t_generic_widget child;
{
}
/* ------------------------------------------------------------------------ */
void
ArrayRealized(self) t_array_widget self;
{
  t_generic_widget item;
  int n;
  Dimension cur_width, cur_height;
  Widget clip_widget;
  Arg argl[10];
  
  for (item = self->items ; NULL != item ; item = item->next )
    item->class->realized(item);
}
/* ------------------------------------------------------------------------ */
