/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	field.c: The field widget. */
/* widget server field support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node110.text,v $ */

static char rcsid[] = "field.c $Revision: 1.1 $ $Date: 92/05/08 15:26:06 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/Frame.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>
/* ------------------------------------------------------------------------ */
extern void
  FieldRemove(), FieldUpdate(), FieldReply(), FieldEditable(),
  FieldRealized(), FieldTransmit();

extern t_generic_widget FieldHandle();

extern Pixel GetColor();
extern XFontStruct *GetFont();

struct widget_class_struct FieldClassRecord =
{
  WS_FIELD, "field",
  FieldHandle, FieldRemove, NULL, FieldUpdate, FieldReply, FieldRealized,
  FieldTransmit, FieldEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct field_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  char *key;
  Widget label_widget;
  Widget text_widget;
  Widget form_widget;
  XmFontList font_list;
} * t_field_widget;

/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct FieldKeywords[] =
{
  { ":key", NULL, KEYWORD_COOKED },
  { ":columns", (void *)-1, KEYWORD_INT },
  { ":foreground", NULL, KEYWORD_COOKED },
  { ":font", NULL, KEYWORD_COOKED },
};

t_generic_widget
FieldHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_field_widget field;
  t_sexp s_label, s_value;
  char *label, *value, *foreground_name, *font_name;
  int n;
  int columns;
  Arg argl[16];
  Pixel foreground;
  XFontStruct * font;
  XmFontList font_list = NULL;

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;
  s_label = MBnth(sexp, 2);
  s_value = MBnth(sexp, 3);
  if (!MB_STRINGP(s_value))
    {
      if (MBLogLevel > 1) fprintf(stderr, "Bad type for field value\n");
      return NULL;
    }
  if (!MB_CHUNKP(s_label))
    {
      if (MBLogLevel > 1) fprintf(stderr, "Bad type for field label\n");
      return NULL;
    }

  field = NEW_STRUCT(field_widget_struct);
  field->type = WS_FIELD;
  field->class = &FieldClassRecord;
  field->parent = parent;
  field->top = parent->top;
  field->id = Getnth(sexp, 1);
  field->key = NULL;

  /* sexp should be (field "id" "label" "value" &key key) */
  MBparse_keywords(MBnthcdr(sexp,4), FieldKeywords, ARRAY_SIZE(FieldKeywords));
  field->key = (char *)FieldKeywords[0].result;
  columns = (int)FieldKeywords[1].result;
  foreground_name = (char *)FieldKeywords[2].result;
  font_name = (char *)FieldKeywords[3].result;

  XtSetArg(argl[0], XmNuserData, field);
  /* now, create the outer frame, to look nice */
  field->widget = XtCreateWidget("field", xmFrameWidgetClass,
				 parent->widget, argl, 1);

  /* now a form, to keep things together */
  XtSetArg(argl[1], XmNresizable, True);
  XtSetArg(argl[2], XmNallowResize, True);
  field->form_widget = XtCreateWidget("form", xmFormWidgetClass,
				      field->widget, argl, 3);

  label = MBCstring(s_label);
  field->label_widget = CreateTitle(label, field->form_widget);
  XtSetArg(argl[0], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(argl[1], XmNbottomAttachment, XmATTACH_FORM);
  XtSetArg(argl[2], XmNalignment, XmALIGNMENT_BEGINNING);
  XtSetArg(argl[3], XmNresizable, True);
  XtSetValues(field->label_widget, argl, 4);

  value = MBCstring(s_value);
  n = 0;
  XtSetArg(argl[n], XmNeditable, False), ++n;
  XtSetArg(argl[n], XmNresizeWidth, True), ++n;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_WIDGET), ++n;
  XtSetArg(argl[n], XmNleftWidget, field->label_widget), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNsensitive, False), ++n;
  XtSetArg(argl[n], XmNresizable, True), ++n;
  if (columns > 0) XtSetArg(argl[n], XmNcolumns, columns), ++n;
  if (foreground_name)
  {
    foreground = GetColor(toplevel_widget, foreground_name);
    XtSetArg(argl[n], XmNforeground, foreground), ++n;
    FREE(foreground_name);
  }
  field->font_list = NULL;
  if (font_name)
  {
    font = GetFont(toplevel_widget, font_name);
    if (font)
    {
      /* Don't know here if we can simply free the font_list as soon as
       * we give it to motif.  Thus, we will keep it with the field and
       * free it when the field goes away.  We know that is safe.
       */
      field->font_list = XmFontListCreate (font, XmSTRING_DEFAULT_CHARSET);
      XtSetArg(argl[n], XmNfontList, field->font_list), ++n;
    }
    FREE(font_name);
  }

/*
  XtSetArg(argl[n], XmNvalue, value), ++n;
*/
  field->text_widget = XtCreateWidget("text", xmTextFieldWidgetClass,
				      field->form_widget,
				      argl, n);
  XmTextFieldSetString(field->text_widget, value);

  XtManageChild(field->text_widget);
  XtManageChild(field->label_widget);
  XtManageChild(field->form_widget);

#if 0
  /* put in text and get the widget to resize */
  XtSetArg(argl[0], XmNvalue, value);
  XtSetValues(field->text_widget, argl, 1);
#endif

  XtFree(label); XtFree(value);

  return (t_generic_widget)field;
}
/* ------------------------------------------------------------------------ */
void
FieldRemove(self) t_field_widget self;
{
  if (self->font_list) XmFontListFree(self->font_list);
  MBfree(self->id);
  XtFree(self->key);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the field */
static struct keyword_entry_struct FieldUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":value", NULL, KEYWORD_COOKED },
};

void
FieldUpdate(self,sexp)
     t_field_widget self;
     t_sexp sexp;
{
  char *label, *value;
  Arg argl[1];
  short l_width, t_width;

  if (!MBequal(MBnth(sexp,1), self->id)) return;

  MBparse_keywords(MBnthcdr(sexp,2), FieldUpdateKeys,
		ARRAY_SIZE(FieldUpdateKeys));
  label = (char *)FieldUpdateKeys[0].result;
  value = (char *)FieldUpdateKeys[1].result;

  if (NULL != label) SetTitle(self->label_widget, label);
  if (NULL != value)
    {
      XmTextFieldSetString(self->text_widget, value);
      XmTextFieldShowPosition(self->text_widget, 0);
    }

  XtFree(label); XtFree(value);
}
/* ------------------------------------------------------------------------ */
void
FieldReply(self, reply)
     t_field_widget self;
     t_mbus_reply reply;
{
  /*
  if (NULL == reply->key) reply->key = strdup(self->key);
  if (NULL == reply->value) reply->value = XmTextFieldGetString(self->text_widget);
  */
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
FieldRealized(self) t_field_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
FieldEditable(self, flag)
     t_field_widget self;
     int flag;
{
  Arg argl[2];
  short nc;

  if (NULL == self->key)
    {
      /* can't be editable, but flip sensitive on the label for a
       * visual indication
       */
      XtSetSensitive(self->label_widget, flag ? False : True);
    }
  else
    {

      /* yeah, yeah, but I practice safe computing */
      XmTextFieldSetEditable(self->text_widget, flag ? True : False);
      XtSetSensitive(self->text_widget, flag ? True : False);

      if (flag)
	{
	  /* Let's make sure we have some room here */
	  XtSetArg(argl[0], XmNcolumns, &nc);
	  XtGetValues(self->text_widget, argl, 1);
	  if (nc < 20)
	    {
	      XtSetArg(argl[0], XmNcolumns, 20);
	      XtSetValues(self->text_widget, argl, 1);
	    }
	}
    }
}
/* ------------------------------------------------------------------------ */
void
FieldTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_field_widget self;
{
  char *value, *str;

  if (NULL != self->key)
    {
      MBput_Cstring(message," ");
      MBput_Cstring(message, self->key);
      MBput_Cstring(message, " ");
      value = XmTextFieldGetString(self->text_widget);
      str = QuotifyString(value);
      MBput_Cstring(message, str);
      XtFree(value); XtFree(str);
    }
}
/* ------------------------------------------------------------------------ */
