/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server option menu support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node116.text,v $ */

static char rcsid[] = "option.c $Revision: 1.1 $ $Date: 92/05/08 15:25:35 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/CascadeBG.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
/* ------------------------------------------------------------------------ */
extern void
  OptionRemove(), OptionUpdate(), OptionReply(), OptionRealized(),
  OptionTransmit(), OptionEditable();

extern t_generic_widget OptionHandle();

struct widget_class_struct OptionClassRecord =
{
  WS_OPTION, "option",
  OptionHandle, OptionRemove, NULL, OptionUpdate, OptionReply,
  OptionRealized, OptionTransmit, OptionEditable,
} ;
/* ------------------------------------------------------------------------ */
/* Each of this is just a push-button */
typedef struct option_item_struct
{
  Widget widget;
  t_sexp id;
  char *value;
  struct option_item_struct *next;
} * t_option_item;
  
typedef struct option_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget w_menu;			/* pulldown menu widget */
  char *key;
  t_option_item items;
} * t_option_widget;

/* ------------------------------------------------------------------------ */
t_option_item
OptionNewItem()
{
  t_option_item item;

  item = NEW_STRUCT(option_item_struct);
  item->id = NULL;
  item->next = NULL;
  item->value = NULL;

  return item;
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct oikw[] =
{
  { ":action", NULL, KEYWORD_GET_SEXP },
};
void
OptionHandleItems(option, sexp)
     t_option_widget option;
     t_sexp sexp;
{
  int count = 0;
  t_option_item item;
  t_sexp s_label, s_value, s_item, s_id;
  char *label;
  XmString xm_str;
  int n;
  Arg argl[4];

  /* time to wade throught the sexp and get the menu buttons */
  /* each item is ( id label value ) */
  for ( ; NULL != sexp ; sexp = MB_CDR(sexp) )
    {
      s_item = MB_CAR(sexp);
      s_id = MBnth(s_item,0);
      s_label = MBnth(s_item,1);
      s_value = MBnth(s_item,2);

      if (!MB_STRINGP(s_label) || NULL == s_value) continue;

      count += 1;
      item = OptionNewItem();
      item->id = MBduplicate(s_id);
      item->value = MBprint_Cstring(s_value);
      item->next = option->items;
      option->items = item;

      label = MBCstring(s_label);
      xm_str = CtoXmString(label);
      n = 0;
      XtSetArg(argl[n], XmNlabelString, xm_str), ++n;
      XtSetArg(argl[n], XmNuserData, item), ++n;
      item->widget = XmCreatePushButtonGadget(option->w_menu,
					      "optionButton", argl, n);
      XtFree(xm_str); XtFree(label);
    }
}
/* ------------------------------------------------------------------------ */
void
OptionManageItems(option) t_option_widget option;
{
  int count;
  int i;
  t_option_item item;
  Widget *wl;

  /* Count up how many fields we've got */
  for ( count = 0, item = option->items ; NULL != item ; item = item->next )
    count += 1;

  if (count)
    {
      wl = (Widget *)XtMalloc(count * sizeof(Widget));
      i = count;
      for ( item = option->items ; NULL != item ; item = item->next )
	wl[--i] = item->widget;
      XtManageChildren(wl, count);
      XtFree(wl);
    }
}
/* ------------------------------------------------------------------------ */
void
OptionSelectItem(option, id)
     t_option_widget option;
     t_sexp id;
{
  t_option_item item;
  Arg arg;

  for ( item = option->items ; NULL != item ; item = item->next )
    {
      if (MBequal(id, item->id))
	{
	  XtSetArg(arg, XmNmenuHistory, item->widget);
	  XtSetValues(option->widget, &arg, 1);
	  break;
	}
    }
}
/* ------------------------------------------------------------------------ */
/* Create a option menu. The sexp should be of the form
 * (option "id" (<items>) &key key label)
 */
static struct keyword_entry_struct okw[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":key", NULL, KEYWORD_RAW },
  { ":select", NULL, KEYWORD_SEXP },
};

t_generic_widget
OptionHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_option_widget option;
  t_sexp s_id, s_select;
  char *label;
  XmString xm_label = NULL;
  int n;
  Arg argl[10];

  /* check required arguments first */
  s_id = MBnth(sexp,1);

  if (NULL == s_id) return NULL;

  option = NEW_STRUCT(option_widget_struct);
  option->type = WS_OPTION;
  option->next = NULL;
  option->parent = parent;
  option->top = parent->top;
  option->class = &OptionClassRecord;
  option->id = MBduplicate(s_id);
  option->items = NULL;
  
  /* get the keywords */
  MBparse_keywords(MBnthcdr(sexp,3), okw, ARRAY_SIZE(okw));
  n = 0;
  label = (char *)okw[n++].result;
  option->key = (char *)okw[n++].result;
  s_select = (t_sexp)okw[n++].result;

  if (NULL != label) xm_label = CtoXmString(label);

  /* In order to mesh things, we have to create the menu first, add
   * all the buttons, and then create the option widget.
   */

  /* The menu */
  n = 0;
  option->w_menu = XmCreatePulldownMenu(parent->widget, "optionMenu", argl, n);

  OptionHandleItems(option, MBnth(sexp, 2));

  if (NULL == option->items)
    {
      OptionRemove(option);
      XtDestroyWidget(option->w_menu);
      option = NULL;
    }
  else
    {
      /* create the option widget */
      n = 0;
      XtSetArg(argl[n], XmNsubMenuId, option->w_menu), ++n;
      if (NULL != xm_label) XtSetArg(argl[n], XmNlabelString, xm_label), ++n;
      option->widget = XmCreateOptionMenu(parent->widget, "option", argl, n);

      OptionManageItems(option);
      /* have to select after managing, or the display gets wierd */
      if (NULL != s_select) OptionSelectItem(option, s_select);

    }

  XtFree(xm_label); XtFree(label);
  return (t_generic_widget)option;
}
/* ------------------------------------------------------------------------ */
void
OptionRemove(self) t_option_widget self;
{
  t_option_item item, next;

  item = self->items;
  while (NULL != item)
    {
      next = item->next;
      MBfree(item->id);
      XtFree(item->value);
      XtFree(item);
      item = next;
    }
  XtFree(self->key);
  XtDestroyWidget(self->w_menu);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the option */
static struct keyword_entry_struct oukw[] =
{
  { ":select", NULL, KEYWORD_SEXP },
};

void
OptionUpdate(self,sexp)
     t_option_widget self;
     t_sexp sexp;
{
  t_sexp s_select;
  t_sexp s_id;
  int n;

  s_id = MBnth(sexp, 1);		/* id of the widget to update */

  if (MBequal(s_id, self->id))
    {
      n = 0;
      MBparse_keywords(MBnthcdr(sexp, 2), oukw, ARRAY_SIZE(oukw));
      s_select = (t_sexp)oukw[n++].result;

      if (NULL != s_select) OptionSelectItem(self, s_select);
    }
}
/* ------------------------------------------------------------------------ */
void
OptionReply(self, reply)
     t_option_widget self;
     t_mbus_reply reply;
{
}
/* ------------------------------------------------------------------------ */
void
OptionRealized(self) t_option_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
OptionTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_option_widget self;
{
  Widget w;
  Arg arg;
  t_option_item item;

  /* Get the current menu button */
  XtSetArg(arg, XmNmenuHistory, &w);
  XtGetValues(self->widget, &arg, 1);
  /* get the item pointer from it */
  XtSetArg(arg, XmNuserData, &item);
  XtGetValues(w, &arg, 1);

  if (NULL != item && NULL != self->key)
    {
      MBput_Cstring(message, " ");
      MBput_Cstring(message, self->key);
      MBput_Cstring(message, " ");
      MBput_Cstring(message, item->value);
    }
}
/* ------------------------------------------------------------------------ */
void
OptionEditable(self, flag)
     t_option_widget self;
     int flag;
{
  XtSetSensitive(self->widget, flag ? True : False);
}
/* ------------------------------------------------------------------------ */
