/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	sep.c: The separator widget */
/* widget server separator support */

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/SeparatoG.h>
/* ------------------------------------------------------------------------ */
extern void
  SeparatorRemove(), SeparatorUpdate(), SeparatorReply(), SeparatorEditable(),
  SeparatorRealized(), SeparatorTransmit();

extern t_generic_widget SeparatorHandle();

struct widget_class_struct SeparatorClassRecord =
{
  WS_SEPARATOR, "separator",
  SeparatorHandle, SeparatorRemove, NULL, SeparatorUpdate, SeparatorReply,
  SeparatorRealized, SeparatorTransmit, SeparatorEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct separator_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
} * t_separator_widget;

static struct keyword_entry_struct SeparatorKeywords[] =
{
  { ":width", (void *)-1, KEYWORD_INT },
  { ":height", (void *)-1, KEYWORD_INT },
  { ":orientation", (void *)NULL, KEYWORD_SEXP },
  { ":type", (void *)NULL, KEYWORD_SEXP },
};

t_generic_widget
SeparatorHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_separator_widget separator;
  t_sexp s_type, s_orientation;
  int width, height;
  int n;
  Arg argl[10];

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;

  separator = NEW_STRUCT(separator_widget_struct);
  separator->type = WS_SEPARATOR;
  separator->class = &SeparatorClassRecord;
  separator->parent = parent;
  separator->top = parent->top;
  separator->id = Getnth(sexp, 1);

  MBparse_keywords(MBnthcdr(sexp, 2), SeparatorKeywords,
		   ARRAY_SIZE(SeparatorKeywords));
  n = 0;
  width = (int) SeparatorKeywords[n++].result;
  height = (int) SeparatorKeywords[n++].result;
  s_orientation = (t_sexp) SeparatorKeywords[n++].result;
  s_type = (t_sexp) SeparatorKeywords[n++].result;

  n = 0;
  if (width > 0)
      XtSetArg(argl[n], XmNwidth, width), ++n;

  if (height > 0)
      XtSetArg(argl[n], XmNheight, height), ++n;

  if (!MBcompare_Cstring(s_orientation, ":horizontal"))
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
  else if (!MBcompare_Cstring(s_orientation, ":vertical"))
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;

  if (!MBcompare_Cstring(s_type, ":single-line"))
      XtSetArg(argl[n], XmNseparatorType, XmSINGLE_LINE), ++n;
  else if (!MBcompare_Cstring(s_type, ":double-line"))
      XtSetArg(argl[n], XmNseparatorType, XmDOUBLE_LINE), ++n;
  else if (!MBcompare_Cstring(s_type, ":single-dashed-line"))
      XtSetArg(argl[n], XmNseparatorType, XmSINGLE_DASHED_LINE), ++n;
  else if (!MBcompare_Cstring(s_type, ":double-dashed-line"))
      XtSetArg(argl[n], XmNseparatorType, XmDOUBLE_DASHED_LINE), ++n;
  else if (!MBcompare_Cstring(s_type, ":no-line"))
      XtSetArg(argl[n], XmNseparatorType, XmNO_LINE), ++n;
  else if (!MBcompare_Cstring(s_type, ":etched-in"))
      XtSetArg(argl[n], XmNseparatorType, XmSHADOW_ETCHED_IN), ++n;
  else if (!MBcompare_Cstring(s_type, ":etched-out"))
      XtSetArg(argl[n], XmNseparatorType, XmSHADOW_ETCHED_OUT), ++n;

  separator->widget = XmCreateSeparatorGadget(parent->widget, "separator",
					      argl, n);

  return (t_generic_widget)separator;
}
/* ------------------------------------------------------------------------ */
void
SeparatorRemove(self) t_separator_widget self;
{
  MBfree(self->id);
  XtFree(self);
}

void
SeparatorUpdate(self,sexp)
     t_separator_widget self;
     t_sexp sexp;
{
}
/* ------------------------------------------------------------------------ */
void
SeparatorReply(self, reply)
     t_separator_widget self;
     t_mbus_reply reply;
{
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
SeparatorRealized(self) t_separator_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
SeparatorEditable(self, flag)
     t_separator_widget self;
     int flag;
{
}
/* ------------------------------------------------------------------------ */
void
SeparatorTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_separator_widget self;
{
}
/* ------------------------------------------------------------------------ */
