/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server definitions include file */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node126.text,v $
 * $Revision: 1.0.1.2 $
 * $Date: 92/05/08 15:24:46 $
 * $State: Exp $
 * $Author: CBmgr $
 */

/* ------------------------------------------------------------------------ */
/* All of the widgets also have a parallel C struct that contains server
 * information about them. Each type of widget has its own struct, but they
 * all must share a certain set of required slots, which are defined
 * below.
 */

typedef enum
{
  WS_GENERIC,				/* generic widget */
  WS_SHELL,				/* top level shell */
  WS_MENU,				/* menu */
  WS_BOX,				/* a box (paned window) */
  WS_MENU_BAR,				/* menu bar */
  WS_FIELD,				/* field (button) */
  WS_LIST,				/* list of items */
  WS_BUTTON,				/* menu or push button */
  WS_CONTAINER,				/* scrolled list of other things */
  WS_AREA,				/* blank area for other clients */
  WS_PROMPT,				/* prompt dialog box */
  WS_TEXT,				/* multi-line non-editable text */
  WS_RADIO,				/* 1 of N radio box */
  WS_TOGGLE,				/* toggle button */
  WS_FILE,				/* file selection widget */
  WS_ARRAY,				/* RowColumn container */
  WS_OPTION,				/* Option menu */
  WS_LABEL,				/* Simple label */
  WS_SEPARATOR,				/* Simple separator */
} t_widget_type;

typedef enum
{
  POPUP_WARNING,			/* warning box */
  POPUP_MESSAGE,
  POPUP_ERROR,
} t_popup_box_type;

typedef enum
{
  NONE_PROVIDED,
  TAG_PROVIDED,
  TAG_AND_ARGS_PROVIDED,
} t_reply_status_type;

#define DECLARE_STANDARD_WIDGET_SLOTS \
	Widget widget;	\
	t_widget_type type; \
	t_sexp id; \
	char *values; \
	struct widget_class_struct *class; \
	struct generic_widget_struct *parent; \
	struct generic_widget_struct *next; \
  	struct generic_widget_struct *top

/* This is the generic struct. It's never actually used itself, but it
 * serves as a generic pointer type, and for extracting standard fields.
 */
typedef struct generic_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
} * t_generic_widget;

typedef enum { SHELL_NORMAL, SHELL_PROMPT, SHELL_PERSISTENT } t_shell_type;

/* each X window displayed has a top level shell associated with it, which
 * contains the context for all the widgets in the window. This data is
 * stored in the shell widget struct.
 */
typedef struct shell_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  t_shell_type stype;
  t_sexp context;		/* shell context */
  char *tag;			/* transmit tag */
  char *destroy;		/* destroy tag */
  char *mbus_header;		/* header for messages */
  t_generic_widget child;	/* the child widget */
  char mbus_wrap;		/* wrap the sexp in parens? */
  t_sexp transmit_values;	/* tmp holder for transmit */
  t_sexp args;			/* arguments for transmission */
  short transmit;		/* Does the shell have transmittable data? */
} * t_shell_widget;

/* ------------------------------------------------------------------------ */
/* Function lists for the various widget types */

typedef struct widget_class_struct
{
  t_widget_type type;
  char *tag;
  t_generic_widget (*handle)();		/* generate widget from message */
  void (*remove)();			/* clean up, your widget's toast */
  void (*child_remove)();		/* tell the parent we've left */
  void (*update)();			/* for update messages */
  void (*reply)();			/* takes a mbus_reply_struct ptr */
  void (*realized)();			/* called after being realized */
  void (*transmit)();			/* transmit contents back */
  void (*editable)();			/* set editable mode */
} * t_widget_class;
/* ------------------------------------------------------------------------ */
/* Structure that gets passed around to prepare for sending a message back
 * to the MBus.
 */

typedef struct mbus_reply_struct
{
  char * header;		/* message header, tag / domain */
  char * tag;			/* command tag */
  char * id;			/* id for command */
  char * args;			/* arguments for command */
  char * context;		/* context values */
  char * key;			/* reply specific key */
  char * value;			/* trailing value(s) */
  char wrap;			/* wrapper flag */
  /* If transmit isn't true, it cant' be sent; however, we will still call
   * the hook to see if it wants to transmit any data.
   */
  short transmit;
  /* Let us know if the tag (and args) are provided for us by a transmit
   * call.
   */
  t_reply_status_type status;
  void (*hook)();		/* hook function */
  caddr_t hook_data;		/* data for hook function */
} * t_mbus_reply;
/* ------------------------------------------------------------------------ */

#define ARRAY_SIZE(a) (sizeof(a)/sizeof(*(a)))
#define NEW_STRUCT(s) ( (struct s *) malloc(sizeof(struct s)))
#define NEW(s) ( (s *) malloc(sizeof(s)) )
#define FREE(s) if (s) free(s)

#define NULLP(x) (NULL == (x)					\
		  || ((MB_CHUNKP((x)) &&			\
		       (!MBcompare_Cstring((x), "NIL")		\
			|| !MBcompare_Cstring((x), "nil"))	\
		       )))
