/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.PadOption;

public class ParenPadCheck
extends AbstractOptionCheck {
    public ParenPadCheck() {
        super(PadOption.NOSPACE);
    }

    public int[] getDefaultTokens() {
        return new int[]{77, 76, 43, 42, 23, 27};
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 77) {
            this.processRight(aAST);
        } else {
            this.processLeft(aAST);
        }
    }

    private void processLeft(DetailAST aAST) {
        String line = this.getLines()[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + 1;
        if (after < line.length()) {
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                this.log(aAST.getLineNo(), after, "ws.followed", (Object)"(");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after)) && line.charAt(after) != ')') {
                this.log(aAST.getLineNo(), after, "ws.notFollowed", (Object)"(");
            }
        }
    }

    private void processRight(DetailAST aAST) {
        String line = this.getLines()[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before >= 0) {
            boolean followsEmptyForIterator = false;
            DetailAST parent = aAST.getParent();
            if (parent != null && parent.getType() == 84) {
                DetailAST forIterator = parent.findFirstToken(37);
                boolean bl = followsEmptyForIterator = forIterator.getChildCount() == 0 && aAST == forIterator.getNextSibling();
            }
            if (followsEmptyForIterator) {
                return;
            }
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.log(aAST.getLineNo(), before, "ws.preceeded", (Object)")");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(before)) && line.charAt(before) != '(') {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "ws.notPreceeded", (Object)")");
            }
        }
    }
}

