.bp
.so include.n
.EQ
delim $$
.EN
.ie \nH \{\   \" make a help.txt
.pl 800 
.fo ````
.ds B \fI
.nr sp 1
.ls 1\}
.el \{\
.po
.pn 1
.fo ``-B.%-``
.nr sp 0
.ls 2 \}
.nh
.sp 2
.ce
Appendix B
.ce
REDTEN\ Functions
.he ``REDTEN\ Functions``
.pp
REDTEN provides a large number of functions which perform many of 
the common tensor operations of interest in General Relativity and
differential geometry. In general, REDTEN functions are of three 
types: those which perform mathematical operations with indexed 
objects; those which provide utility functions related to indexed
objects; and those which are general functions, of use in a system
not supporting indexed objects.
.pp
The arguments to each function are in general a combination of 
indexed objects and other expressions. An indexed object may be passed 
to a routine in one of two ways: the object name may be given,
or an object reference may be made (which can
include shift operators, and which will generate the necessary object
if it does not exist). When a name is required for the output object, 
the name must be atomic. Since all indexed objects are
auto-quoted (they evaluate to their own name), quoting of these names is
not required. File-name arguments are given as strings.
.sp 5
.br
.in 3
.sp 1
.ne 5 
.br
.ti 0
\*Bchristoffel1\fP ({name})
.\" .ix christoffel1\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:christoffel1\fP>
.br
For the current metric this function computes the Christoffel
symbols of the first kind. If <name> is non-NIL, the symbol is
computed and given that name. If <name> is NIL, a look-up is
performed to find the currently defined symbol; if none is found the
symbol is computed, with the value of 
\*BLisp:christoffel1\fP [\*Bc1\fP] as its name.
This object is symmetric in its first two indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bchristoffel2\fP ({name})
.\" .ix christoffel2\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:christoffel2\fP>
.br
For the current metric this function computes the Christoffel
symbols of the second kind. If <name> is non-NIL, the symbol is
computed and given that name. If <name> is NIL, a look-up is
performed to find the currently defined symbol; if none is found the
symbol is computed, with the value of 
\*BLisp:christoffel2\fP [\*Bc2\fP] as its name.
This object has a contravariant first index and is symmetric in its second
and third indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bcleartmp\fP ()
.\" .ix cleartmp\ ()
.br
.ti 0
Returns:\ t
.br
This function removes all temporary indexed objects currently in
the system. These objects have names of the form tmp*<number>. 
\*Bcleartmp\fP
also resets certain system variables to their initial state.
.sp 1
.ne 5 
.br
.ti 0
\*Bcmod\fP (z)
.\" .ix cmod\ (z)
.br
.ti 0
Returns:\ complex modulus of z
.br
\*Bcmod\fP
\x`-\n(sp`computes $|z|~\(eq~"sqrt"~(z~\(**~z bar )$.
.sp 1
.ne 5 
.br
.ti 0
\*Bcofactor\fP (name1, name2, {transpose-flag})
.\" .ix cofactor\ (name1, name2, {transpose-flag})
.br
.ti 0
Returns:\ <name2>
.br
The function 
\*Bcofactor\fP
computes the cofactor matrix of the
rank-2 object <name1>; the result is assigned to <name2>. This object
has the same symmetries as <name1>. If <transpose-flag> is
non-NIL, the transpose of the cofactor matrix is placed in <name2>. 
.sp 1
.ne 5 
.br
.ti 0
\*Bcomplex\fP (z1, {z2, ..})
.\" .ix complex\ (z1, {z2, ..})
.br
.ti 0
Returns:\ t
.br
\*Bcomplex\fP
flags the variables <z1>, <z2>,\ .. as complex.
\*Bonj\fP uses this flag
to determine which variables are real and which are complex.
.sp 1
.ne 5 
.br
.ti 0
\*Bconj\fP (z)
.\" .ix conj\ (z)
.br
.ti 0
Returns:\ conjugate of <z>
.br
\*Bconj\fP
\x`-\n(sp`computes $z bar$. Complex quantities are either declared
complex with 
\*Bcomplex\fP
or involve I explicitly.
.sp 1
.ne 5 
.br
.ti 0
\*Bcopy\fP (inname, outname)
.\" .ix copy\ (inname, outname)
.br
.ti 0
Returns:\ <outname>
.br
The indexed object <inname> is copied to the object <outname>.
If <outname> is protected, 
\*Bcopy\fP
will fail.
.sp 1
.ne 5 
.br
.ti 0
\*Bcov\fP (name)
.\" .ix cov\ (name)
.br
.ti 0
Returns:\ <name>#CD
.br
This function computes the covariant derivative of <name> and places the
result on <name>'s property list under the key \*B#DBR\fP. The name of the derivative
is of the form <name>#CD (unless the covariant derivative is 0). If
<name> is a shifted object, then the covariant derivative of the
parent object is found or computed and shifted as required.
Note that this function is implicitly called
during an evaluation when an index contains the \*B||\fP operator.
.sp 1
.ne 5
.br
.ti 0
\*Bd\fP (exp)
.\" .ix d\ (exp)
.br
.ti 0
Returns:\ total derivative of <exp>.
.br
.sp 1
.ie n .ig TR
\*Bd\fP
computes $sum from i\(eq0 to i\(eqn-1 { {\(pd (exp)} over \(pdx sub i } d(x sub i )$
.TR
.el .ig NR
.nf
.ls 1
              n-1
              --  di(exp)
   _d computes >   ------- d(x ).
              --  di(x )     i
              i\(eq0     i
.ls
.fi
.NR
.br
.sp 1
This function is used in constructing line-elements for 
\*Bmetric.\fP
It computes the total derivative of its argument if this is not a
coordinate name.
.sp 1
.ne 5 
.br
.ti 0
\*Bdalambert\fP (exp)
.\" .ix dalambert (exp)
.br
.ti 0
Returns:\ d'Alambertian of <exp>
.br
For the current metric \*Bdalambert\fP
computes the d'Alambertian of the given expression. This expression must
be a scalar, or contract to one.
.sp 1
.ne 5 
.br
.ti 0
\*Bdelta\fP (name, frame)
.\" .ix delta\ (name, frame)
.br
.ti 0
Returns:\ <name>
.br
This function constructs three delta functions in the
frame determined by the integer <frame> (frame \(eq 1, 2, 3, 4, 5, where these
integers are determined by the 
\*Bconcov\fP
list required).
Normally, this function should not be needed since a complete set of
system delta functions is generated during the system-build. Note that
the above mentioned delta functions are hidden, they do not appear in
the directory listing and cannot be deleted by 
\*Brem\fP. These objects are named d<frame>.
.sp 1
.ne 5 
.br
.ti 0
\*Bdet\fP (name, {exp})
.\" .ix det\ (name, {exp})
.br
.ti 0
Returns:\ determinant of <name>
.br
\*Bdet\fP
computes the determinant of <name>, which must be a rank-2
object. The determinant is stored on <name>'s property list under the
key \*Bdet\fP. If <exp> is non-NIL, then <exp> replaces the stored determinant.
If the object is changed, the value returned by \*Bdet\fP still reflects the
previous state of the object; do PUT (<name>, 'DET, 'NIL) to clear the
value and re-run \*Bdet\fP.
  Note that the REDUCE matrix determinant function has been moved to
\*Bmdet\fP.
.sp 1
.ne 5 
.br
.ti 0
\*Bdeterm\fP (name, cofactor-name, {transpose-flag})
.\" .ix determ\ (name, cofactor-name, {transpose-flag})
.br
.ti 0
Returns:\ <determinant>
.br
\*Bdeterm\fP is similar to \*Bdet\fP, but uses the cofactor matrix
computed by a call to \*Bcofactor\fP to compute the determinant. See 
\*Bcofactor\fP.
.sp 1
.ne 5 
.br
.ti 0
\*Bdir\fP ({name1, name2, ..})
.\" .ix dir\ ({name1, name2, ..})
.br
.ti 0
Returns:\ t
.br
This function displays a directory of all
indexed objects currently in existence (or just those named as arguments),
along with certain information
about each, and a summary of total numbers and total top-level nodes
used. 
.sp 1
.ne 5 
.br
.ti 0
\*Bdiv\fP (name, {exp})
.\" .ix div\ (name, {exp})
.br
.ti 0
Returns:\ divergence of <name>
.br
\*Bdiv\fP
computes the divergence of the vector <name>, and returns this
scalar. This function also requires a current tensor metric be defined.
The divergence is stored on <name>'s property list under the
key \*Bdiv\fP. If <exp> is non-NIL, then <exp> replaces the stored divergence.
If <exp> is t, simp is applied to the stored divergence and the
result replaces it.
.sp 1
.ne 5 
.br
.ti 0
\*Beinstein\fP ({name})
.\" .ix einstein\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:einstein\fP>
.br
For the current metric this function computes the Einstein tensor.
If <name> is non-NIL, the tensor is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BLisp:einstein\fP
[\*Bei\fP] as its name. This object is symmetric in its two
covariant indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bfn\fP (function, index)
.\" .ix fn\ (function, index)
.br
.ti 0
Returns:\ <index> applied to value of <function>.
.br
\*Bfn\fP
allows the user to call an indexed object returning function with an index.
The index is applied to the object, and the value returned is that which
is appropriate for the index. For example, fn (christoffel1(), [0,1,1]);
calls
\*Bchristoffel1\fP
and returns the value of the [0,1,1] element. <index> must  be enclosed in
square brackets.
.sp 1
.ne 5 
.br
.ti 0
\*Bfreinstein\fP ({name})
.\" .ix freinstein\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:freinstein\fP>
.br
For the current frame metric this function computes the frame Einstein tensor.
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
object; if none is found the object is computed, with the value of
\*BLisp:freinstein\fP [\*Bfrei\fP] as its name. This object is symmetric in
its two covariant frame indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bfrmetric\fP ({name}, {flag})
.\" .ix frmetric\ ({name}, {flag})
.br
.ti 0
Returns:\ <name> or <\*BLisp:frmetric\fP>
.br
This function creates an frame metric with the value of
\*BLisp:frmetric\fP [\*Beta\fP] as its name. 
.sp 1
.ne 5 
.br
.ti 0
\*Bfrricci\fP ({name})
.\" .ix frricci\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:frricci\fP>
.br
For the current frame metric this function computes the frame Ricci tensor.
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
object; if none is found the object is computed, with the value of
\*BLisp:frricci\fP [\*Bfrric\fP] as its name. The frame Ricci tensor
is symmetric in its two covariant frame indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bfrriccisc\fP ({name}, {exp})
.\" .ix frriccisc\ ({name}, {exp})
.br
.ti 0
Returns:\ Ricci scalar
.br
For the current frame metric, this function will compute the Ricci
scalar. If <name> is non-NIL, the scalar is computed and assigned to
that name. If <name> is NIL, a look-up is performed to find the
currently defined scalar, or if none is found the scalar is computed
and assigned to the value of \*BLisp:frriccisc\fP [\*Bfrricsc\fP].
.ti +3
If <exp> is non-NIL it replaces the scalar returned by 
\*Bfrriccisc\fP
from storage on the property list of the frame Ricci tensor;
The value should be the same as that returned by 
\*Briccisc\fP
for the
corresponding tensor metric.
.sp 1
.ne 5 
.br
.ti 0
\*Bfrriemann\fP ({name})
.\" .ix frriemann\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:frriemann\fP>
.br
For the current frame metric this function computes the frame Riemann tensor.
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
object; if none is found the object is computed, with the value of
\*BLisp:frriemann\fP [\*Bfrri\fP] as its name. This object is fully
covariant and has the full Riemann symmetry.
.sp 1
.ne 5 
.br
.ti 0
\*Bfrweyl\fP ({name})
.\" .ix frweyl\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:frweyl\fP>
.br
For the current frame metric this function computes the frame Weyl conformal
curvature tensor. If <name> is non-NIL, the object is computed and
given that name. If <name> is NIL, a look-up is performed to find
the currently defined object; if none is found the object is computed,
with the value of 
\*BLisp:frweyl\fP [\*Bfrc\fP] as its name. This object
has the Riemann
symmetry and has four covariant indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bgamma\fP ({name})
.\" .ix gamma\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:gamma\fP>
.br
For the current frame metric and tensor-frame connection this function
computes the Ricci rotation coefficients in a tetrad frame. 
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
object; if none is found the object is computed, with the value of
\*BLisp:gamma\fP [\*Bgam\fP] as its name. 
.sp 1
.ne 5 
.br
.ti 0
\*Bgeodesic\fP (name, {param})
.\" .ix geodesic\ (name, {param})
.br
.ti 0
Returns:\ <name>
.br
For the current metric tensor, this function computes the geodesic
equations of motion, and places them in the matrix <name>. The affine
parameter [\*Bs\fP] may be specified by entering the desired variable as
<param>. Note that the current coordinates are made to depend on this
parameter.
.sp 1
.ne 5 
.br
.ti 0
\*Bgetcon\fP (con)
.\" .ix getcon\ (con)
.br
.ti 0
Returns:\ name of connection of type <con>
.br
\*Bgetcon\fP
looks into the connection list 
\*BLisp:currentconnection\fP
to
find the name of the connection of type <con>; 1 -- tensor-frame,
2 -- tensor-spinor, 3 -- frame-spinor.
.sp 1
.ne 5 
.br
.ti 0
\*Bgetmet\fP (met)
.\" .ix getmet\ (met)
.br
.ti 0
Returns:\ metric of type <met>
.br
\*Bgetmet\fP looks into the metric list \*BLisp:currentmetric\fP to find
the name of the metric of type <met>.
If <met> \(eq 1, the tensor metric is returned, if
<met> \(eq 2, the frame component metric is returned, if <met>
\(eq 3, the spinor metric is returned, if <met> \(eq 4, the dotted
spinor metric is returned, if <met> \(eq 5, the matrix metric is
returned. If <met> is negative, the corresponding inverse metric
names are returned. 
.sp 1
.ne 5 
.br
.ti 0
\*Bhelp\fP ({name})
.\" .ix help\ ({name})
.br
.ti 0
Returns:\ t
.br
\*Bhelp\fP
provides an on-line help facility. When <name> is that of a
REDTEN function or subroutine 
\*Bhelp\fP
will display information
about that routine from this section of the manual. When <name> is
missing, \*Bhelp\fP lists all those
routines for which help is available. \*Bhelp\fP reads the file 
named under the key \*Bhelpfile\fP on the symbol \*Bhelplist*\fP.
.sp 1
.ne 5 
.br
.ti 0
\*Bias\fP (name)
.\" .ix ias\ (name)
.br
.ti 0
Returns:\ <name>
.br
This function provides a simple facility for assigning elements to
an indexed object. Only the canonical form of symmetrically related 
elements is considered for assignment. The user is prompted for the
input, which must be terminated by a valid terminator. A input line
consisting solely of a terminator causes a premature exit from the
function. Only indexed objects which are not write-protected may be
assigned.
.sp 1
.ne 5 
.br
.ti 0
\*Bim\fP (z)
.\" .ix im\ (z)
.br
.ti 0
Returns:\ imaginary part of <z>
.br
.sp 1
.over :e1 (z\ -\ z:obar) 2\ i
.sp 1
\x`-\n(sp`\*Bim\fP computes $(z~-~z bar )/ (2~I)$.
.sp 1
.ne 5 
.br
.ti 0
\*Bindexed\fP (name)
.\" .ix indexed\ (name)
.br
.ti 0
Returns:\ indexed property of <name>
.br
This function determines whether the object <name> is indexed. The
value returned is NIL if the object is not indexed; otherwise one of
\*Btensor\fP, \*Bframe\fP, \*Bspinor\fP, \*Bmatrix\fP, \*Bmixed\fP
or \*Bscalar\fP is returned.
.sp 1
.ne 5 
.br
.ti 0
\*Binvert\fP (name)
.\" .ix invert\ (name)
.br
.ti 0
Returns:\ <name>#INV
.br
\*Binvert\fP
computes the matrix inverse of the rank-2
object <name>, and gives it the name <name>#INV. The indices
of the inverse are shifted with respect to those of <name>. The
reciprocal of the determinant of the matrix is placed in the
\*Bmultiplier\fP
property of the inverse. The inverse matrix has the same
symmetries as <name>.
.sp 1
.ne 5 
.br
.ti 0
\*Biprop\fP (name)
.\" .ix iprop\ (name)
.br
.ti 0
Returns:\ t
.br
\*Biprop\fP
displays a pretty printed version of those elements of
<name>'s property list which are specified in the control variable
\*BLisp:iprop**\fP.
This function is also called when the elements of a single object are
being displayed. In this case, if the switch 
\*Biprop\fP [t] is NIL, the property list is not displayed.
.sp 1
.ne 5 
.br
.ti 0
\*Bkilling\fP (name, {conf})
.\" .ix killing\ (name, {conf})
.br
.ti 0
Returns:\ <name>
.br
This function computes the Killing equations for the current tensor
metric. The equations are placed in the matrix <name>. If the
parameter <conf> is non-NIL, the conformal Killing equations are
computed, otherwise the conformal factor is taken as zero. The Killing
vector name is the value of 
\*BLisp:killing\fP [\*Bk\fP], and is declared to be
implicit and to depend on all the current coordinates. 
.sp 1
.ne 5 
.br
.ti 0
\*Blie\fP (name, vector)
.\" .ix lie\ (name, vector)
.br
.ti 0
Returns:\ <name>
.br
This function computes the Lie derivative of <name> in the
direction of <vector>. The result
is placed in the object named <name><vector>#LIE.
.sp 1
.ne 5 
.br
.ti 0
\*Bmapfi\fP (indexed-object)
.\" .ix mapfi\ (indexed-object)
.br
.ti 0
or
.br
.ti 0
\*Bmapfi\fP (function ({args,..,} indexed-object, {args,..}))
.\" .ix mapfi\ (function (args, indexed-object, args))
.br
.ti 0
Returns:\ <indexed-object>
.br
\*Bmapfi\fP
maps either the system evaluation function (first form) or
the function indicated by the formal function call (second form) with 
the given arguments. <indexed-object> is either simply the object name or
an object reference with a formal index which may indicate a shift operation.
Integer indices may restrict the application of the mapping to parts of the
object. The multiplier becomes 1 after the mapping is done.
The original value of <name> and its multiplier are saved in the
global variable \*BLisp:mapback\fP.
.sp 1
.ne 5 
.br
.ti 0
\*Bmclear\fP ()
.\" .ix mclear\ ()
.br
.ti 0
Returns:\ 80
.br
\*Bmclear\fP
resets parser variables and the linelength if the i/o system becomes confused
due to an error or interrupt.
.sp 1
.ne 5 
.br
.ti 0
\*Bmetric\fP ({line-element}, {name})
.\" .ix metric\ ({line-element}, {name})
.br
.ti 0
or
.br
.ti 0
\*Bmetric\fP (name)
.br
.ti 0
Returns:\ <name> or <\*BLisp:metric\fP>
.br
Given the line element <line-element>, this function computes the
corresponding metric tensor and its inverse. If name is not given, the
value of 
\*BLisp:metric\fP [\*Bg\fP] is used as the default tensor name; the inverse is
given the name <\*BLisp:metric\fP>#INV. If the current metric tensor is undefined,
\*Bmetric\fP
declares it to be this object. Note that the names of all
geometrical objects are stored on the property list of the metric tensor.
.ti +3
The line element is of the form: 
.sp 1
.ne 5 
.ti +3
name: g\x`\n(sp`\*D0\ 0\*U\ 
\*Bd\fP
(x\x`\n(sp`\*D0\*U)^2\ +\ g\x`\n(sp`\*D0\ 1\*U\ 
\*Bd\fP
(x\x`\n(sp`\*D0\*U)\ 
\*Bd\fP
(x\x`\n(sp`\*D1\*U) + ...
.sp 1
.ne 5 
where each x\x`\n(sp`\*Di\*U is one of the current coordinates as defined on the 
global 
\*BLisp:coords\fP
list. The operator 
\*Bd\fP
indicates which elements
of the line element are coordinate displacements.
.ti +3
If <line-element> is NIL, the metric is computed from the frame metric
and the tensor-frame connection. In the second form of use, a previously
computed object <name> will be turned into a metric tensor if it is a
rank-2 covariant tensor. The inverse metric will have the name <name>#INV.
.sp 1
.ne 5 
.br
.ti 0
\*Bmkcoords\fP (name, {coords})
.\" .ix mkcoords\ (name, {coords})
.br
.ti 0
Returns:\ <name>
.br
\*Bmkcoords\fP
constructs a contravariant vector from the currently
defined coordinates in <name>. The
coordinates which are placed on the property list are either the
current coordinates or the parameter <coords>.
.sp 1
.ne 5 
.br
.ti 0
\*Bmkscalar\fP (name)
.\" .ix mkscalar\ (name)
.br
.ti 0
Returns:\ <name>
.br
\*Bmkscalar\fP
declares <name> to be an 'indexed' scalar. The value of <name> can
only be accessed with an empty index (eg. Q[]); any previous value of
<name> is moved to the required location when the object is created
and returned to the value 
cell of <name> when the object is deleted via \*Brem\fP. If name is
used with a non-empty index, it must indicate a derivative operation.
.sp 1
.ne 5 
.br
.ti 0
\*Bmktnsr\fP (name, {concov}, {symmetry}, {implicit}, {type})
.\" .ix mktnsr\ (name, {concov}, {symmetry}, {implicit}, {type})
.br
.ti 0
Returns:\ <name>[<test index>]
.br
This function creates the indexed object <name>, with
indices as indicated by the parameter <concov>. The number of indices
is given by the length of <concov>; an index is contravariant or
covariant if the corresponding element of <concov> is positive, or
negative, respectively. The type of each indice is given by the
numerical value of the elements of <concov>: 1 -- tensor index, 2 --
frame component index, 3 -- spinor index, 4 - dotted spinor index, 5
-- matrix index. If <concov> is NIL, <name> is partially created,
this is useful when placing a symmetry list on <name>.
.ti +3
The symmetries of the object are given by a non-NIL <symmetry>,
which consists of a list of independent symmetry lists of the form: 
.sp 1
.ne 5 
.ce
(({c,} l, p\x`\n(sp`\*D1\*U, p\x`\n(sp`\*D2\*U, p\x`\n(sp`\*D3\*U, ..), .. {(h, p\x`\n(sp`\*D1\*U, p\x`\n(sp`\*D2\*U, ..)})
.sp 1
.ne 5 
.ti +3
In each list <l> is the size of the
blocks involved in the symmetry, if <l> is negative then an anti-symmetry
is implied. If <l> is 0, then a trace symmetry is implied but the block
size is 1. The locations of each block in the index are given by the
pointers p\x`\n(sp`\*Di\*U. If the letter 'C' is prepended to the list, it indicates that
a complex conjugate is to be taken when permuting the index. The form
beginning with the letter 'H' specifies a Hermitian symmetry. In this case,
the pointers p\x`\n(sp`\*Di\*U must point to spinor dotted-spinor blocks within the
\*Bconcov\fP
list of <name>. An example of a symmetry list describing
the Riemann symmetry is '((-1 1 2) (-1 3 4) (2 1 3)). Note that the
internal form of the symmetry list is somewhat different.
.ti +3
If <implicit> is non-NIL and the name of an equivalent indexed 
object, then any element reference that would otherwise return zero 
(and is not identically zero by virtue of the intrinsic symmetries),
will instead return the value <implicit> as an indexed element; or if
<implicit> is an integer, that integer is returned.
.ti +3
The type of the object may be specified if <type> is non-NIL. 
.sp 1
.ne 5 
.br
.ti 0
\*Bmultiplier\fP (name, {exp})
.\" .ix multiplier\ (name, {exp})
.br
.ti 0
Returns:\ multiplier of <name>
.br
This function provides access to the 
\*Bmultiplier\fP
property of <name>.
If <exp> is NIL, the multiplier is retrieved,
if <exp> is non-NIL, <exp> replaces the multiplier.
.sp 1
.ne 5 
.br
.ti 0
\*Bnocomplex\fP (z1, {z2, ..})
.\" .ix nocomplex\ (z1, {z2, ..})
.br
.ti 0
Returns:\ t
.br
\*Bnocomplex\fP
removes the complex flag from the <z\x`\n(sp`\*Di\*U>.
.sp 1
.ne 5 
.br
.ti 0
\*Bnodir\fP (name1, {name2, ..})
.\" .ix nodir\ (name1, {name2, ..})
.br
.ti 0
Returns:\ t
.br
This function flags each of the indexed objects name\x`\n(sp`\*Di\*U so they will
not appear in a directory listing. Each flagged object is counted into
the statistics however.
.sp 1
.ne 5 
.br
.ti 0
\*Bnulltetrad\fP ({name})
.\" .ix nulltetrad\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:nulltetrad\fP>
.br
For the current frame metric this function constructs a null-tetrad connection
for a diagonal tensor metric. It requires that the spin-matrices have already
been computed via 
\*Bspinmat.\fP
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL the object is computed, with the value of
\*BLisp:nulltetrad\fP [\*Bz\fP] as its name. 
.sp 1
.ne 5
.br
.ti 0
\*Bpdf\fP (exp, index)
.\" .ix pdf\ (exp, index)
.br
.ti 0
Returns:\ formal partial derivative of <exp>
.br
\*Bpdf\fP
provides a method of indicating partial derivatives of an expression with
respect to the current coordinates. Unlike a scalar object, <exp> may
contain indexed objects, their index structures will be correctly sorted out.
<index> must be enclosed in square brackets. Until involved in an indexed
assignment operation this function remains unevaluated.
.sp 1
.ne 5
.br
.ti 0
\*Bprotect\fP (name, {protect-flag})
.\" .ix protect\ (name, {protect-flag})
.br
.ti 0
Returns:\ t
.br
This function sets the protection flag on the indexed object
<name>. The protection is checked by other system functions to
determine the legality of deleting or modifying the object. The
allowed values for <protect-flag> are: 
.ti +10
w -- prevent any routine writing to the object,
.ti +10
k -- prevent the object from being deleted,
.ti +10
kw or wk -- combine the above protections,
.ti +10
NIL -- remove existing protection,
.ti +10
other -- no action.
.sp 1
.ne 5 
.br
.ti 0
\*Brat\fP (z/w)
.\" .ix rat\ (z/w)
.br
.ti 0
Returns:\ rationalization of <z/w>
.br
\x`-\n(sp`\*Brat\fP computes $(z~w bar ) / |w sup 2 |$. Unless <w> involves I directly this function will
not result in any change to the argument.
.sp 1
.ne 5 
.br
.ti 0
\*Bre\fP (z)
.\" .ix re\ (z)
.br
.ti 0
Returns:\ real part of <z>
.br
.sp 1
\x`-\n(sp`\*Bre\fP computes $(z~+~z bar ) / 2$.
.sp 1
.ne 5 
.br
.ti 0
\*Brem\fP (name1, {name2, name3, ..})
.\" .ix rem\ (name1, {name2, name3, ..})
.br
.ti 0
.ti 0
or
.br
.ti 0
\*Brem\fP (\*Ball\fP, {flag})
.\" .ix rem\ (all, {flag})
.br
.ti 0
Returns:\ t
.br
\*Brem\fP
attempts to delete from the
system the specified indexed objects. It has two input formats.
.ti +3
In the first format, those arguments which are indexed 
objects and are not delete protected are removed. If any name is not 
that of an indexed object, it is ignored.
.ti +3
In the second format, the atom 
\*Ball\fP indicates that \*Brem\fP will attempt
to delete all indexed objects whose names are in the 
\*Binames\fP list. If
<flag> is non-NIL, this action is done immediately, without user
intervention. If <flag> is NIL, then 
\*Brem\fP considers each object in
turn, with the question "Delete? (Y/N/Q/G)". If the user responds with
a Y, the object is deleted. If a Q is entered, the 
\*Brem\fP aborts. If G is entered, \*Brem\fP will attempt to delete all
remaining objects, without further query. To guard against
accident, the message "Are you sure?" is displayed, it must be
answered with a Y, or the operation is abandoned. If any response
other than Y, Q, G is entered, it is treated as N, and no action is
taken. 
.ti +3
\*Brem\fP
will fail to delete those objects which are delete protected.
.sp 1
.ne 5 
.br
.ti 0
\*Bricci\fP ({name})
.\" .ix ricci\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:ricci\fP>
.br
For the current metric this function computes the Ricci tensor.
If <name> is non-NIL, the tensor is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BLisp:ricci\fP [\*Bric\fP] as its name. The Ricci tensor is symmetric in its
two covariant indices.
.sp 1
.ne 5 
.br
.ti 0
\*Briccisc\fP ({name}, {exp})
.\" .ix riccisc\ ({name}, {exp})
.br
.ti 0
Returns:\ Ricci scalar
.br
For the current metric, this function will compute the Ricci
scalar. If <name> is non-NIL, the scalar is computed and assigned to
that name. If <name> is NIL, a look-up is performed to find the
currently defined scalar, or if none is found the scalar is computed
and assigned to the value of 
\*BLisp:riccisc\fP [\*Bricsc\fP].
.ti +3
If <exp> is non-NIL it replaces the scalar returned by 
\*Briccisc\fP
from storage on the property list of the Ricci tensor;
.sp 1
.ne 5 
.br
.ti 0
\*Briemann\fP ({name})
.\" .ix riemann\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:riemann\fP>
.br
For the current metric this function computes the Riemann tensor.
If <name> is non-NIL, the tensor is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
tensor; if none is found the tensor is computed, with the value of
\*BLisp:riemann\fP
[\*Bri\fP] as its name. This object is fully covariant and
has the full Riemann symmetry.
.sp 1
.ne 5 
.br
.ti 0
\*Bsavec\fP (file,\ name1,\ {name2, ..})
.\" .ix savec\ (file,\ name1,\ {name2, ..})
.br
.ti 0
or
.br
.ti 0
\*Bsavec\fP (file,\ \*Ball\fP, {\ name1, name2, ..})
.\" .ix savec\ (file,\ all, {\ name1, name2, ..})
.br
.ti 0
Returns:\ t
.br
\*Bsavec\fP
provides a facility for saving the components of
selected indexed objects and other non-indexed objects in the disk
file <file>. The components of each object are saved
independently, under the names <name><index>, where <index> is the
compressed index of the element; only explicit elements are saved.
These values cannot be reintroduced in indexed format. As each object
is saved its name is displayed. If the atom 
\*Ball\fP is present, \*Bsavec\fP saves all indexed objects present in the 
\*BLisp:inames\fP list, as well as
any non-indexed objects whose names follow. To reload the values, lisp load
the file (in PSL versions use `lapin', in Franz versions use `load').
.ti +3
In addition to the named objects, those system variables whose names
appear in the  \*BLisp:savelist*\fP
list are also saved. File names found in the list \*BLisp:loadlist\fP
will be read-in when the save file is read in.
If the variable \*BLisp:title\fP
has a string value, that value is used for
the title of the file; it is echoed when the file is reloaded, along with
the date and time the file was saved.
.sp 1
.ne 5 
.br
.ti 0
\*Bsavei\fP (file,\ name1,\ {name2, ..})
.\" .ix savei\ (file,\ name1,\ {name2, ..})
.br
.ti 0
or
.br
.ti 0
\*Bsavei\fP (file,\ \*Ball\fP, {\ name1,\ name2, ..})
.\" .ix savei\ (file,\ all, {\ name1,\ name2, ..})
.br
.ti 0
Returns:\ t
.br
\*Bsavei\fP
provides a facility for saving selected indexed or 
non-indexed objects in the disk file <file>. The objects are saved
in a format that allows them to be reintroduced to the system in
exactly the same form as originally present. As each object is saved
its name is displayed. If the atom \*Ball\fP is present \*Bsavei\fP
saves all
indexed objects present in the inames list, as well as any non-indexed
objects whose names follow. To reload the objects, lisp load the file; as
each object is restored its name is echoed.
.ti +3
In addition to the named objects, those system variables whose names
appear in the \*BLisp:savelist*\fP
list are also saved. File names found
in the list 
\*BLisp:loadlist\fP
will be read-in when the save file is read in. 
If the variable \*BLisp:title\fP
has a string value, that value is used for
the title of the file; it is echoed when the file is reloaded, along with
the date and time the file was saved.
.sp 1
.ne 5 
.br
.ti 0
\*Bsetcon\fP (name, con)
.\" .ix setcon\ (name, con)
.br
.ti 0
Returns:\ <name>
.br
\*Bsetcon\fP
set the current connection of type <con> to be the
object <name> which must be of type  \*Bconnection\fP.  <con> \(eq 1:
tensor-frame, <con> \(eq 2: tensor-spinor, <con> \(eq 3: frame-spinor. The
preferred 
\*Bconcov\fP
lists for these connections are: <con> \(eq 1:
(-2 -1), <con> \(eq 2: (-1 3 4), <con> \(eq 3: (-2 3 4).
.sp 1
.ne 5 
.br
.ti 0
\*Bsetmet\fP (name)
.\" .ix setmet\ (name)
.br
.ti 0
Returns:\ <name>
.br
This function sets the current metric to be the object <name>.
<name> must be of type 
\*Bmetric\fP, and must be the covariant metric. The \*Bconcov\fP
property of <name> determines which
metric <name> becomes. <name> must be covariant in both its indices.
.sp 1
.ne 5 
.br
.ti 0
\*Bshift\fP (name[shifted-index])
.\" .ix shift\ (name[shifted-index])
.br
.ti 0
Returns:\ <offspring name>[<index>]
.br
This function is used to raise and lower indices. The
object is entered as a name and index, where the
index is symbolic. The indices to be shifted are marked by placing an
at sign (@) before each indice as a prefix operator. When the shifted
object is computed it is given a name of the form <name#n1n2..>,
where n1, n2,\ ..  are determined by coverting the \*Bconcov\fP difference list 
to a base-16 number, whose digits are the letters of the alphabet. This
name is placed on the property list of the parent object <name> under
the key \*B*AT*\fP. In order that full advantage be taken of symmetries, the
parent object should be the most symmetric representation of the
geometric object. Any future reference to this shifted object is given
in the same format as the input to this function. 
.sp 1
.ne 5 
.br
.ti 0
\*Bspchristoffel\fP ({name})
.\" .ix spchristoffel\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:spchristoffel\fP>
.br
For the current spinor metric and spin matrices this function computes
spinor Christoffel symbols. 
If <name> is non-NIL, the object is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
object; if none is found the object is computed, with the value of
\*BLisp:spchristoffel\fP [\*Bspc\fP] as its name. 
.sp 1
.ne 5 
.br
.ti 0
\*Bspinmat\fP ({name})
.\" .ix spinmat\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:spinmat\fP>
.br
For the current tensor this function computes the
spin matrices. Currently this function can only compute the spin matrices
if the tensor metric is diagonal. The form of the spin matrices is that of
the generalized Pauli spin matrices.
If <name> is non-NIL, the matrices is computed and given that name. If
<name> is NIL, a look-up is performed to find the currently defined
matrices; if none is found the matrices is computed, with the value of
\*BLisp:gamma\fP [\*Bgam\fP] as its name. 
.sp 1
.ne 5 
.br
.ti 0
\*Bspmetric\fP ({name})
.\" .ix spmetric\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:spmetric\fP>
.br
This function generates the standard set of spinor metrics, with both
dotted and un-dotted indices. These objects are given names from the 
list on 
\*BLisp:spmetric\fP [\*Be3\fP and \*Be4\fP]. Each of these
objects is the others conjugate. The inverse metrics are hidden from
the directory listing.
.sp 1
.ne 5 
.br
.ti 0
\*Btrace\fP (name)
.\" .ix trace\ (name)
.br
.ti 0
Returns:\ trace of <name>
.br
\*Btrace\fP
computes the trace of <name>, which must be a rank-2
object. The REDUCE matrix trace function has been moved to
\*Bmtrace\fP.
.sp 1
.ne 5 
.br
.ti 0
\*Bweyl\fP ({name})
.\" .ix weyl\ ({name})
.br
.ti 0
Returns:\ <name> or <\*BLisp:weyl\fP>
.br
For the current metric this function computes the Weyl conformal
curvature tensor. If <name> is non-NIL, the tensor is computed and
given that name. If <name> is NIL, a look-up is performed to find
the currently defined tensor; if none is found the tensor is computed,
with the value of \*BLisp:weyl\fP [\*Bc\fP] 
as its name. This object has the Riemann
symmetry and has four covariant indices.
