	*** File Names and Functions in P3D Driver Interface ***

These are the files in the 'src' subdirectory of this distribution.  Files
not included in this list are part of Alisp, the lisp interpreter.

assist.c and .h - provides routines to assist renderer interfaces with
functions the renderer itself may not be capable of.

assist_attr.c - provides routines for handling attribute inheritence.

assist_colr.c - provides routines to assist in color handling, including
routines to simulate direct color on an indexed color device.

assist_mtrx.c - simulates a pushdown matrix stack, for transformation
matrix handling on machines without special hardware.

assist_nrml.c - provides routines for adding normal vectors to the nodes
of polygons, triangle strips, and meshes.

assist_spln.c - provides routines to assist renderer interfaces with spline
patch drawing.

assist_text.c - provides routines to assist renderer interfaces with text
drawing.

call_out.c - provides the interface between the call-out facility of
alisp and the P3D driver interface.  This module is very simple;  it just
matches alisp callout function names with P3D service routine names.

control.c and .h - provides the interface to GPlot 'controller' routines 
like tty.c and dq.c to render_ctrl.c.

cylinder.h - coordinates for emulating a cylinder with a mesh

data.button, data.dial, data.explain - data files used by the Dore demo
user interface.

defs.h - include file for structure definitions needed to interface to GPlot
controller routines.

dore_ren.c - the Dore renderer driver.

dore_ui.c - this user interface links the P3D software to the Dore Demo User
Interface package.

dphigs_ren.c - the DEC Phigs/Phigs+ renderer interface.

dq.c - the DiaQuest controller from GPlot.

dump_ren.c - a renderer that dumps P3D structures to stdout.

fui.c - the flying user interface module, for use in flybys of P3D models.

ge_error.c and .h - the 'generic error handler', which is
available within the P3D driver interface routines.

geom_spec.c - auxiliary file needed by the Dore demo user interface.

hershey.h - provides information needed for drawing Hershey font text.
This file is generated by make_hershey.c.

hfonts.h, hfonts.bin - raw Hershey font information digested by make_hershey.c
in the process of making hershey.h

indent.c and .h - a utility for writing indented text, used by dump_ren
and tdump-ren among others.

kui.c - the Keyboard User Interface.

lvr.c, lvr_io.c - the Sony LVR laser video disk controller.

lvr_defines.h - definitions needed for the Sony LVR laser video disk
controller interface.

make_hershey.c - uses hfonts.h and hfonts.bin to produce the Hershey font
file hershey.h.  Definitions in make_hershey.c determine which font(s) will
be included in hershey.h .

material.c - routines for handling material properties.

matrix_ops.c and .h - provides transformation matrix operations to 
render-ctrl.c and to the renderer drivers.

mi.h - mouse interface routine definitions.

motif_mi.c - the Motif point-and-click mouse interface.

mouse_ui.c - the mouse user interface, to which the various mouse interface
(_mi) modules connect.

p3d.c and .h - provides a set of routines and macros for extracting
information from P3D elements like vertices, gobs, and cameras.

p3d.lsp - provides lisp definitions of basic P3D structures

p3d_dflts.lsp - provides definitions for special lisp variables which control
the action of P3D interpreters.  Supercedes those in p3d_global.lsp

p3d_global.lsp - provides default definitions for special lisp variables which
control the action of P3D interpreters.  Is superceded by definitions in
p3d_dflts.lsp

phigs_ren.c - generic Phigs renderer interface.

raydump_ren.c - an obsolete but still vaguely useful renderer that generates
Rayshade 3.0 text model descriptions.

ren.h - the header file for all renderer drivers.

render_ctrl.c and .h - provides the P3D driver interface that call_out.c
interacts with, and controls both the renderer (via calls to the driver)
and the controller (via calls to control.c).

rui.c - the rocket user interface module, for use in flybys of P3D models.

sgigl_mi.c - the Silicon Graphics GL point-and-click mouse interface.

sgigl_ren.c - renderer driver for the Silicon Graphics GL rendering software.

sphere.h - coordinates for emulating a sphere with a mesh

syscall.c and .h - provides a facility to execute shell commands, if their
first word is in a given list.

tdump_ren.c - a renderer that dumps P3D structures to stdout during rendering,
by traversing the geometry DAG.

tty.c - the GPlot 'tty' device controller.

tui.c - the trivial user interface.  Use of this controller causes the P3D
file to be rendered directly from its internal 'snap' function calls.

ui.h - the header file for all user interfaces.

user_parse.c - auxiliary file used by the Dore Demo User Interface

xview_mi.c - The Xview (Open Look) point-and-click mouse interface.
