Generic Phigs Renderer Driver
-----------------------------

File: phigs_ren.c

Renderer: any standard Phigs

Primitives:
	Intrinsic:
		polygon, polyline, polymarker
	Emulated:
		sphere, cylinder, torus, triangle strip, mesh, Bezier patch

Attributes: color, backcull, text-height

Lights: none (all ignored)

Camera handling: complete.

Auxiliary functions:  ren_free, ren_dump, ren_setup, ren_reset, ren_shutdown.

Hooks:  none

Comments:
	This 'renderer' is actually an interface into the standard
	Programmer's Hierarchical Interactive Graphics System.

	The object is defined within Phigs at definition time;
	traversal is carried out there.  Lighting is ignored, as
	it is not a feature of standard Phigs.

	This renderer has been tested on Suns and DEC workstations,
	under Sun and DEC Phigs respectively.  Small mods will be
	needed to bring it up on other platforms;  look for the
	appropriate #ifdefs.  On Suns, the following correspondence
	exists between the value of p3d-device at startup time
	and the Phigs workstation type used:

	p3d-device	workstation type		conection id

     "sun_tool"		phigs_ws_type_sun_tool		ignored
     "sun_canvas"	phigs_ws_type_sun_canvas	phigs_conn_id (global)
     "cgm"		phigs_ws_type_cgm_out		p3d-outfile or
								phigs_ren.cgm

	On DEC platforms, the following correspondence exists between
	the values of p3d-device at startup time and the Phigs workstation
	type used:

	p3d-device	workstation type		conection id

     "dec_defaults"	PHIGS$K_WSTYPE_DEFAULT		PHIGS$K_CONID_DEFAULT
     "dec_decwindows_output" K_DECWINDOWS_OUTPUT	0:0 Ultrix, 0::0 VMS
     "dec_decwindows_drawable" K_DECWINDOWS_DRAWABLE phigs_conn_id (global)
     "dec_pex_output" 	K_PEX_OUTPUT			0:0 Ultrix, 0::0 VMS
     "dec_pex_drawable"	K_PEX_DRAWABLE 		phigs_conn_id (global)

Known bugs:
	None, unless you count the fact that there is no lighting model.

