#ident	"@(#)geom_spec.c	1.1"	9/1/88

/*******************************************************************************
Copyright (C) 1988, an unpublished work of Ardent Computer Corporation
        All Rights Reserved
This program is a trade secret of Ardent Computer Corp. and it is not to be
reproduced, published, disclosed to others, copied, adapted, distributed, or
displayed without the prior authorization of Ardent Computer Corp.  Licensee
agrees to attach or embed this Notice on all copies of the program, including 
partial copies or modified versions thereof.
*******************************************************************************/

#include <dore.h>
#include <stdio.h>
#include "alisp.h"

/******************************************************************************/
/* The following 5 variables must be set in this routine for use in the rest
 *  of the program.  The sole purpose of this routine is to set these 4 
 *  variables. */

#define NMODELS 1      /* maximum number of models that can be created;
			* usually the same as the following 'nmodels' */
int nmodels = NMODELS; /* the number of models actually created & available 
			* for display */
int firstcycle = 0;    /* model number of the first model to be displayed
			* during an 'autocycle' (0-->nmodels-1) */
int lastcycle = 1;     /* model number of the last model to be displayed
			* during an 'autocycle' (0-->nmodels-1) */
DtObject models[NMODELS]; /* array containing the Dore' group 'handle' for 
			* each of the models created */
/******************************************************************************/

extern DtInt debug;

/*******************************************************************************
 ***************************  g e o m _ s p e c  *******************************
 *******************************************************************************
 * Module Name: geom_spec
 * Module Type: c
 *     Purpose: This routine is application specific.  In it, the user 
 *              should read any necessary data files and specify the 
 *              geometry of any models to be displayed.  Each distinct
 *              model should be placed in a separate group which will
 *              later be referenced as 'models[i]'.  Each model may be
 *		made up of any number of objects.
 *   Arguments: minmax ==> an array of 6 elements containing the minimum 
 *		   x, y, & z (minmax->bll[0],[1],[2]) and the maximum x, y,
 *		   & z (minmax->fur[0],[1],[2]) values found in the
 *		   models.  If the values are not modified in this routine,
 *		   they will be computed by Dore' in make_models.c.
 *		argc ==> number of command line arguments passed to this program
 *		argv ==> array of command line argument strings
 * ReturnValue: None
 ******************************************************************************/
geom_spec(minmax, argc, argv)
DtVolume *minmax;
int argc;
char *argv[];
{
/*******************************************************************************
 * Declare variables & functions.
 ******************************************************************************/
	if (debug) printf("In geom_spec...\n");

/*******************************************************************************
 * The following 19 lines are a sample of the kind of thing that might be
 *  added here to create a model.  In this case, two models containing a single
 *  spheroid each, are being created.  You could, for example, read in a data
 *  file generated as output from an analysis program at this point and     
 *  generate a model(s) from that data. 
 ******************************************************************************/

      	if (alisp(argc,argv))
		DsHoldObj(models[0]);
	else
		printf("ALISP ERROR OCCURED \n");


/*******************************************************************************
 ******************************************************************************/

}  /* End of geom_spec function */
