/****************************************************************************
 *                                                                          *
 *	paintr_strct.h                                                      *
 *      Copyright 1989, Pittsburgh Supercomputing Center                    *
 *                      All Rights Reserved                                 *
 *			Author Chris Nuuja                                  *
 *                                                                          *
 ****************************************************************************/
typedef struct ren_color 
	{
	float r;
	float g;
	float b;
	float a;
	} ren_colortype;

typedef struct ren_vector
	{
	float x;
	float y;
	float z;
	} ren_vectortype;

typedef struct ren_point
	{
	float x;
	float y;
	float z;
	} ren_pointtype;

typedef enum { POLYGON=0, POLYLINE, POLYMARKER } primtype;

typedef struct ren_polyrecord
	{
	int x_index;	/* offset into the coordinate memory buffer  */
	int y_index;	/* where these coordinates begin */
	int z_index;
	int numcoords;  /* number of coordinates in this record */   
	int color;	/* offset to color memory buffer  */
	primtype type;  /* is it a POLYGON, POLYLINE,or POLYMARKER */
	} ren_polytype;

typedef struct ren_object
	{
	int poly_index;
	int num_polygons;
	} ren_objecttype;

typedef struct table_rec 
	{
	int poly;
	float key;
	} depthtable_rec;

