/* 
 *   This is include file for the knobs and dials control
 *   panel system.
 */

#ifndef __KNOBS__

/*
 *   General appearence information
 */

#define MOUSEBUTTON  LEFTMOUSE
#define MITRE        4
#define HEADERV      20
#define CORNERRAD    10
#define TEXTMARGIN   10
#define TEXTVFUDGE   3
#define TEXTHFUDGE   2
#define DROPOFF      10
#define FLASHES      3
#define FLASHDELAY   3

/*
 *   General state variables.
 */

extern int mouse_x, mouse_y;         /* Location of the mouse */
extern int mouse_state;              /* Button up or down */
extern int mouse_transition;         /* Is this a change? */
extern int KnobDB, KnobLUT;          /* Display modes */
extern int KnobLUTBase;              /* Base of lookuptable */
extern short KnobRed[5], KnobGreen[5], KnobBlue[5];   /* The colors */

/*
 *   Control types.
 */

#define PANEL   1
#define MENU    2
#define BUTTON  3
#define TOGGLE  4
#define SLIDER  5
#define MOUSE   6
#define TEXT    7
#define ICON    8
#define INFO    9
#define OPTION  10
#define DIALOG  11

#define MAXCHANNELS 5              /* Maximum number of data channels */

typedef struct itemtype
   {
      char name[128];               /* Name of the item */
      int value;                    /* Return value */
      int flag;                     /* Do we draw a check or anything */
      struct itemtype *sub_item;    /* Child menu */
      struct itemtype *next_item;   /* Next item in the menu */
   } ItemType;

typedef struct controltype
   {
      int type, style;              /* Type and style of control */
      char name[128];               /* Name of the control */
      int x,y;                      /* Position relative to panel header */
      int x_size, y_size;           /* Size of the button */
      int auto_flush;               /* Call service on any change */
      struct controltype *next_control, *sub_control;

/* General data section */

      int count, current, pos, flag;
      char *new_string, *old_string;
      double max, min, new, old,
             scale, incr, base;
      int notick;
   }  ControlType;

typedef struct icontype
   {
      int type, style;              /* Type and style of control */
      char name[128];               /* Name of the control */
      int x,y;                      /* Position relative to panel header */
      int x_size, y_size;           /* Size of the button */
      int current;
      int x_res,y_res;              /* Resolution of icon */
      unsigned char icon[512];      /* Data storage for image bits */
   }   IconType;


typedef struct knobtype
   {
      int type;                     /* So what is this thing */
      char name[128];               /* It has a name */
      int x,y;                      /* It has a location */
      int width;                    /* It even has a size */
      int title_bar;                /* Make a title bar for it */
      int is_open;                  /* We're up */
      int can_move;                 /* We can move */
      int can_close;                /* We can go away */
      int mouse_location;           /* Use the mouse location as the origin */
      long *savearea;               /* Where we save the background */
      int x1, x2, y1, y2;           /* Bounds of save area */
      char *first_thing;            /* Things in the menu */
      struct knobtype *next_panel;  /* Thread in list of panels */
   } KnobType;

#endif
