/****************************************************************************
 * tui.c
 * Author Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/*
This module provides a 'trivial user interface' which just fires up the
rest of the system and lets it run.
*/

#include <stdio.h>
#include "alisp.h"
#include "p3d.h"
#include "ge_error.h"
#include "ui.h"
#include "control.h"
#include "ren.h"
#include "assist.h"

/* Variable to hold initialization state */
static int initialized= 0;

main(argc, argv)
int argc;
char *argv[];
{
	alisp(argc, argv);
}

void ui_setup( renderer, device, outfile, hints, controller, startframe, 
	      framecopies )
char *renderer, *device, *controller, *outfile;
int startframe, framecopies;
Attribute_list hints;
/* This routine initializes everything. */
{
  ger_debug(
	    "ui_setup: initializing renderer %s, device %s and controller %s",
	    renderer, device, controller);
  
  /* Initialize the controller and renderer */
  if (!initialized) {
    ctrl_setup( controller, startframe, framecopies );
    ren_setup( renderer, device, 1, outfile, hints );
    initialized= 1;
  }
  else {
    ger_error(
	   "ui_setup: called twice, this call interpreted as a hard reset.");
    ui_reset( 1, startframe, framecopies );
  }
}

void ui_reset( hard, startframe, framecopies )
int hard, startframe, framecopies;
/* This routine resets everything */
{
        ger_debug("ui_reset: resetting renderer and controller; hard= %d",
		  hard);

	/* hard resets require recreation of lisp-side variables, but
	 * for this ui there aren't any.
	 */
	if (hard) {
	  initialized= 1;
	}

	ast_text_reset( hard );
	ast_prim_reset( hard );
	ast_spln_reset( hard );
	ctrl_reset( hard, startframe, framecopies );
	ren_reset( hard );
}

void ui_shutdown()
/* This routine shuts everything down */
{
      ger_debug("ui_shutdown: shutting everything down.\n");

      ren_shutdown();
      ctrl_end();
}

void ui_camera(lookat, lookfrom, lookup, fov, hither, yon, background)
Point lookat, lookfrom;
Vector lookup;
float fov, hither, yon;
Color background;
/* This routine handles camera setting */
{
	ren_camera( lookat, lookfrom, lookup, fov, hither, yon, background );
}

void ui_render(thisgob, thistrans, thisattrlist)
Gob thisgob;
Transformation thistrans;
Attribute_list thisattrlist;
/* This routine handles actual rendering of the gob. */
{
	ren_render( thisgob, thistrans, thisattrlist );
	ctrl_doframe();
}

void ui_traverselights(thisgob, thistrans, thisattrlist)
Gob thisgob;
Transformation thistrans;
Attribute_list thisattrlist;
/* This routine handles actual rendering of the gob. */
{
	ren_traverselights( thisgob, thistrans, thisattrlist );
}

void ui_free(thisgob)
Gob thisgob;
/* This routine causes the renderer to free storage associated with the gob. */
{
	ren_free(thisgob);
}

