/*
 * image.h
 * Revision 4.0  91/07/17  14:33:39  kolb
 * Initial version.
 */
#ifndef IMAGE_H
#define IMAGE_H
 
/*
 * Generic image object for texture map storage.
 */
typedef struct Image {
	int	width, height,		/* Image size */
		chan, has_alpha,	/* # of channels, has alpha info? */
		totalchan,		/* # channels + any alpha channel */
		chansize;		/* width * height */
	unsigned char *data;		/* Image */
	char	*filename;		/* Filename (identifier) */
	struct Image *next;		/* Next image in list. */
} Image;
 
Image	*ImageCreate(), *ImageFind(), *ImageRead();
void	ImageIndex();
 
#endif /* IMAGE_H */
