/*
 * $Log:	options.h,v $
 * Revision 4.0  91/07/17  14:46:54  kolb
 */
#ifndef OPTIONS_H
#define OPTIONS_H
 
/*
 * Constants for Stereo mode
 */
#define LEFT		1
#define RIGHT		2
 
/*
 * Options
 */
typedef struct RSOptions {
	int	stereo;			/* Stereo mode? */
	int	verbose;		/* Babbling mode? */
	int	quiet;			/* Don't complain? */
	int	jitter;			/* use jittered sampling? */
	int	samples;		/* Sqrt of # of samples */
	int	maxdepth;		/* Maximum ray tree depth */
	int	report_freq;		/* Frequency; in lines; of report */
	int	no_shadows;		/* Trace shadow rays? */
	int	shadowtransp;		/* ... through transparent objects? */
	int	cache;			/* Cache shadowing info? */
	int	appending;		/* Append to image file? */
	int	resolution_set;		/* resolution set on command line */
	int	contrast_set;		/* contrast overridden ... */
	int	samples_set;		/* samples overridden ... */
	int	cutoff_set;		/* cutoff ... */
	int	maxdepth_set;		/* adaptive depth ... */
	int	window_set;		/* window ... */
	int	freq_set;		/* report frequency ... */
	int	jitter_set;		/* use jittering */
	int	eyesep_set;		/* eye separation ... */
	int	csg;			/* CSG object someplace in world */
	int	flipnorm;		/* flip normals of polygonal objs */
	int	samplemap;		/* output sample map? */
	int	gaussian;		/* Use gaussian pixel filter? */
	int	framenum;		/* current frame number */
	int	startframe;		/* Starting frame number. */
	int	endframe;		/* ending frame number */
	int	totalframes;		/* total # of frames */
	int	totalframes_set;	/* set on command line? */
#ifdef URT
	int	alpha;			/* Write alpha channel? */
	int	exp_output;		/* Write exponential RLE file? */
#endif
	Float	eyesep;			/* Eye separation (for Stereo mode) */
	Float	gamma;			/* Gamma value (0 == no correction) */
	Float	xmin; 			 /* Window range */
	Float   xmax; 
	Float   ymin; 
	Float   ymax;
	Float	starttime;		/* Think about it ... */
	Float	shutterspeed;		/* time shutter is open */
	Float	framestart;		/* start time of the current frame */
	Float	framelength;		/* length of the current frame */
	Float	filterwidth;		/* Pixel filter width. */
	Color	contrast;		/* Max. allowable contrast */
	Color	cutoff;			/* Ray tree depth control */
	Color	ambient;		/* Ambient light multiplier */
	char	*progname;		/* argv[0] */
	char	*statsname;		/* Name of stats file. */
	char	*imgname;		/* Name of output image file */
	char	*inputname;		/* Name of input file, NULL == stdin */
	char	*cppargs;		/* arguments to pass to cpp */

#ifdef LINDA
	int	workers;		/* # of worker processes */
	int	workernum;		/* worker #, 0 == supervisor */
	int	verbose_worker;		/* Babble while you work? */
#endif

#ifdef  RPC     
	int     is_rpc_client;              /* is a RPC CLIENT */
	int     is_rpc_server;              /* is a RPC CLIENT */
	int 	squaresize;
	int 	display;
	char	*serverfilename;
	char    *serverexestring;
	
#endif

	FILE	*pictfile;		/* output file pointer */
} RSOptions;
 
extern RSOptions Options;
extern void OptionsList(), OptionsSet();

#endif /* OPTIONS_H */
