#ifndef H_SCCSID
#endif /* ~H_SCCSID */

/*
 * Rpc additions to <sys/types.h>
 */
#ifndef __TYPES_RPC_HEADER__
#define __TYPES_RPC_HEADER__

#define	bool_t	int

#if defined(u370)
#define enum_t  char
#else
#define	enum_t	int
#endif

#if !defined(TRUE) || !defined(FALSE)
#define  FALSE	(0)
#define  TRUE	(1)
#endif /* !(TRUE && FALSE) */

#define __dontcare__	-1
#ifndef NULL
#define NULL 0
#endif

#ifndef KERNEL
extern char *malloc();
#define mem_alloc(bsize)	malloc(bsize)
#define mem_free(ptr, bsize)	free(ptr)
#ifndef major /* This is a kind of trick, but... */
#include <sys/types.h>
#endif /* !major */
#else
#ifndef MA_ALIGN
#include <vmalloc.h>
#endif /* MA_ALIGN */
#define kmem_alloc(x)	kmemalloc((u_int)(x), MA_DBLWD|MA_SHORTTERM|MA_OK2SLEEP)
#define kmem_free(x, y)	mfree((caddr_t)(x))
#define mem_alloc(x)	kmemalloc((u_int)(x), MA_DBLWD|MA_SHORTTERM|MA_OK2SLEEP)
#define mem_free(x, y)	mfree((caddr_t)(x))
#ifndef major
#include <types.h>
#endif /* !major */
#endif

#endif /* !__TYPES_RPC_HEADER__ */
