/*
 * symtab.h
 * Revision 4.0  91/07/17  14:48:12  kolb
 * Initial version.
 */
 
#ifndef SYMTAB_H
#define SYMTAB_H
 
typedef Float (*FloatFuncPtr)();
 
struct SymtabPredefinedEntry {
	char * name;
	Float f;
	FloatFuncPtr fp;
	int type;
	int timevary;
	int params;
};
 
typedef	union {
	Float (*fp)();
	Expr *expr;
} SymtabValue;
 
typedef struct SymtabEntry {
	char 	*name;
	SymtabValue value;
	int type;
	int timevary;
	int params;
	struct SymtabEntry *next;
} SymtabEntry;
 
extern Expr *ExprFloatSymtabFind();
extern SymtabEntry *SymtabFind(), *SymtabBuiltinFind();
 
#endif /* SYMTAB_H */
