//<copyright>
//
// Copyright (c) 1993
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


#ifndef hyperg_hgraster_h
#define hyperg_hgraster_h


//<file>
//
//
// Name :       hgraster.h
//
// Purpose :    Interface to class HgRaster
//
// Created :    12 Apr 94    Peter Pichler
// Modified :   10 Nov 94    Bernhard Marschall
//
//
// Description:
//
//</file>


//<class>
//
// Name:           HgRaster
//
// Purpose:        reads GIF, TIFF, JPG, XBM files
//
//
// Public Interface:
//
//   load(const char* filename,
//        Raster*& raster,
//        Bitmap*& bitmap,
//        RasterAction* progress
//        boolean dither);
//   tries to open the specified file, tries to identify the file format
//   and loads it into the raster or bitmap respectively; a RasterAction
//   can be provided to display the progress of decoding or to abort it;
//   additionally dithering can be switched on or off.
//
//
// Description:
//
//</class>


#include <InterViews/enter-scope.h>

class Bitmap;
class Raster;
class RasterAction;


class HgRaster {
public:
  static int load(                   // loads a raster image
    const char* filename,              // filename of file to load
    Raster*& raster,                   // returns Raster (for color images)
    Bitmap*& bitmap,                   // returns Bitmap (for 1 bit/pixel images)
    RasterAction* progress = nil,      // callback for progress and abort
    boolean dither = true              // switch on/off dithering
  );
};

#endif
