// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:        httpreader.h
//
// Purpose:     get an URL via HTTP protocol
//
// Created:     30 Nov 1995   Michael Pichler
//
// Changed:     30 Nov 1995   Michael Pichler
//
// $Id: httpreader.h,v 1.1 1995/12/20 15:54:17 mpichler Exp $
//
//</file>



#ifndef harmony_scene_httpreader_h
#define harmony_scene_httpreader_h


// HTTPReader
// get an URL via HTTP protocol
// opens a socket connection (linked into the dispatcher instance),
// initiates an GET request,
// after construction ok should be checked, to see, whether the class is working

// output is written to a temporary file

class HTTPReader
{
  public:
    HTTPReader (                        // constructor
      const char* url,                  //   URL to be fetched
      const char* parenturl = "",       //   parent URL (for relative requests)
      const char* appname = 0           //   application name (User-Agent)
    );
    virtual ~HTTPReader ();

    enum {
      err_none,                         // no error
      err_nothttp,                      // other protocol than HTTP
      err_noconnect                     // no connection
    };

    int error () const                  // has an error occured?
    { return error_; }                  //   returns 0 or an error code

//  void stop ();  // TODO: cancel transaction

  // TODO: virtual functions for status, header info, progress, ...
  // OR: pointer to callback class

  private:

    // callback functions (called when finished)
    virtual void success (const char* filename) = 0;
    // should process the data contained in file filename, delete the tempfile,
    // and destroy this class

    virtual void failure () = 0;
    // should destroy this class

    int error_;

}; // HTTPReader


#endif
