/* blob.h,v 1.1.1.1 1995/02/27 07:38:30 explorer Exp */

/*
 * Copyright (C) 1990, 1991, Mark Polipec, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef BLOB_H
#define BLOB_H

#define GeomBlobCreate(s,t,m,n) GeomCreate((GeomRef)BlobCreate(s,t,m,n), BlobMethods())  /* s == surface; t == treshold; m == metalist; n == nr of points. */

#define R_START 1
#define R_END   0

#define GOOD 1
/*
 * Blob
 */
typedef struct {
  Float red, green, blue;
} MColor;                /* metaball's individual color spec struct. */

typedef struct {
  Float rs;	/* radius */
  Float c4;	/* coeefficient */
  Float c2;	/* coeefficient */
  Float c0;	/* coeefficient */
  Float x;	/* x position */
  Float y;	/* y position */
  Float z;	/* z position */
  Surface *surf;   /* metaball's individual surface */
  /*MColor mcolor;*/  /* Color of the metaball, if provided. */
} MetaVector;   /* Details of the metaball */

typedef struct {
  int type,pnt;
  Float bound;
  Float c[5];
} MetaInt;

typedef struct {
  Surface *surf;        /* Pointer to surface of the blob */
  int instance;         /* instance count of the blob; an index value */
  Float T;		/* Threshold   */
  int num;		/* number of points */
  int MColor_Flag;      /* TRUE ==> blob has multiple colors active */
  MetaVector *list;	/* list of points */
  MetaInt *ilist, **iarr;
} Blob;

typedef struct MetaList {
  MetaVector mvec;
  struct MetaList *next;
} MetaList;

/* Declarations of external references for Blob ops. */
/*      External function ref.s */
extern GeomRef  BlobCreate _PROTO((Surface *, Float, MetaList *, int));
extern Methods	*BlobMethods METHODS_PROTO;
extern int	BlobIntersect INTERSECT_PROTO;
extern int      BlobNormal NORMAL_PROTO;
extern void	BlobBounds BOUNDS_PROTO;
extern void     BlobStats STATS_PROTO;
extern char	*BlobName NAME_PROTO;
extern void     BlobMethodRegister _PROTO((UserMethodType));

/*      External or Global storage. */
extern Surface init_surf;    /* initial surface parameters: input file */

#endif /* BLOB_H */
