/* flame.h,v 1.2 1995/03/30 07:14:04 explorer Exp */

/*
 *  Projektarbeit '94
 *
 *  written by Reto Mani
 *
 */


#ifndef FLAME_H
#define FLAME_H

#define GeomFlameCreate(s,p,l,v)   GeomCreate((GeomRef)FlameCreate(s,p,l,v), \
						FlameMethods())

/* Flame definition */
typedef struct {
  Float          size;        /* size of flame */
  Float          x,y,z;   	 /* position of flame */
  Surface        *surface;    /* pointer to surface of object */
  Float          speed;
} Flame;


extern GeomRef  FlameCreate _PROTO((Float, Vector *, int, Float));
extern GeomRef  FlameObjCreate _PROTO((Float, Vector *, Float, Surface *));
extern Methods  *FlameMethods METHODS_PROTO;
extern int      FlameIntersect INTERSECT_PROTO;
extern int      FlameEnter ENTER_PROTO;
extern int      FlameNormal NORMAL_PROTO;
extern void     FlameBounds BOUNDS_PROTO;
extern void     FlameUV UV_PROTO;
extern void     FlameStats STATS_PROTO;
extern char     *FlameName NAME_PROTO;
extern void     FlameMethodRegister _PROTO((UserMethodType));

#endif /* FLAME_H */






