/* instance.h,v 1.1.1.1 1995/02/27 07:38:34 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef INSTANCE_H
#define INSTANCE_H

#define GeomInstanceCreate(o)  GeomCreate((GeomRef)InstanceCreate(o), \
					InstanceMethods())

/*
 * Instance object
 */
typedef struct {
  struct Geom *obj;	/* Geom being instantiated */
  Float bounds[2][3];	/* Bounding box of object */
} Instance;

extern GeomRef  InstanceCreate _PROTO((Geom *));
extern char	*InstanceName NAME_PROTO;
extern int	InstanceIntersect INTERSECT_PROTO;
extern Methods	*InstanceMethods METHODS_PROTO;
extern void	InstanceBounds BOUNDS_PROTO;
extern void     InstanceMethodRegister _PROTO((UserMethodType));

#endif /* INSTANCE_H */
