/* stripe.h,v 1.1.1.1 1995/02/27 07:38:42 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef STRIPE_H
#define STRIPE_H

#define TextStripeCreate(s,w,b,m) TextCreate((TextRef)StripeCreate(s,w,b,m), \
					StripeApply)
typedef struct {
  Surface  *surf;
  Mapping  *mapping;
  Float	   width;
  Float    bump;
} Stripe;

extern Stripe *StripeCreate _PROTO((Surface *, Float, Float, Mapping *));
extern void StripeApply _PROTO((Stripe *, Geom *, Ray *, Vector *, Vector *,
				Vector *, Surface *));

#endif /* STRIPE_H */
