/*
 * constants.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: constants.h,v 3.0 89/10/27 02:05:48 craig Exp $
 *
 * $Log:	constants.h,v $
 * Revision 3.0  89/10/27  02:05:48  craig
 * Baseline for first official release.
 * 
 */

#define LIGHTS		10		/* Max # of lights */

/*
 * Primitive type constants.  When adding primitives, insert *before*
 * "LIST" and increment LIST and GRID values, otherwise arrays of
 * intersection/normal/extent routines in intersect.c won't be indexed
 * correctly.
 */
#define SPHERE		0
#define BOX		1
#define TRIANGLE	2
#define SUPERQ		3
#define PLANE		4
#define CYL		5
#define POLY		6
#define PHONGTRI	7
#define CONE		8
#define HF		9
#define LIST		10
#define GRID		11

#define PRIMTYPES	10	/* # of types of primitives */

#define TRUE		1
#define FALSE		0

/*
 * Used to make indices into bounding box arrays more readable.
 */
#define X	0
#define Y	1
#define Z	2
#define LOW	0
#define HIGH	1

/*
 * Light source types
 */
#define LOCAL		(char)1
#define DIRECTIONAL	(char)2
#define EXTENDED	(char)3

/*
 * Various useful constants and macros.
 */
#define	PI		3.14159265358979323846
#define deg2rad(x)	(double)(PI * x / 180.)
#define LNHALF		(-.69314718)
/*
 * Minimum vector length
 */
#define EPSILON		(double)0.00001

/*
 * Maximum intersection-point distance.  (Making the "world" a sphere of radius
 * FAR_AWAY centered at eyep.)
 */
#define FAR_AWAY		1.0E+14

/*
 * Constants used in triangle & polygon intersection tests.
 */
#define XNORMAL		(char)0
#define YNORMAL		(char)1
#define ZNORMAL		(char)2

/*
 * Constants for Stereo mode
 */
#define LEFT		1
#define RIGHT		2

#ifndef NULL
#	define NULL 0
#endif

#define UNSET		-1
