#ifndef PROGSPEC_H
#define PROGSPEC_H


#include "config.h"
#include "rayshade.h"
#include "symtab.h"
#include "builtin.h"
#include "options.h"
#include "atmosphe.h"
#include "surface.h"
#include "texture.h"
#include "image.h"
#include "geom.h"
#include "light.h"
#include "viewing.h"
#include "blob.h"
#include "box.h"
#include "cone.h"
#include "csg.h"
#include "cylinder.h"
#include "disc.h"
#include "grid.h"
#include "hf.h"
#include "instance.h"
#include "list.h"
#include "plane.h"
#include "poly.h"
#include "sphere.h"
#include "torus.h"
#include "triangle.h"
#include "light.h"
#include "point.h"
#include "spot.h"
#include "extended.h"
#include "jittered.h"
#include "infinite.h"
#include "blotch.h"
#include "bump.h"
#include "checker.h"
#include "cloud.h"
#include "fbm.h"
#include "fbmbump.h"
#include "gloss.h"
#include "imagetex.h"
#include "marble.h"
#include "mount.h"
#include "sky.h"
#include "stripe.h"
#include "windy.h"
#include "wood.h"
#include "fog.h"
#include "fogdeck.h"
#include "mist.h"
#include "mapping.h"
#include "scale.h"
#include "rotate.h"
#include "translat.h"
#include "picture.h"
#include <librr/rrpc.h>

typedef struct rpc_SymtabEntry {
        char *name;
        SymtabValue value;
        int type;
        int timevary;
        int params;
        struct rpc_SymtabEntry *next;
}rpc_SymtabEntry;


enum ExprType {NULLEXPR,SUMEXPR,DIFFEXPR,MULTEXPR,DIVIDEEXPR,MODEXPR,NEGATEEXPR,
               LINEARTIMEEXPR,COSEXPR,SINEXPR,TANEXPR,SQRTEXPR,ACOSEXPR,ASINEXPR,
	       ATANEXPR,HYPOTEXPR,EXPRTYPEEND};

typedef struct rpc_Expr {
       short   type,                   /* Expr type (float/builtin/time) */
                timevary,               /* does the expr vary over time? */
                symtab,                 /* is the expr in the symtab? */
                nparams;                /* # of params, if builtin */
        Float   value,                  /* float val/last eval if timeexpr */
                timenow,                /* time of last evaluation */
                (*function)();
        struct rpc_Expr **params;           /* parameters, if a builtin */
} rpc_Expr;
 typedef rpc_Expr *rpc_Expr_Ptr;
 typedef struct exprtab {
       enum ExprType type;
       Float (*function)();
  }ExprTab;

enum TransType {NULLTRANS,SCALETRANS,TRANSLATETRANS,ROTATETRANS,TRANSTYPEEND};
typedef struct rpc_Trans {
        TransRef tr;                    /* transform data */
        TransMethods *methods;          /* transform methods */
        ExprAssoc *assoc;               /* animated parameters */
        short   animated;               /* is the transformation animated? */
        RSMatrix trans,         /* object space --> world space */
                 itrans;        /* worldspace --> object space */
        struct rpc_Trans *next, *prev;
} rpc_Trans;

typedef struct transtab {
       enum TransType type;
       TransMethods * (*methods)();
       bool_t (*xdrproc)();
       u_long size;
  }TransTab;

typedef struct {
        Float T;                /* Threshold   */
        int num;                /* number of points */
        MetaVector *list;       /* list of points */
        MetaInt *ilist, **iarr;

} rpc_Blob;
typedef struct rpc_hfTri {
        Vector v1, v2, v3, norm;
        Float d;
        char type;
        struct rpc_hfTri *next, *prev;
} rpc_hfTri;
typedef struct {
        float **data;           /* Altitude points */
        float minz, maxz;
        int size, *lsize;       /* # of points/side */
        int BestSize;           /* "best" division size */
        float iBestSize;        /* inverse of above (for faster computation) */
        int levels;             /* log base BestSize of size */
        float ***boundsmax;     /* high data values at various resolutions. */
        float ***boundsmin;
        float *spacing;
        hfTri hittri, **q;      /* hit triangle and triangle cache */
        int qtail, qsize;       /* end and length of cache */
        Float boundbox[2][3];   /* bounding box of Hf */
} rpc_Hf;
typedef struct Surface* rpc_uSurface_Ptr ;
enum GeomType
 {BLOB,BOX,CONE,CSG,CYLINDER,DISC,GRID,HF,INSTANCE,LIST,PLANE,POLYGON,
  SPHERE,TORUS,TRIANGLE,GEOMTYPEEND};

typedef struct geomtab {
       enum GeomType type;
       Methods * (*getmethods)();
       bool_t (*xdrproc)();
       u_long size;
}GeomTab;
typedef struct rpc_Geom {
        char *name;                     /* Geom name, if any. */
        GeomRef obj;                    /* Pointer to object info. */
        Methods *methods;
        unsigned long prims;            /* sum of # primitive objects */
        Float bounds[2][3];             /* Bounding box */
        Float timenow;                  /* Geom's idea of what time it is */
        short int animtrans;            /* transformation is animated */
        short int frame;                /* frame for which obj is inited */
        struct Surface *surf;           /* surface, if any */
        struct Trans *trans;            /* Transformation information */
        struct Trans *transtail;        /* Double linked list end */
        struct Texture *texture;        /* Texture mapping info. */
#ifdef SHAREDMEM
        unsigned long *counter;         /* Geoms are shared, counters aren't */
#else
        unsigned long counter;          /* "mailbox" for grid intersection */
#endif
        struct rpc_Geom *next;              /* Next object. */
} rpc_Geom;


typedef struct {
        short   xsize, ysize, zsize;    /* # of voxels along each axis */
        Float   bounds[2][3];           /* bounding box */
        Float   voxsize[3];             /* size of a voxel */
        struct  Geom    *unbounded,     /* unbounded objects */
                        *objects;       /* all bounded objects */
        struct  GeomList        ****cells;      /* Voxels */
} rpc_Grid;

struct rpc_Csg {
        char operator;
        struct rpc_Geom *obj1;
        struct rpc_Geom *obj2;
	int (*intmeth)();
        double bounds[6];
};
typedef struct rpc_Csg rpc_Csg;
bool_t xdr_rpc_Csg();
extern int CsgUnionInt(), CsgDifferenceInt(), CsgIntersectInt();


struct rpc_Polygon {
        Vector norm;
        double d;
        char index;
        Vector *points;
        int npoints;
};
typedef struct rpc_Polygon rpc_Polygon;
bool_t xdr_rpc_Polygon();


enum LightType
 {POINTLIGHT,SPOTLIGHT,EXTENDEDLIGHT,JITTEREDLIGHT,INFINITELIGHT,LIGHTTYPEEND};
typedef struct lighttab {
       enum LightType type;
       LightMethods * (*getmethods)();
       bool_t (*xdrproc)();
       u_long size;
  } LightTab;

typedef struct rpc_Light {
        Color color;            /* Light source color & intensity */
        int shadow;             /* Does light source cast shadows? */
        LightRef light;         /* Pointer to light information */
        LightMethods *methods;  /* Light source methods */
        ShadowCache *cache;     /* Shadow cache, if any */
        struct rpc_Light *next;     /* Next light in list */
} rpc_Light;

enum TextureType
{BLOTCHTEXT,BUMPTEXT,CHECKERTEXT,CLOUDTEXT,FBMTEXT,FBMBUMPTEXT,
 GLOSSTEXT,IMAGETEXT,MARBLETEXT,MOUNTTEXT,SKYTEXT,STRIPETEXT,
 WINDYTEXT,WOODTEXT,TEXTURETYPEEND};

typedef struct rpc_Texture {
        TextRef data;                   /* Texturing info */
        void    (*method)();            /* method */
        Trans   *trans;                 /* transformation info */
        short   animtrans;              /* is the transformation animated? */
        struct Texture *next;           /* next in list */
} rpc_Texture;
typedef struct texturetab {
       enum TextureType type;
       void (*method)();
       bool_t (*xdrproc)();
       u_long size;
} TextureTab;
typedef struct rpc_Image {
        int     width, height,          /* Image size */
                chan, has_alpha,        /* # of channels, has alpha info? */
                totalchan,              /* # channels + any alpha channel */
                chansize;               /* width * height */
        unsigned char *data;            /* Image */
        char    *filename;              /* Filename (identifier) */
        struct rpc_Image *next;             /* Next image in list. */
} rpc_Image;

enum MappingType
{ UVMAP, SPHEREMAP,CYLMAP, LINEARMAP, MAPTYPEEND};

typedef struct rpc_Mapping {
        int flags;              /* mapping flags */
        Vector center, uaxis, vaxis, norm;
        Float dist;
        RSMatrix m;
        void (*method)();
} rpc_Mapping;
typedef struct mappingtab{
        enum MappingType type;
        void (*method)();
        bool_t (*xdrproc)();
        u_long size;
}MappingTab;

enum EffectType
{FOGEFFECT,FOGDECKEFFECT,MISTEFFECT,EFFECTTYPEEND};
typedef struct rpc_Atmosphere {
        AtmosRef data;                  /* Effect info */
        void    (*method)();            /* Atmosphere method */
        struct Atmosphere *next;        /* Next effect */
} rpc_Atmosphere;

typedef struct EffectTab {
       enum EffectType type;
       void (*method)();
       bool_t (*xdr_proc)();
       u_long size;
} EffectTab;

bool_t xdr_rpc_Geom();
bool_t xdr_rpc_Grid();
bool_t xdr_rpc_Light();
bool_t xdr_rpc_Texture();
bool_t xdr_rpc_Image();
bool_t xdr_rpc_Mapping();
bool_t xdr_rpc_Trans();
bool_t xdr_rpc_hfTri();
bool_t xdr_rpc_Expr();
bool_t xdr_rpc_Expr_Ptr();
bool_t xdr_rpc_SymtabEntry();
bool_t xdr_rpc_uSurface_Ptr();
bool_t xdr_rpc_Atmosphere();
bool_t xdr_RayshadeArg();
extern void remote_rayshade();
extern void raywriteline();
extern void rraypause();
extern void rraynewframe();
extern Geom *World,*Objects;
extern Light *Lights;
extern Surface *Surfaces;
extern Atmosphere *AtmosEffects;                /* atmospheric effects */
extern Medium TopMedium;
extern SymtabEntry *Symtab;
extern Image *image_list;
extern Float RTable[267];
typedef struct  rrarg{
                       u_long   RRID;
                       RSScreen *screen;
                       RSCamera *camera;
                       RSOptions *options;
                       SymtabEntry *symtab;
                       Light *lights;
                       Image *image_list;
                       Geom *objects;
                       Geom *world;
                       Surface *surfaces;
                       Atmosphere *atmoseffects;
                       Expr *timeexpr;
                       Expr *frameexpr;
		       Float *rtable;	
               } RayshadeArg;




#endif  /** PROGSPEC_H **/
