/*======================================================================
                    U T I L I T I E S . H 
                    doc: Fri Sep  6 13:43:37 1991
                    dlm: Wed Nov 20 13:20:35 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 95 23 FALSE 0 0 72 2 2 ofnI
======================================================================*/

#include	<math.h>

/* Note: The matrices are stored column-wise. M[col][row] */

#define	vecVec(v1,v2)			/* Dot Product */ \
	(v1[VX]*v2[VX]+v1[VY]*v2[VY]+v1[VZ]*v2[VZ]+v1[VW]*v2[VW])

#define	vecVec2(v,m,col)		/* Dot Product 2nd form*/ \
	(v[VX]*m[VX][col]+v[VY]*m[VY][col]+v[VZ]*m[VZ][col]+v[VW]*m[VW][col])
	
#define	vec3Vec3(v1,v2)			/* Dot Product 3D */ \
	(v1[VX]*v2[VX]+v1[VY]*v2[VY]+v1[VZ]*v2[VZ])

/*	MMM
	MMM  =	
   xxx	MMM	zzz	*/
#define vecMat2vec(vin,mat,vout) 	/* Vec * Mat -> Vec */ \
	vout[VX] = vecVec(mat[0],vin); \
	vout[VY] = vecVec(mat[1],vin); \
	vout[VZ] = vecVec(mat[2],vin); \
	vout[VW] = vecVec(mat[3],vin) \


#define matMat2mat(m1,m2,mout) 		/* Mat * Mat -> Mat */ \
	mout[0][0]= vecVec2(m2[0],m1,0); \
	mout[0][1]= vecVec2(m2[0],m1,1); \
	mout[0][2]= vecVec2(m2[0],m1,2); \
	mout[0][3]= vecVec2(m2[0],m1,3); \
	\
	mout[1][0]= vecVec2(m2[1],m1,0); \
	mout[1][1]= vecVec2(m2[1],m1,1); \
	mout[1][2]= vecVec2(m2[1],m1,2); \
	mout[1][3]= vecVec2(m2[1],m1,3); \
	\
	mout[2][0]= vecVec2(m2[2],m1,0); \
	mout[2][1]= vecVec2(m2[2],m1,1); \
	mout[2][2]= vecVec2(m2[2],m1,2); \
	mout[2][3]= vecVec2(m2[2],m1,3); \
	\
	mout[3][0]= vecVec2(m2[3],m1,0); \
	mout[3][1]= vecVec2(m2[3],m1,1); \
	mout[3][2]= vecVec2(m2[3],m1,2); \
	mout[3][3]= vecVec2(m2[3],m1,3) \


#define zero2(vec,i1,i2) 		/* Zero 2 components */ \
	vec[i1] = vec[i2] = 0.0

#define zero3(vec,i1,i2,i3)		/* Zero 3 components */ \
	vec[i1] = vec[i2] = vec[i3] = 0.0

#define sqr(x) ((x)*(x))		/* x ** 2 */

#define setPnt(pnt,x,y,z)		/* set 3D Point */ \
	pnt[VX] = (Fp)(x); \
	pnt[VY] = (Fp)(y); \
	pnt[VZ] = (Fp)(z); \
	pnt[VW] = (Fp)1.0 \

#define setPnt3(pnt,x,y,z)		/* set 3D Point */ \
	pnt[VX] = (Fp)(x); \
	pnt[VY] = (Fp)(y); \
	pnt[VZ] = (Fp)(z) \

#define setPpnt3(pnt,x,y,z)		/* set 3D Point */ \
	pnt[VX] = (plural Fp)(x); \
	pnt[VY] = (plural Fp)(y); \
	pnt[VZ] = (plural Fp)(z) \

#define make3D(pnt4)			/* Normalize coordinates */ \
	pnt4[VX] /= pnt4[VW]; \
	pnt4[VY] /= pnt4[VW]; \
	pnt4[VZ] /= pnt4[VW]; \
	pnt4[VW] = 1.0 \

#define nrmVec3(vec,len)		/* Normalize vector */ \
	len = sqrt(sqr(vec[VX])+sqr(vec[VY])+sqr(vec[VZ])); \
	vec[VX] /= len; \
	vec[VY] /= len; \
	vec[VZ] /= len \

#ifdef _MPL
#define pNrmVec3(vec,len)		/* Normalize vector */ \
	len = p_sqrt(sqr(vec[VX])+sqr(vec[VY])+sqr(vec[VZ])); \
	vec[VX] /= len; \
	vec[VY] /= len; \
	vec[VZ] /= len 
#endif

#define	defDvec3(vec,pa,pb,grid)	/* define Delta-Vector */ \
	vec[VX] = (pb[VX] - pa[VX]) / grid; \
	vec[VY] = (pb[VY] - pa[VY]) / grid; \
	vec[VZ] = (pb[VZ] - pa[VZ]) / grid \

#define	defVec3(vec,start,endx,endy,endz)	/* define vector */ \
	vec[VX] = endx - start[VX]; \
	vec[VY] = endy - start[VY]; \
	vec[VZ] = endz - start[VZ] \

#define vec3SubVec3(v1,v2,vres)		/* subtract vectors */ \
	vres[VX] = v1[VX] - v2[VX]; \
	vres[VY] = v1[VY] - v2[VY]; \
	vres[VZ] = v1[VZ] - v2[VZ] \

#define incVec3(vec,incv)		/* add to vector */ \
	vec[VX] += incv[VX]; \
	vec[VY] += incv[VY]; \
	vec[VZ] += incv[VZ] \

#define incVec3Vec3(vec,incv,incw)	/* add to weighted vector */ \
	vec[VX] += incv[VX] * incw[VX]; \
	vec[VY] += incv[VY] * incw[VY]; \
	vec[VZ] += incv[VZ] * incw[VZ] \

#define incWVec3Vec3(vec,weight,incv,incw) /* add weighted to weighted vector */ \
	vec[VX] += weight * incv[VX] * incw[VX]; \
	vec[VY] += weight * incv[VY] * incw[VY]; \
	vec[VZ] += weight * incv[VZ] * incw[VZ] \

#define vec3Neg(vec)			/* negate vector */ \
	vec[VX] = -vec[VX]; \
	vec[VY] = -vec[VY]; \
	vec[VZ] = -vec[VZ] \

#define vec3CrossVec3(v1,v2,vres)	/* Cross product */ \
	vres[VX] = v1[VY]*v2[VZ]-v1[VZ]*v2[VY]; \
	vres[VY] = v1[VZ]*v2[VX]-v1[VX]*v2[VZ]; \
	vres[VZ] = v1[VX]*v2[VY]-v1[VY]*v2[VX] \

#define sLen2D(vec,c1,c2)		/* sqr length of projection */ \
	(sqr(vec[c1])+sqr(vec[c2]))

#define dist3D(p1,p2)			/* distance betw. pnts */ \
	sqrt(sqr(p1[VX]-p2[VX])+sqr(p1[VY]-p2[VY])+sqr(p1[VZ]-p2[VZ]))

#define scaleVec3(vec,scl)		/* scale vector */ \
	vec[VX] *= (scl); \
	vec[VY] *= (scl); \
	vec[VZ] *= (scl) \

#define wVec3(vec,scl,vres)		/* scale vector 2nd form */ \
	vres[VX] = (scl) * vec[VX]; \
	vres[VY] = (scl) * vec[VY]; \
	vres[VZ] = (scl) * vec[VZ] \

#define copyVec3(v1,v2)			/* copy vector */ \
	v2[VX] = v1[VX]; \
	v2[VY] = v1[VY]; \
	v2[VZ] = v1[VZ] \

#define copy3Vec3(src,trg)		/* copy 3 vectors */ \
	copyVec3(src[PA],trg[PA]); \
	copyVec3(src[PB],trg[PB]); \
	copyVec3(src[PC],trg[PC]) \

#define clampCol(col)			/* clamp color */ \
	if (col[CR] > 1.0) col[CR] = 1.0; \
	if (col[CG] > 1.0) col[CG] = 1.0; \
	if (col[CB] > 1.0) col[CB] = 1.0 \

#define Swap(v1,v2,vtemp) {		/* swap 2 vars */ \
	vtemp = v1; \
	v1 = v2; \
	v2 = vtemp; } \

#define	PI	3.1415926		/* Pi */
