/*
    Filter Manager - Management software for the Drawbridge package
    Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford
    
    Please see the file `COPYING' for the complete copyright notice.

    util.c - Version 1.0 - 4/21/93
*/

#include "fm.h"

void longSwap(unsigned long *buf,unsigned long length)
{
    struct in_addr *l;
    unsigned char c;
    int i;

    /*
     *  We use an in_addr structure to perform the swap since it already has
     *    a byte union that makes the swap simple.
     */
    for (i = 0;i < length;++i) {
	l = (struct in_addr *) (buf + i);

	c = l->S_un.S_un_b.s_b1;
	l->S_un.S_un_b.s_b1 = l->S_un.S_un_b.s_b4;
	l->S_un.S_un_b.s_b4 = c;

	c = l->S_un.S_un_b.s_b3;
	l->S_un.S_un_b.s_b3 = l->S_un.S_un_b.s_b2;
	l->S_un.S_un_b.s_b2 = c;
    }
}

void shortSwap(unsigned short *buf,unsigned long length)
{
    struct bytes {
	unsigned char byte1;
	unsigned char byte2;
    } *shortTemp;
    int i;
    unsigned char c;

    for (i = 0;i < length;++i) {
	shortTemp = (struct bytes *) (buf + i);
	
	c = shortTemp->byte1;
	shortTemp->byte1 = shortTemp->byte2;
	shortTemp->byte2 = c;
    }
}

/*
 * Prints a textual version of the error code that was returned by the filter.
 */
void printError(unsigned char code,FILE *theOutput)
{
    switch (code) {
        case FM_ERROR_INSECURE:
	    fprintf(theOutput,"filter is in insecure mode\n");
	    break;
        case FM_ERROR_SECURE:
	    fprintf(theOutput,"filter is in secure mode\n");
	    break;
        case FM_ERROR_DESFILE:
	    fprintf(theOutput,"filter could not open DES key file\n");
	    break;
        case FM_ERROR_DESWRITE:
	    fprintf(theOutput,"filter could not write key to DES file\n");
	    break;
        case FM_ERROR_NONETWORK:
  	    fprintf(theOutput,"filter does not have the specified network loaded\n");
	    break;
        case FM_ERROR_NOMEMORY:
  	    fprintf(theOutput,"filter does not have enough free memory for the operation\n");
	    break;
        case FM_ERROR_COMMAND:
  	    fprintf(theOutput,"filter did not understand the request (protocol error)\n");
	    break;
        case FM_ERROR_DATAFILE:
  	    fprintf(theOutput,"filter could not open a file for writing\n");
	    break;
        case FM_ERROR_DATAWRITE:
  	    fprintf(theOutput,"filter could not write to a file (disk is probably full)\n");
	    break;
        case FM_ERROR_INVALIDNETWORK:
  	    fprintf(theOutput,"filter cannot handle the specified network\n");
	    break;
        case FM_ERROR_LOADBUFFER:
  	    fprintf(theOutput,"a buffer error occurred in the filter during the load\n");
	    break;
        case FM_ERROR_NODES:
  	    fprintf(theOutput,"the filter does not have DES support installed\n");
	    break;
        default:
	    fprintf(theOutput,"unknown error code %d from target\n",code);
	    break;
    }
}

