/*
 * Copyright (c) 1993,1994
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#define NDIS_MAC_STATUS_HARDWARE_MASK		0x0007
#define NDIS_MAC_STATUS_HARDWARE_NOT_INSTALLED	0
#define NDIS_MAC_STATUS_HARDWARE_FAILED_DIAG	1
#define NDIS_MAC_STATUS_HARDWARE_FAILED_CONFIG	2
#define NDIS_MAC_STATUS_HARDWARE_HARD_FAULT	3
#define NDIS_MAC_STATUS_HARDWARE_SOFT_FAULT	4
#define NDIS_MAC_STATUS_HARDWARE_OK		7
#define NDIS_MAC_STATUS_MAC_BOUND		0x0008
#define NDIS_MAC_STATUS_MAC_OPEN		0x0010
#define NDIS_MAC_STATUS_DIAG_IN_PROGRESS	0x0020

#define NDIS_PACKET_FILTER_DIRECTED		0x0001
#define NDIS_PACKET_FILTER_BROADCAST		0x0002
#define NDIS_PACKET_FILTER_PROMISCUOUS		0x0004
#define NDIS_PACKET_FILTER_SOURCE_ROUTE		0x0008

#define NDIS_GENERAL_REQUEST_INITIATE_DIAGNOSTICS	1
#define NDIS_GENERAL_REQUEST_READ_ERROR_LOG		2
#define NDIS_GENERAL_REQUEST_SET_STATION_ADDRESS	3
#define NDIS_GENERAL_REQUEST_OPEN_ADAPTER		4
#define NDIS_GENERAL_REQUEST_CLOSE_ADAPTER		5
#define NDIS_GENERAL_REQUEST_RESET_MAC			6
#define NDIS_GENERAL_REQUEST_SET_PACKET_FILTER		7
#define NDIS_GENERAL_REQUEST_ADD_MULTICAST_ADDRESS	8
#define NDIS_GENERAL_REQUEST_DELETE_MULTICAST_ADDRESS	9
#define NDIS_GENERAL_REQUEST_UPDATE_STATISTICS		10
#define NDIS_GENERAL_REQUEST_CLEAR_STATISTICS		11
#define NDIS_GENERAL_REQUEST_INTERRUPT_REQUEST		12
#define NDIS_GENERAL_REQUEST_SET_FUNCTIONAL_ADDRESS	13
#define NDIS_GENERAL_REQUEST_SET_LOOKAHEAD		14

#define NDIS_STATUS_RING_STATUS		1
#define NDIS_STATUS_ADAPTER_CHECK	2
#define NDIS_STATUS_START_RESET		3
#define NDIS_STATUS_INTERRUPT		4
#define NDIS_STATUS_END_RESET		5

#define NDIS_MAC_SERVICE_FLAGS_BROADCAST		0x00000001L
#define NDIS_MAC_SERVICE_FLAGS_MULTICAST		0x00000002L
#define NDIS_MAC_SERVICE_FLAGS_FUNCTIONAL		0x00000004L
#define NDIS_MAC_SERVICE_FLAGS_PROMISCUOUS		0x00000008L
#define NDIS_MAC_SERVICE_FLAGS_SOFT_ADDRESS		0x00000010L
#define NDIS_MAC_SERVICE_FLAGS_STATS_CURRENT		0x00000020L
#define NDIS_MAC_SERVICE_FLAGS_INITIATE_DIAGS		0x00000040L
#define NDIS_MAC_SERVICE_FLAGS_LOOPBACK			0x00000080L
#define NDIS_MAC_SERVICE_FLAGS_RECEIVE_CHAIN		0x00000100L
#define NDIS_MAC_SERVICE_FLAGS_SOURCE_ROUTING		0x00000200L
#define NDIS_MAC_SERVICE_FLAGS_RESET_MAC		0x00000400L
#define NDIS_MAC_SERVICE_FLAGS_OPEN_CLOSE		0x00000800L
#define NDIS_MAC_SERVICE_FLAGS_INTERRUPT_REQUEST	0x00001000L
#define NDIS_MAC_SERVICE_FLAGS_SOURCE_ROUTING_BRIDGE	0x00002000L
#define NDIS_MAC_SERVICE_FLAGS_VIRTUAL_ADDRESSES	0x00004000L
#define NDIS_MAC_SERVICE_FLAGS_MULTIPLE_TDS		0x00008000L
#define NDIS_MAC_SERVICE_FLAGS_FRAMESIZE_ZERO		0x00010000L

#define NDIS_SYS_REQ_INITIATE_BIND			1
#define NDIS_SYS_REQ_BIND				2
#define NDIS_SYS_REQ_INITIATE_PREBIND			3
#define NDIS_SYS_REQ_INITIATE_UNBIND			4
#define NDIS_SYS_REQ_UNBIND				5

#define NDIS_PROT_MAN_GET_PROTOCOL_MANAGER_INFO		1
#define NDIS_PROT_MAN_REGISTER_MODULE			2
#define NDIS_PROT_MAN_BIND_AND_START			3
#define NDIS_PROT_MAN_GET_PROTOCOL_MANAGER_LINKAGE	4
#define NDIS_PROT_MAN_GET_PROTOCOL_INI_PATH		5
#define NDIS_PROT_MAN_REGISTER_PROTOCOL_MANAGER_INFO	6
#define NDIS_PROT_MAN_INIT_AND_REGISTER			7
#define NDIS_PROT_MAN_UNBIND_AND_STOP			8
#define NDIS_PROT_MAN_BIND_STATUS			9
#define NDIS_PROT_MAN_REGISTER_STATUS			10

#define NDIS_PARAM_INTEGER		0
#define NDIS_PARAM_STRING		1

#define NDIS_TX_BUF_LENGTH		8
#define NDIS_TD_BUF_LENGTH		1
#define NDIS_RX_BUF_LENGTH		8

#define NDIS_PTR_PHYSICAL		0
#define NDIS_PTR_VIRTUAL		2

#define NDIS_ERROR_SUCCESS			0x0000
#define NDIS_ERROR_WAIT_FOR_RELEASE		0x0001
#define NDIS_ERROR_REQUEST_QUEUED		0x0002
#define NDIS_ERROR_FRAME_NOT_RECOGNIZED		0x0003
#define NDIS_ERROR_FRAME_REJECTED		0x0004
#define NDIS_ERROR_FORWARD_FRAME		0x0005
#define NDIS_ERROR_OUT_OF_RESOURCE		0x0006
#define NDIS_ERROR_INVALID_PARAMETER		0x0007
#define NDIS_ERROR_INVALID_FUNCTION		0x0008
#define NDIS_ERROR_NOT_SUPPORTED		0x0009
#define NDIS_ERROR_HARDWARE_ERROR		0x000A
#define NDIS_ERROR_TRANSMIT_ERROR		0x000B
#define NDIS_ERROR_NO_SUCH_DESTINATION		0x000C
#define NDIS_ERROR_BUFFER_TOO_SMALL		0x000D
#define NDIS_ERROR_ALREADY_STARTED		0x0020
#define NDIS_ERROR_INCOMPLETE_BINDING		0x0021
#define NDIS_ERROR_DRIVER_NOT_INITIALIZED	0x0022
#define NDIS_ERROR_HARDWARE_NOT_FOUND		0x0023
#define NDIS_ERROR_HARDWARE_FAILURE		0x0024
#define NDIS_ERROR_CONFIGURATION_FAILURE	0x0025
#define NDIS_ERROR_INTERRUPT_CONFLICT		0x0026
#define NDIS_ERROR_INCOMPATIBLE_MAC		0x0027
#define NDIS_ERROR_INITIALIZATION_FAILED	0x0028
#define NDIS_ERROR_NO_BINDING			0x0029
#define NDIS_ERROR_NETWORK_MAY_NOT_BE_CONNECTED	0x002A
#define NDIS_ERROR_INCOMPATIBLE_OS_VERSION	0x002B
#define NDIS_ERROR_ALREADY_REGISTERED		0x002C
#define NDIS_ERROR_PATH_NOT_FOUND		0x002D
#define NDIS_ERROR_INSUFFICIENT_MEMORY		0x002E
#define NDIS_ERROR_INFO_NOT_FOUND		0x002F
#define NDIS_ERROR_GENERAL_FAILURE		0x00FF

#define NDIS_PATH "PROTMAN$"

// Protocol Manager API.
typedef unsigned short __pascal (*ProtocolManager) (struct _ReqBlock *,unsigned short);

// System request.
typedef unsigned short __pascal (*SystemRequest) (unsigned long,unsigned long,unsigned short,
						unsigned short,unsigned short);

// MAC API.
typedef unsigned short __pascal (*Request) (unsigned short,unsigned short,unsigned short,
						unsigned long,unsigned short,unsigned short);
typedef unsigned short __pascal (*TransmitChain) (unsigned short,unsigned short,struct _TxBufDescr *,unsigned short);
typedef unsigned short __pascal (*TransferData) (unsigned short *,unsigned short,
						struct _TDBufDescr *,unsigned short);
typedef unsigned short __pascal (*ReceiveRelease) (unsigned short,unsigned short);
typedef unsigned short __pascal (*IndicationOn) (unsigned short);
typedef unsigned short __pascal (*IndicationOff) (unsigned short);

typedef struct _CommonCharacteristics {
	unsigned short tableSize;
	unsigned char majorNdisVersion; // 2 - Latest version.
	unsigned char minorNdisVersion; // 0
	unsigned short reserved1;
	unsigned char majorModuleVersion;
	unsigned char minorModuleVersion;
	unsigned long moduleFlags;
		// 0 - Binding at upper boundary supported.
		// 1 - Binding at lower boundary supported.
		// 2 - Dynamically bound.
		// 3-31 - Reserved, must be zero.
	unsigned char moduleName[16];
	unsigned char protocolLevelUpper;
		// 1 - MAC
		// 2 - Data Link
		// 3 - Network
		// 4 - Transport
		// 5 - Session
		// -1 - Not specified
	unsigned char interfaceUpper;
	unsigned char protocolLevelLower;
		// 0 - Physical
		// 1 - MAC
		// 2 - Data Link
		// 3 - Network
		// 4 - Transport
		// 5 - Session
		// -1 - Not specified
	unsigned char interfaceLower;
	unsigned short moduleId;
	unsigned short moduleDS;
        SystemRequest systemRequest;
        unsigned char *serviceCharacteristics;
        unsigned char *serviceStatus;
        unsigned char *upperDispatchTable;
        unsigned char *lowerDispatchTable;
        unsigned char *reserved2; // Must be NULL.
        unsigned char *reserved3; // Must be NULL.
} CommonCharacteristics;

typedef struct _MulticastList {
	unsigned short maxMulticastAddresses;
	unsigned short numberMulticastAddresses;
	unsigned char multicastAddress[][16];
} MulticastList;

typedef struct _MacCharacteristics {
	unsigned short tableSize;
	unsigned char macName[16];
	unsigned short addressLength;
	unsigned char permanentAddress[16];
	unsigned char currentAddress[16];
	unsigned long currentFunctionalAddress;
	MulticastList *multicastList;
	unsigned long linkSpeed;
	unsigned long serviceFlags;
	unsigned short maxFrameSize;
	unsigned long txBufferSize;
	unsigned short txBufferAllocSize;
	unsigned long rxBufferSize;
	unsigned short rxBufferAllocSize;
	unsigned char ieeeVendor[3];
	unsigned char vendorAdapter;
	unsigned char *vendorAdapterDescription;
	unsigned short interruptLevel;
	unsigned short txQueueDepth;
	unsigned short maxDataBlocks;
} MacCharacteristics;

typedef struct _ProtocolCharacteristics {
	unsigned short length;
	unsigned char name[16];
	unsigned short type;
} ProtocolCharacteristics;

typedef struct _MacUpperDispatch {
	CommonCharacteristics *backPointer;
        Request request;
        TransmitChain transmitChain;
        TransferData transferData;
        ReceiveRelease receiveRelease;
        IndicationOn indicationOn;
        IndicationOff indicationOff;
} MacUpperDispatch;

typedef struct _MacStatusTable {
	unsigned short tableSize;
	unsigned long lastDiag;
	unsigned long macStatus;
	unsigned short packetFilter;
	unsigned char *mediaSpecificStats;
	unsigned long lastClear;
	unsigned long totalFramesRx;
	unsigned long totalFramesCrc;
	unsigned long totalBytesRx;
	unsigned long totalFramesDiscardedBufferSpaceRx;
	unsigned long totalMulticastRx;
	unsigned long totalBroadcastRx;
	unsigned long obsolete1[5];
	unsigned long totalFramesDiscardedHardwareErrorRx;
	unsigned long totalFramesTx;
	unsigned long totalBytesTx;
	unsigned long totalMulticastTx;
	unsigned long totalBroadcastTx;
	unsigned long obsolete2[2];
	unsigned long totalFramesDiscardedTimeoutTx;
	unsigned long totalFramesDiscardedHardwareErrorTx;
} MacStatusTable;

typedef struct _ProtocolLowerDispatch {
	CommonCharacteristics *backPointer;
	unsigned long flags;
		// 0 - handles non-LLC frames
		// 1 - handles specific-LSAP LLC frames
		// 2 - handles specific-LSAP LLC frames
		// 3-31 - reserved must be 0
        void (*requestConfirm)(void);
        void (*transmitConfirm)(void);
        void (*receiveLookahead)(void);
        void (*indicationComplete)(void);
        void (*receiveChain)(void);
        void (*status)(void);
} ProtocolLowerDispatch;

typedef struct _ReqBlock {
	unsigned short opcode;
	unsigned short status;
	unsigned char *pointer1;
	unsigned char *pointer2;
	unsigned short word1;
} ReqBlock;

typedef struct _TxBufDescrRec {
	unsigned char txPtrType;
	unsigned char dummy;
	unsigned short txDataLen;
	unsigned char *txDataPtr;
} TxBufDescrRec;

typedef struct _TxBufDescr {
	unsigned short txImmedLen;
	unsigned char *txImmedPtr;
	unsigned short txDataCount;
	TxBufDescrRec txBufDescrRec[NDIS_TX_BUF_LENGTH];
} TxBufDescr;

typedef struct _TDBufDescrRec {
	unsigned char tDPtrType;
	unsigned char dummy;
	unsigned short tDDataLen;
	unsigned char *tDDataPtr;
} TDBufDescrRec;

typedef struct _TDBufDescr {
	unsigned short tDDataCount;
	TDBufDescrRec tDBufDescrRec[NDIS_TD_BUF_LENGTH];
} TDBufDescr;

typedef struct _RxBufDescrRec {
	unsigned short rxDataLen;
	unsigned char *rxDataPtr;
} RxBufDescrRec;

typedef struct _RxBufDescr {
	unsigned short rxDataCount;
	RxBufDescrRec rxBufDescrRec[NDIS_RX_BUF_LENGTH];
} RxBufDescr;

typedef struct _Param {
	unsigned int paramType;
	unsigned int paramLen;
	union {
		unsigned long numeric;
		unsigned char string[];
	} value;
} Param;

typedef struct _KeyWord {
	struct _KeyWord *nextKeyword;
	struct _KeyWord *prevKeyword;
	unsigned char keyWord[16];
	unsigned int numParams;
	Param param;
} KeyWord;

typedef struct _ModuleConfig {
	struct _ModuleConfig *nextModule;
	struct _ModuleConfig *prevModule;
	unsigned char moduleName[16];
	KeyWord keyWord;
} ModuleConfig;

typedef struct _BindingsList {
	unsigned short numBindings;
	unsigned char moduleName[2][16];
} BindingsList;

typedef struct _FailingModules {
	unsigned char upperModuleName[16];
	unsigned char lowerModuleName[16];
} FailingModules;
