/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
typedef struct _Key {
	unsigned long i1;
	unsigned long i2;
	unsigned long i3;
} Key;

/*
 * Structure for an address table entry.
 */
typedef struct _AddrTableEntry {
	struct in_addr network;
	char networkFilename[256];
	unsigned char *hostTable;
} AddrTableEntry;

typedef struct _AccessListTableEntry {
	unsigned short begin;
	unsigned short end;
} AccessListTableEntry;

typedef struct _RejectTableEntry {
	struct in_addr network;
	unsigned long mask;
} RejectTableEntry;

typedef struct _AllowTableEntry {
	struct in_addr network;
	unsigned long mask;
	AccessListTableEntry access[MAX_NUM_ACCESS_RANGES];
} AllowTableEntry;

/*
 * Structure representing a filt protocol header.
 */
typedef struct _FiltHeader {
	unsigned char   type;
	unsigned char   flags;
	unsigned short  chkSum;
	unsigned short  randomInject;
} FiltHeader;

typedef struct _SimplePacket {
	FiltHeader header;
} WritePacket, RebootPacket;

typedef struct _SyncPacket {
	unsigned short spinCount;
	Key key;
} SyncPacket;

typedef struct _QueryPacket {
	unsigned char type;
	unsigned char dummy[3];
	union {
		unsigned char index;
		unsigned long addr;
	} queryValue;
	union {
		struct in_addr networks[MAX_NUM_NETWORKS];
		unsigned char index;
		RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
		AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
		struct {
			AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
		} accessList;
	} queryResult;
} QueryPacket;

typedef struct _LoadPacket {
	unsigned char type;
	unsigned char flags;
	union {
		unsigned char index;
		struct {
			struct in_addr network;
			unsigned long offset;
		} networkBlock;
	} loadValue;
	union {
		RejectTableEntry reject[MAX_NUM_REJECT_ENTRIES];
		AllowTableEntry allow[MAX_NUM_ALLOW_ENTRIES];
		struct {
			AccessListTableEntry in[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry out[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry src[MAX_NUM_ACCESS_RANGES];
			AccessListTableEntry udp[MAX_NUM_ACCESS_RANGES];
		} accessList;
		unsigned char networkBlock[1024];
	} loadData;
} LoadPacket;

typedef struct _ReleasePacket {
	unsigned char type;
	struct in_addr network;
} ReleasePacket;

typedef struct _ErrorPacket {
	unsigned char errorCode;
} ErrorPacket;

typedef struct _StatisticsPacket {
	unsigned char type;
	unsigned long statistics[MAX_NUM_STATISTICS];
} StatisticsPacket;
