/* subst.c
   perform editing substitutions on commands that Xgopher will execute */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>
#include "conf.h"
#include "gopher.h"

#include "osdep.h"

#define	PERCENT		'%'

#define N_EDIT		7

char		keys[N_EDIT] = "hpnsfP";
static char	*editString();

/* editCommand
   edit item information into a command used for processing a gopher item.
   The return value is dynamic, so caller should free it. */

char	*
editCommand(gi, command, fileName, suffix)
gopherItemP	gi;
char		*command;
char		*fileName;
char		*suffix;
{
	char	*editedCommand;
	char	*values[N_EDIT];
	char	portStr[8], altPortStr[8];

	if (gi != (gopherItemP) NULL) {
		sprintf(portStr, "%6d", gi->port);
		if (gi->port == 0  || gi->port == 23) {
			strcpy(altPortStr, " ");
		} else {
			strcpy(altPortStr, portStr);
		}

		values[0] = gi->host;
		values[1] = portStr;
		values[2] = USER_STRING(gi);
		values[3] = vStringValue(&(gi->selector));
		values[4] = (fileName == (char *) NULL) ? "" : fileName;
		values[5] = altPortStr;
	} else {
		values[0] = "";
		values[1] = "";
		values[2] = "";
		values[3] = "";
		values[4] = (fileName == (char *) NULL) ? "" : fileName;
		values[5] = "";
	}

#ifdef DEBUG
	fprintf (stderr, "Edit the command: \'%s\'\n", command);
#endif	/* DEBUG */

	editedCommand =
		editString(command, keys, values, N_EDIT, suffix);

#ifdef DEBUG
	fprintf (stderr, "Edited command: \'%s\'\n", editedCommand);
#endif	/* DEBUG */

	return editedCommand;
}


/* editString
   edit printf-like strings to replace escape sequences by new values.
   The return value is dynamic, so caller should free it. */

static char	*
editString(in, key, value, n, suffix)
char	*in;
char	key[];
char	*value[];
char	*suffix;
int	n;
{
	char	*cmd = malloc(sizeof(char) * PATH_NAME_LEN);
	char	*out, *c, *f;
	char	**v;
	BOOLEAN	edited = FALSE;

	out = cmd;

	while(*in != NULLC) {
		if (*in != PERCENT) {
			*(out++) = *(in++);
		} else {
			if (++in == NULLC) {
				*(out++) = PERCENT;
				break;
			}

			for (c=key, v=value; (*c != NULLC && *c != *in);
								c++, v++) ;

			if (*c != NULLC) {
				f = *v;
				while (*f != NULLC) {
					*(out++) = *(f++);
				}
				edited = TRUE;
			} else {
				*(out++) = PERCENT;
				if (*in != PERCENT) {
					*(out++) = *(in++);
				}
			}
			++in;
		}
	}

	if (! edited  &&  suffix != (char *) NULL) {
		*(out++) = ' ';
		f = suffix;
		while (*f != NULLC) {
			*(out++) = *(f++);
		}
	}

	*(out++) = '\0';
	
	return cmd;;
}
