/* Copyright (c) 1996 NEC Corporation.  All rights reserved.                 */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#include "socks5p.h"
#include "buffer.h"
#include "addr.h"
#include "protocol.h"
#include "confutil.h"
#include "wrap.h"
#include "conf.h"
#include "share.h"

#define EXITERROR(err)	( perror("ping"), exit((err)) )

static void SocksPing(S5NetAddr *dst, S5NetAddr *proxy) {
    if (InitProxy(proxy, dst, SOCKS_PING, 0) < 0) EXITERROR(-1);
    
    DataRelay();
    exit(0);
}

int main(int argc, char *argv[]) {
    S5NetAddr rsin, dest, *psin;
    struct hostent *rhp;
    int nproxies;

    if (argc != 2 || *argv[1] == '-') {
	fprintf(stderr, "Usage: %s host\n", argv[0]);
	exit(-1);
    }

    if (LIBPREFIX2(init)(NULL) != 0) EXITERROR(-1);
    if ((rhp = LIBPREFIX(gethostbyname)(argv[1])) == NULL) EXITERROR(-1);

    memset((char *)&rsin, 0, sizeof(S5NetAddr));
    memcpy((char *)&rsin.sin.sin_addr.s_addr, (char *)rhp->h_addr_list[0], rhp->h_length);
    rsin.sin.sin_family = rhp->h_addrtype;
    rsin.sin.sin_port   = htons(0);

    switch (lsHowToConnect(&rsin, SOCK_STREAM, &psin, &nproxies, lsEffUser(), &dest)) {
    case DIRECT:
#ifndef PINGPROG
	fprintf(stderr, "Real ping unavailable.\n");
	exit(0);
#else
	execlp(PINGPROG, "ping", argv[1], NULL);
	_exit(0);
#endif
    case SOCKS5_VERSION:
	SocksPing(&dest, psin);
    default:
	EXITERROR(-1);
    }

    return 0;
}
