#if defined(FOR_SHARED_LIBRARY) && defined(HIDEORIG)

#ifndef HIDE_H
#define HIDE_H

/* Try to hide these functions so we don't get compiler pukage.              */
#define HIDE(x)       _hidden_ ## x
#define gethostbyname HIDE(gethostbyname)
#define getpeername   HIDE(getpeername)
#define getsockname   HIDE(getsockname)
#define accept        HIDE(accept)
#define connect       HIDE(connect)
#define select        HIDE(select)
#define bind          HIDE(bind)
#define recvfrom      HIDE(recvfrom)
#define sendto        HIDE(sendto)
#define recv          HIDE(recv)
#define send          HIDE(send)
#define read          HIDE(read)
#define write         HIDE(write)
#ifdef HAVE_RRESVPORT
#define rresvport     HIDE(rresvport)
#endif
#define shutdown      HIDE(shutdown)
#define listen        HIDE(listen)
#define close         HIDE(close)
#define flcose        HIDE(fclose)

#else

#undef HIDE_H

/* Unhide these functions so we can deal with them now that includes are     */
/* done...Hopefully...                                                       */
#undef gethostbyname 
#undef getpeername   
#undef getsockname   
#undef accept        
#undef connect       
#undef select       
#undef bind          
#undef recvfrom      
#undef sendto        
#undef recv          
#undef send          
#undef read          
#undef write         
#ifdef HAVE_RRESVPORT
#undef rresvport     
#endif
#undef shutdown      
#undef listen        
#undef close         
#undef flcose        

#endif
#endif
