/*
 * dstore.c - BSDI global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.3 97/05/30 16:29:18 abe Exp $";
#endif


#include "lsof.h"


struct file *Cfp;		/* current file's file struct pointer */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

#if	BSDIV<20100
	{ X_NCACHE,	"_nchhead"	},
	{ X_NCSIZE,	"_numcache"	},
#else	/* BSDIV>=20100 */
	{ X_NCACHE,	"_nchashtbl"	},
	{ X_NCSIZE,	"_nchash"	},
#endif	/* BSDIV<20100 */

	{ "",		""		},
	{ NULL,		NULL		}
};

kvm_t *Kd;			/* kvm descriptor */
KA_T Kpa;			/* kernel proc struct address */

struct l_vfs *Lvfs = NULL;	/* local vfs structure table */

int Np = 0;			/* number of kernel processes */
struct kinfo_proc *P = NULL;	/* local process table copy */
int pgshift = 0;		/* kernel's page shift */
