.\" 
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.de HE
.RE
.sp
\fB\&\\$1 \|\\$2 \|\\$3 \|\\$4 \|\\$5 \|\\$6\fP
.RS +.5i
.br
..
.TH XGOPHER 1 "Release 5" "X Version 11"
.SH NAME
xgopher - gopher client for the X window system
.SH SYNTAX
.PP
\fBxgopher\fP [\fIroot server\fP [\fIserver port\fP]] [-\fItoolkitoption\fP ...]
.PP
.SH DESCRIPTION
.PP
\fIxgopher\fP is an X window system client interface to the
gopher information server.  Xgopher provides access to tremendous
amounts of information which may be accessed from a local system
or a remote information server.  The source of the information
is generally transparent, with data supplied from world-wide
locations as easily as from a local on-campus server.

The Gopher information system software is from the University of Minnesota.

.SH OPTIONS
The installer of Xgopher normally configures the \fIroot server\fP and
\fIserver port\fP options.
Loosely speaking,
the root server is the network name of the computer system that
will provide your initial gopher menu.  The port is a number that
specifies system connection information.
These options may also be specified via the resources
described later in this document.  For convenience, these options
may be specified on the command line.
.PP
The X toolkit options are standard options available to every application
written using the X toolkit (Xt).  Please refer to your Xt documentation
for a list and description of these options.
.SH MAIN DISPLAY PANEL
.PP
The initial display will show the top level directory of gopher
information available.  Selecting an item from this list will
fetch the contents of a file, subdirectory, or other information.
The directory display may be updated to show the new subdirectory.

A gopher item is a menu entry in this directory list.  There are
many types of gopher items handled by Xgopher, and each is explained below.

An item is selected and highlighted by pointing at an entry
with the mouse and clicking the left button.
To unselect all items, click the mouse in either the directory
title area or bookmark title area.

You may select an entry in
either the upper directory list item or the lower bookmark list.
The display button marked 
\fBFetch selection\fP is used to act on the selection.  An
accelerator allows you to simply "click" a second time on
a highlighted item to activate the fetch.

By default, all interactions use only the left mouse button.

A directory is a collection of other files and directories.
The directory items are displayed in a list with an identifying
symbol to the left of each item.  The symbol identifies the type
of the item.  The symbols may be changed by the installer or
by each user.  The default symbols are:
.RS .5i
.TP 1.0i
blank
Text file
.TP 1.0i
>>
directory
.TP 1.0i
<cso>
a CSO name server (phone book)
.TP 1.0i
<idx>
a full text index search
.TP 1.0i
<tel>
a telnet session
.TP 1.0i
<tn3>
a tn3270 session
.TP 1.0i
<img>
an image file
.TP 1.0i
<bin>
a binary file
.TP 1.0i
<snd>
a sound file (spoken, sound effect, or music)
.RE 
.PP
The file types are discussed below.

From all but the top level directory, the \fBPrevious Directory\fP button
will return you to the previous directory that was displayed just
before this one.
A keyboard accelerator allows you to press the "u" key while
the X pointer is anywhere on the main panel to achieve the same
action.

.SH BOOKMARKS
If you are viewing a directory that you may wish to return to
later, set a bookmark there with the \fBAdd directory as bookmark\fP button.
This directory will be displayed with your other bookmarks in the 
lower scrolling region below the current directory list.

If you already have an item selected, the buttons label will now
read \fBAdd selection as bookmark\fP and the item will be added to
the bookmark list.

Later, no matter where you have browsed through the gopher
directory space, you may return to any bookmark by selecting
it just as you would a regular directory item.  You are brought
immediately to that marked directory,
The directory that you were
in when you selected the bookmark becomes the previous directory.

Other buttons and menu items let you remove individual bookmarks or
all of the bookmarks.

The main gopher directory that you see when you first start Xgopher
is normally marked for you so you can easily and quickly return
to the top level.

Bookmarks are normally saved between your Xgopher sessions.
When your start Xgopher, the file $HOME/.gopherrc is read to
load your previous bookmarks, if any.  When you exit Xgopher,
your current bookmark list is written back to this file.
Using the \fBOption panel\fP described below, you can change the
name of your bookmark file any number of times during an
Xgopher session, and use the \fBLoad bookmarks now\fP and
\fBSave bookmarks now\fP commands to manipulate several files
of bookmarks.

The bookmark save file should be compatible with the Unix
curses client, bookmark file.

Other resources described below that may affect bookmark
processing are: 
.B bookmarkFile, loadBookmarks, appendBookmarks, markRoot,
and
.B allowBookmarkSave.

.SH INFORMATION ABOUT ITEMS
Each gopher item and directory may be maintained by a remote
computer system anywhere in the world.  
Sometimes it can be difficult to determine where the information
is coming from.  You can at least display the raw information
which includes the name of the computer (host) that serves each
gopher item.

If you are viewing a directory with no items currently selected
click the button labeled \fBInfo about directory\fP, and
the information for this directory will be displayed.

If you already have an item selected, the buttons label will now
read \fBInfo about selection\fP and information about the selected
item will be shown.  The item that you select may be from either
the directory list or the bookmark list.

.SH GOPHER ITEM TYPES
.sp
.RS +.5i
.HE TEXT DISPLAYS
When the item selected from the directory list is a text file,
the contents of the file are fetched and displayed as a 
pop-up text display window.  Help information is displayed in
this way also.

The text display shows several command buttons and the text
itself in a vertically scrolling window.  The buttons are:
.ta 1i
.RS +.5i
.nf
\fBDone\fP	to release this text file and window,
\fBPage down\fP	to position the text down one page,
\fBPage up\fP	to position the text up one page,
\fBPrint\fP	to send the contents of this file to the printer,
\fBSave\fP	to save the contents of this file in a
	user-specified file.
.fi
.RE
.sp
The \fBPrint\fP or \fBSave\fP buttons may not always be available.
They may be disallowed by the installer or system-wide resources file for
Xgopher.
.PP
Text displays use the text widget from the MIT-supplied Athena
widget set.  The text is given a read-only attribute, but all
of the position, search, and selection capabilities of the 
widget are available.  For the user who knows how to use these
functions, there is this additional power.  For example, entering
control-S from the keyboard will bring up a text search panel
allowing you to scan for any string in the file.  Other control
sequences allow more flexible text positioning than is provided
by the scroll bar and paging buttons.  All of these options
are described in the Athena widget set documentation of the
text widget.

.HE CSO NAME SERVER (Phone Book)
When the item selected is a CSO name server,
a new window is displayed on the X display.  The name
of the institution supporting the name server is displayed
at the top of the window.  Below this are 4 areas.  First
are the control buttons: \fPDone\fP closes the CSO name server window;
\fBHelp\fP provides a text display with additional information;
and \fBShow Fields\fP, discussed below.

The next area is a single line text entry field where you type
the name of the person you are looking up.  The name server will
usually be able to find someone by first name, last name, or both.
Although, overly general searches are prohibited.  For example, trying to
look up "smith" is probably not a good idea in most of the United States.
After entering the name, type a carriage return (enter) or click
the mouse on the \fBDo query\fP button to submit the request.
Additional buttons in the third area allow you to clear
the query or result text areas.
The result is displayed in the forth area, the bottom scrolling text region.

The \fBShow Fields\fP button displays a pop up menu.
Select an item from this menu to
list the
names and a brief description of the fields in the data base being
searched.  Note that these fields may be different for every
institution!  Listing \fBdefault\fP fields will show the things that 
are returned for a normal query (usually name, address, phone number,
department, plus others).
\fBIndexed\fP fields are those that you can
use to search for (usually name and perhaps office phone).
\fBLookup\fP fields are those that can be used to narrow the search
(for example, department).
Finally, \fBPublic\fP fields are all the 
fields that can be viewed by everyone.

A query may include more than just a name, for example, legitimate
queries are:
.RS .5i

.IP "john smith" .5i
.br
This will return every John Smith in the selected data base.
If there are more than a handful, the name server will complain
that there are too many to give you.  In this case, you may
want to try the next example.

.IP "smith department=biology" .5i
The department will help narrow the search to only those
people in the department of biology.

.IP "j* smith department=biology" .5i
A "*" matches any characters and will help if you are not
sure of the exact spelling of a name or only know initials.

.IP "john smith department=biology return all" .5i
The return option may specify a field you are interested in
or the value "all" to get all public fields returned.
.RE

The CSO name server window may be left on the X display as long as
you like.  Once displayed, it operates independent of the 
gopher directory traversal.  If you want to switch to search
another institution's phone directory you can select it
from the appropriate directory list without first closing a
prior CSO name server window.  The same window is re-used for the
currently selected institution.

.HE INDEX SEARCH
An index search is a very powerful way of obtaining a list
of documents which contain (or do not contain) certain words.
When you select an index search item, a small pop-up panel
asks you for a list of search words.  You can enter one or
more words, plus the special reserved boolean operators
\fBand\fP, \fBor\fP, and \fBnot\fP.  For example, if you want
information on setting certain terminal parameters for Unix,
you may enter:
.RS .5i

terminal and setting or tset

.RE
which will find all documents in the search space which contain
both the words "terminal" and "setting", or the word "tset".  The
"or" is non-exclusive so the document may contain all of the words.
The input words may be in upper- or lower-case, and will match
words of either case.

After entering the words, press carriage return (enter) or click
the mouse on the \fBDo query\fP button and the search will be carried
out.

The result of the index search looks very much like a normal
gopher directory of text files,
but each file is one that matches
your specified criterion.

You will see a difference in the display of the text file, however.
Every word (or part of a word) that matches the index words will be
highlighted in the text display.  This allows you to quickly
locate the parts of a document that are interesting to you.

.HE TELNET SESSION
Telnet sessions are normally text-based information services,
for example access to University library holdings.

When you select an item which is identified as a telnet session,
A new xterm window (normal terminal emulator window) will be created
and it will be running a telnet session.
It may take a few seconds for the xterm window to show up.
Some hosts that you connect to may require you to enter a
username (login name).  If so, then Xgopher will pop up an
information window showing you the name to use once the
telnet session is started.
Many telnet sessions require you to enter a terminal type as
a part of the startup interaction.  Usually, you should choose
\fBvt100\fP, as the xterm commands are very similar to that
of a DEC VT100 terminal.

Telnet sessions may be disallowed by the 
\fBallowTelnet\fP resource described below.
If telnet sessions are not allowed, an error message will be displayed to 
that effect.

.HE TN3270 SESSION
tn3270 sessions are normally text-based information services; similar
in concept to telnet sessions, but using a different terminal emulation
protocol.

When you select an item which is identified as a tn3270 session,
A new xterm window (normal terminal emulator window) will be created
and it will be running a tn3270 session.
It may take a few seconds for the xterm window to show up.
Some hosts that you connect to may require you to enter a
username (login name).  If so, then Xgopher will pop up an
information window showing you the name to use once the
tn3270 session is started.

tn3270 sessions may be disallowed by the 
\fBallowTn3270\fP resource described below.
If tn3270 sessions are not allowed, an error message will be displayed to 
that effect.

For the X window system, 
X3270 is an alternative to tn3270 that many people prefer.  Whereas
tn3270 executes as an application within an xterm window and doesn't
understand X at all, X3270 is a true X application.

tn3270 is available (vendor-supplied) on most Unix systems.  X3270
is publicly available software, but not supplied as a part of Xgopher.
If your site provides the X3270 program, you may use it instead of tn3270.

The IBM 3278 terminal character set and behavior is closely emulated by
X3270.  Colors are used to distinguish normal, bold, and input fields.
Every key on the keyboard may be mapped to a 3278 function using
one of the supplied keyboard maps or the X application defaults file.

The following commands are usually built into Xgopher or the system
resources file when the program is installed, but you may modify
your own application resources to use a command such as the following
for tn3270:

    xterm -e tn3270     or     aixterm -e tn3270 (for IBM AIX systems)

If you choose X3270 instead, the command is:

    x3270

.HE IMAGES

When an image file is selected for processing, Xgopher retrieves the
file, then runs another program to display the image on an X display.
This second program is often \fIxloadimage\fP.  The installer of Xgopher,
or any user, may change this to be any other program that is available.
\fIxloadimage\fP is a particularly nice program because it will display
other file types besides GIF using heuristics to determine the type
of the file.

The \fBimageCommand\fP resource specifies the command that will be
used to display the image.
Interesting choices are:

.ta 2i
.RS .5i
    xloadimage	(normal behavior, with messages output)
    xloadimage -quiet	(the Xgopher default - no messages)
    xv	(another nice gif viewer available)
.RE

Neither \fIxloadimage\fP nor \fIxv\fP are
a part of the Xgopher distribution.  Many sites that
run X already have one of these programs installed.

A large image may take many seconds to appear as considerable processing
may be required before the display.
Several images may be displayed at once.
The way to remove an image depends on the command used to display the
image.  For \fIxloadimage\fP, typing the letter "q" within the picture
display will remove the image.

The \fBallowImage\fP resource may be used to disallow processing
of image files.
.HE BINARY FILES
Binary file types are not precisely defined in the gopher community,
but many Unix files that are compressed (.Z) or tar archives (.tar)
are assigned the same binary item type in gopher (type 9). 
When you select one of these files, Xgopher prompts you for a file
name on your local system.  
The dialog box that pops up for this file name will suggest the
same name as the remote file; you may change this name if it is
not satisfactory.
The files are then processed (or fetched) by simply copying 
the data to your specified file.
Processing a binary type of gopher item with the \fBFetch selection\fP button is
identical to using the \fBCopy\fP command on the same item.
.sp
The \fBallowCopy\fP resource determines whether copying is allowed.  If
not, a message is displayed.
.HE SOUNDS
If your X display is a workstation that supports sounds,
then you can play files containing spoken words, sound effects,
or music through Xgopher.  Selecting a sound file will
cause that file to be "played" through your workstation's
audio device.  Only a single sound file can be active at a time;
you will be warned if you try to play a sound before
a previous one is through.  Use the application resources
\fBhasSound\fP and \fBsoundCommand\fP described below.

.RE
.SH COPYING FILES DIRECTLY
The Copy item in the Other Commands menu can be used to copy a
gopher item directly to a file without first processing or displaying
the gopher data.
If the item type is a text file, an ascii mode copy will be done,
preserving end-of-line conventions for your system.  Other data
files and unknown item types are copied in binary mode until an
end of file is encountered.
It makes no sense to copy directories, CSO name servers, index
directories, or telnet sessions, so the copy command will reject
requests to copy these.

When you chose the \fBCopy\fP command, Xgopher prompts you for a file
name on your local system.  
The dialog box that pops up for this file name will suggest the
same name as the remote file; you may change this name if it is
not satisfactory.


The \fBcopy\fP command is one way to access gopher item types
that are not normally processed by Xgopher.
.sp
If the \fBallowCopy\fP resource is false, then the \fBcopy\fP command is
not shown in the menu.

.SH DIRECT ENTRY OF A GOPHER ITEM
This function is not for the beginning or casual user of Gopher.
Sometimes a reference is available to a specific gopher item 
available, perhaps without specifying all the menus to traverse.
If you know all the access information for a piece of data anywhere in
gopher space, you may use
the \fBEnter Gopher Item\fP command in the \fBOther Commands\fP
menu to directly
access this data.  When you select this command a panel is displayed
for you to enter the type, path, host, port, and optionally name of 
the item.  A help display is available to explain these items a bit
more.
.sp
A neat trick: Any gopher data can be fetched as a text file by
entering its host/path/port and setting the type to 0 (ascii text file).
Even a directory can be fetched as text in this way.  Similarly, any
gopher data may be retrieved as binary by setting the type to 9 (binary
file type).  This works even for types unknown to Xgopher.

.SH OPTIONS PANEL
Some Xgopher options may be changed during a session.  These
are available on the \fBOptions Panel\fP pop up display
which is selected from the \fBOther Commands\fP menu.
The bookmark file, and system commands for printing, image
display, and telnet sessions may be changed using this panel.

A help display is available with this panel to further describe
the options.
.sp
If the \fBoptionsButton\fP resource is false, then the \fBOptions Panel\fP
command is not shown in the menu.
.SH RESOURCES
.PP
The application class is \fBXgopher\fP.  Most of the user-interface
is configured in the app-defaults file; if this file is missing
a warning message will be printed to standard error and the
program will terminate.  All of the important defaults are
established in the system app-defaults file, normally installed
as /usr/lib/X11/app-defaults/Xgopher.
.PP
The defaults mentioned below may have been changed by the
installer for a specific system.  They may all be overridden
in by individual preferences.  The application specific resources
are grouped below by category.

\fBStartup\fP
.RS .5i
.TP 8
.B "rootServer (\fPclass\fB RootServer)"
Specifies the initial gopher information server host name
as an internet address.
.TP 8
.B "rootPort (\fPclass\fB RootPort)"
The port number of the top level gopher server to connect to.
The supplied default is 70.
.TP 8
.B "rootPath (\fPclass\fB RootPath)"
The initial selector string or path name to retireve the top level
menu.
The supplied default is the null string.
.TP 8
.B "helpFile (\fPclass\fB HelpFile)"
This is the absolute or relative path name of the file to be
displayed when the \fIhelp\fP command button is depressed.
The supplied default is /usr/lib/X11/xgopher/xgopher.help
.TP 8
.B "mainTitle (\fPclass\fB MainTitle)"
The main title displayed above the listing of the top level directory.
The supplied default is "UIUC Gopher Information Service".
.TP 8
.B "bookmarkFile (\fPclass\fB bookmarkFile)"
The name of the file containing Xgopher bookmarks.  This is also
the file that bookmarks will be written to when you exit Xgopher.
This file name may be changed during a session using the options
panel.
The supplied default is "$HOME/.gopherrc".
.TP 8
.B "loadBookmarks (\fPclass\fB loadBookmarks)"
Whether or not to load bookmarks automatically when Xgopher starts.
The supplied default is True.
.RE

\fBExternal Commands\fP
.RS .5i
.TP 8
.B "printCommand (\fPclass\fB PrintCommand)"
This is the print command used to spool a print request.  Useful
examples of print commands are \fIlpr\fP or \fIenscript\fP.  The gopher
internal file name containing the text is appended to the end of the
command supplied.  As an option, if the 2 characters %s appear in the
print command string anywhere, they are replaced by the file name.
The %s may even appear more than once.  If %s appears, then the file
name is not appended to the end.
The supplied default is: "# print" without the quotes.  It is a comment.
.TP 8
.B "telnetCommand (\fPclass\fB TelnetCommand)"
The command Xgopher will use to start a telnet session.
The host and port number are added to the end of this command.
The resulting command is executed
(via the \fIsystem(3)\fP function) to provide a telnet session.
In general, the telnet command should be executed by an xterm
as with the default (\fIxterm -e telnet\fP).
In some environments (such as OpenWindows), it may be useful
to specify the full path name of both the xterm and telnet commands.
For example, \fI/usr/bin/X11/xterm -e /usr/ucb/telnet\fP.
This command should be disabled for secure environments such as
public access terminals, as it is easy to start a shell from a
telnet session.
The supplied default is "xterm -e telnet" (without the quotes).
.TP 8
.B "tn3270Command (\fPclass\fB Tn3270Command)"
The command Xgopher will use to start a tn3270 session.
The host and port number are added to the end of this command.
The resulting command is executed
(via the \fIsystem(3)\fP function) to provide a tn3270 session.
In general, the tn3270 command should be executed by an xterm
as with the default (\fIxterm -e tn3270\fP).
In some environments (such as OpenWindows), it may be useful
to specify the full path name of both the xterm and tn3270 commands.
For example, \fI/usr/bin/X11/xterm -e /usr/ucb/tn3270\fP.
This command should be disabled for secure environments such as
public access terminals, as it is easy to start a shell from a
tn3270 session.  Examples of useful tn3270 commands are:

    Xgopher.tn3270Command:       xterm -e tn3270
    Xgopher.tn3270Command:       aixterm -e tn3270 (for IBM AIX systems)
    Xgopher.tn3270Command:       x3270

The supplied default is "xterm -e tn3270" (without the quotes).
.TP 8
.B "imageCommand (\fPclass\fB ImageCommand)"
The command to use to display an image file to the X display
screen.  The name of the local temporary file containing the
image is appended to the end of this command before it is executed.
This command is never executed if
the \fBallowImage\fP resource is False.
The supplied default is "xloadimage -quiet" (without the quotes).
.TP 8
.B "soundCommand (\fPclass\fB SoundCommand)"
The command to use to get a sound file from the standard input
stream (\fIstdin\fP) to the audio device.  On many workstations
this command may be called "\fIplay\fP".  Another command which
may be useful is "\fIcat > /dev/audio\fP".  The supplied command
is started by Xgopher as a separate process with sound data fed
into its standard input.  This command is never executed if
the \fBhasSound\fP resource is False.
The supplied default is "play" (without the quotes).
.RE

\fBBehaviour\fP
.RS .5i
.TP 8
.B "allItems (\fPclass\fB AllItems)"
Show all gopher items, even types not understood by Xgopher.
When false, some items may not be displayed as Xgopher has
no idea what to do with them.
The supplied default is True.
.TP 8
.B "appendBookmarks (\fPclass\fB AppendBookmarks)"
When this resource is true, loading a new bookmark file will
append the new bookmarks to your current list.  When false,
the new bookmarks will replace the current list.
The supplied default is True.
.TP 8
.B "doubleClick (\fPclass\fB DoubleClick)"
Normally a gopher item or directory is selected by "clicking" on
it.  Then the \fIFetch\fP button is pressed to process the request.
If this resource is true, the fetch action may be invoked by
simply re-selecting the same item already selected.  This is
a double-click on that item, although with no time limit between
clicks.
It may be disabled for example, if a touch sensitive
screen replaces the mouse, to ensure more reliable operation.
The supplied default is True.
.TP 8
.B "markRoot (\fPclass\fB MarkRoot)"
When true, a bookmark is automatically set at the top lever (root)
directory.  If you do not want to have this bookmark set, change
the value of this resource to False.
The supplied default is True.
.TP 8
.B "resetOptions (\fPclass\fB ResetOptions)"
Options changed on the options panel popup will be reset to their
original default values when a restart command occurs if this resource
is true.
The supplied default is True.
.TP 8
.B "logFile (\fPclass\fB LogFile)"
If a file name is provided, all directory changes, remote host
connections, and errors are logged to this file.  If nothing
else, it provides a trail of where you have been and allows
some simple diagnostics to determine what remote machines
are not accessible.  If no file name is provided, no logging occurs.
The supplied default is no log file.
.TP 8
.B "hasSound (\fPclass\fB HasSound)"
This flag indicated whether the X display being used has the
ability to play general sounds, such as spoken words, sound effects, 
and music.  For example, an X terminal will not normally have this
ability, but some workstations such as the Sun SparcStation can play
sounds.
The supplied default is False.
.RE

\fBSecurity\fP
.RS .5i
.TP 8
.B "allowPrint (\fPclass\fB AllowPrint)"
If this boolean resource is true, text displayed in pop up windows
may be spooled to a printer by depressing a \fIPrint\fP button.
If False, the button will not be displayed.
The supplied default is True.
.TP 8
.B "allowSave (\fPclass\fB AllowSave)"
If this boolean resource is true, text displayed in pop up windows
may be saved to a user-specified file by depressing a \fISave\fP button.
If False, the button will not be displayed.
The supplied default is True.
.TP 8
.B "allowTelnet (\fPclass\fB AllowTelnet)"
If this boolean resource is true, telnet sessions are allowed.
If False, they are inhibited with an error message displayed to 
that effect.
This resource should be False in secure environments such as
public access terminals, as it is easy to start a shell from a
telnet session.
The supplied default is True.
.TP 8
.B "allowTn3270 (\fPclass\fB AllowTn3270)"
If this boolean resource is true, tn3270 sessions are allowed.
If False, they are inhibited with an error message displayed to 
that effect.
This resource should be False in secure environments such as
public access terminals, as it is easy to start a shell from a
tn3270 session.
The supplied default is True.
.TP 8
.B "allowCopy (\fPclass\fB AllowCopy)"
If this boolean resource is true, the \fBCopy\fP button is displayed
and files may be directly copied to a user-specified file.  Also,
binary files may be fetched.
If False, the button will not be displayed, and binary file access
will be disallowed.
The supplied default is True.
.TP 8
.B "allowBookmarkSave (\fPclass\fB AllowBookmarkSave)"
The current bookmark list will be written to the current bookmark
file when you exit or restart Xgopher if this resource is true.
The bookmark file name may be changed during a session using the options
panel.
The supplied default is True.
.TP 8
.B "allowImage (\fPclass\fB AllowImage)"
If this boolean resource is true, image display is allowed.
If false, it is inhibited with an error message displayed to 
that effect.
The supplied default is True.
.TP 8
.B "optionsButton (\fPclass\fB OptionsButton)"
The \fBOptions panel\fP button in the \fBOther Commands\fP menu
will not be displayed if this resource is false.  Then, no
resources may be changed during a session.
The supplied default is True.
.TP 8
.B "restartButton (\fPclass\fB RestartButton)"
If false, the \fBRestart\fP command button in the \fBOther Options\fP
menu will not be displayed.  This is most useful in conjunction with
the \fBswapRestartAndQuit\fP resource.
The supplied default is True.
.TP 8
.B "swapRestartAndQuit (\fPclass\fB SwapRestartAndQuit)"
If true, the functions of the quit and restart buttons are swapped.
Remember to also change the button labels.  This may be used in a
public-access Xgopher terminal to easily retreat to a known state,
but not-too-easily terminate Xgopher entirely.
The supplied default is False.
.RE

\fBPrefixes\fP
.RS .5i
.TP 8
.B "prefixFile (\fPclass\fB PrefixFile)"
This prefix is shown in the directory listing to the left of
text files.
The supplied default is blank for text files.
.TP 8
.B "prefixDir (\fPclass\fB PrefixDir)"
This prefix is shown in the directory listing to the left of
directory entries.
The supplied default is \273 (an octal escape sequence),
which is a single character in the
Latin-1 character set which looks like \fI>>\fP.
.TP 8
.B "prefixCSO (\fPclass\fB PrefixCSO)"
This prefix is shown in the directory listing to the left of
entries which are CSO name servers (phone books).
The supplied default is <cso>.
.TP 8
.B "prefixTelnet (\fPclass\fB PrefixTelnet)"
This prefix is shown in the directory listing to the left of
entries which are telnet sessions.
The supplied default is <tel>.
.TP 8
.B "prefixTn3270 (\fPclass\fB PrefixTn3270)"
This prefix is shown in the directory listing to the left of
entries which are tn3270 sessions.
The supplied default is <tn3>.
.TP 8
.B "prefixIndex (\fPclass\fB PrefixIndex)"
This prefix is shown in the directory listing to the left of
entries which are full text index searches.
The supplied default is <idx>.
.TP 8
.B "prefixImage (\fPclass\fB PrefixImage)"
This prefix is shown in the directory listing to the left of
entries which are image files.
The supplied default is <img>.
.TP 8
.B "prefixBinary (\fPclass\fB PrefixBinary)"
This prefix is shown in the directory listing to the left of
entries which are binary files.
The supplied default is <bin>.
.TP 8
.B "prefixSound (\fPclass\fB PrefixSound)"
This prefix is shown in the directory listing to the left of
entries which are sound files.
The supplied default is <snd>.
.TP 8
.B "prefixUnknown (\fPclass\fB PrefixUnknown)"
This prefix is shown in the directory listing to the left of
entries which are unknown file types.
This prefix is displayed if \fBallItems\fP is true. 
The supplied default is <???>.
.RE

\fBPerformance and Configuration\fP
.RS .5i
.TP 8
.B "directoryTime (\fPclass\fB DirectoryTime)"
Directory entries for all active directories (current directory, 
directories with bookmarks, and all of their ancestors) are saved
for this many seconds.  After this time, their contents are released
and re-requested from the appropriate place when needed.  This caching
of directory contents makes moving up the directory tree and jumping
to bookmarks quite fast.  The very small potential risk is that the
contents of a directory in a gopher server may be changed while
the directory is stored.  The caching, freeing, and reloading
of directories is transparent to the user.
The supplied default is 600.  This is 10 minutes.
.TP 8
.B "itemStart (\fPclass\fB ItemStart)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated when xgopher starts execution to hold
gopher items (directory contents).
The supplied default is 500.
.TP 8
.B "itemIncrement (\fPclass\fB ItemIncrement)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated each time xgopher needs additional 
memory to hold gopher items (directory contents).
The supplied default is 50.
.TP 8
.B "dirStart (\fPclass\fB DirStart)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated when xgopher starts execution to hold
gopher directories.
The supplied default is 50.
.TP 8
.B "dirIncrement (\fPclass\fB DirIncrement)"
Not normally changed by the user, this determines the amount of 
memory dynamically allocated each time xgopher needs additional
memory to hold gopher directories.
The supplied default is 10.
.TP 8
.B "tempDirectory (\fPclass\fB TempDirectory)"
The directory for xgopher to create files that it will need
for display or other purposes, but will not exist beyond this
xgopher session.
The supplied default is /tmp.
.RE
.PP
\fBWidget specific resources:\fP
.PP
The X Toolkit and Athena Widgets documentation covers the
widget specific resources.
The most significant widget specific resources are mentioned here.
.TP 8
.B "font (\fPclass\fB Font)"
All text, label, and command button widgets have a font that can be selected.
.TP 8
.B "label (\fPclass\fB Label)"
All command button widgets and many labels text strings may be
changed, for example to another language.
.PP
.SH FILES
.PP
 /usr/local/lib/X11/app-defaults/Xgopher
.PP
 /usr/local/lib/X11/xgopher.help
.PP
.SH SEE ALSO
.PP
Installers should see the internal documentation for
changes to the configuration file before compiling and
installing Xgopher.
.SH BUGS
.PP
The gopher+ protocol is not yet supported.
.SH COPYRIGHT
Copyright 1992 by the Board of Trustees of the University of Illinois
.br
This program with copyright notice intact may be freely
distributed without permission.
.SH AUTHOR
.PP
Allan Tuchman, Computing and Communications Services Office,
University of Illinois at Urbana-Champaign, Urbana, Illinois, USA.
email to: a-tuchman@uiuc.edu.
