/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"config.h"
#include	"fips_def.h"
#include	"fips_LS.h"
#ifndef SCH_TEST
# include       "sch_conf.h"
#endif  /* SCH_TEST */


/*
 * This program generates a macro for us as the permutation.
 *
 *		LS(n, CD)
 *
 * The input is an integer`n' indicating current step and the usigned long
 * `CD'.
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int	i;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

	(void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\tls = {\n", base);
		for (i = 0; i < DES_ITERATIONS - 1; i++)
			(void) printf("\t\t\t\t%d, /* Iteration %2d */\n", ls[i], i + 1);
		(void) printf("\t\t\t\t%d  /* Iteration %2d */\n\t\t\t};\n", ls[i], i + 1);
	} else {
		(void) printf("#define LS(n, CD) \\\n");
		(void) printf("\tif(CD & 0x1l) \\\n");
		(void) printf("\t\tCD |= 0x10000000l; \\\n");
		(void) printf("\tif(ls[n] == 2) { \\\n");
		(void) printf("\t\tif(CD & 0x2l) \\\n");
		(void) printf("\t\t\tCD |= 0x20000000l; \\\n");
		(void) printf("\t\tCD >>= 2; \\\n");
		(void) printf("\t} else \\\n");
		(void) printf("\t\tCD >>= 1\n\n");
		(void) printf("typedef unsigned char\t%s_t[%d];\n\n", base, DES_ITERATIONS);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\tls;\n", base);
	}

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
